/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugBackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugTransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Job;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Result;
import com.vaadin.kubernetes.starter.ui.SessionDebugNotifier;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationDebugRequestHandler
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationDebugRequestHandler.class);
    public static final String SERIALIZATION_TEST_REQUEST_ATTRIBUTE_KEY = SerializationDebugRequestHandler.class.getName() + ".RESULT";

    public boolean handleRequest(VaadinSession vaadinSession, VaadinRequest vaadinRequest, VaadinResponse vaadinResponse) {
        ApplicationConfiguration appConfiguration = ApplicationConfiguration.get((VaadinContext)vaadinSession.getService().getContext());
        if (appConfiguration.isProductionMode()) {
            LoggerFactory.getLogger(InitListener.class).warn("SerializationDebugRequestHandler in not enabled in production mode");
            return false;
        }
        if (!appConfiguration.isDevModeSessionSerializationEnabled()) {
            LoggerFactory.getLogger(InitListener.class).warn("SerializationDebugRequestHandler is enabled only with enable session serialization setting 'vaadin.devmode.sessionSerialization.enabled=true'");
            return false;
        }
        if (HandlerHelper.isRequestType((VaadinRequest)vaadinRequest, (HandlerHelper.RequestType)HandlerHelper.RequestType.UIDL)) {
            try {
                VaadinService vaadinService = vaadinSession.getService();
                vaadinSession.accessSynchronously((Command & Serializable)() -> {
                    SerializableConsumer onSuccess = null;
                    UI ui = vaadinService.findUI(vaadinRequest);
                    if (ui != null) {
                        boolean pushEnabled = ui.getPushConfiguration().getPushMode().isEnabled();
                        SessionDebugNotifier debugNotifier = ui.getChildren().filter(SessionDebugNotifier.class::isInstance).map(SessionDebugNotifier.class::cast).findAny().orElseGet(() -> {
                            SessionDebugNotifier notifier = new SessionDebugNotifier();
                            ui.add(new Component[]{notifier});
                            return notifier;
                        });
                        if (pushEnabled) {
                            onSuccess = ui.accessLater(debugNotifier::publishResults, (SerializableRunnable & Serializable)() -> {});
                        }
                    }
                    vaadinRequest.setAttribute(SERIALIZATION_TEST_REQUEST_ATTRIBUTE_KEY, (Object)new Runner((Consumer<Result>)onSuccess));
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Error during serialization debug", (Throwable)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeAndDeserialize(WrappedSession session, Consumer<Result> onComplete) {
        DebugHttpSession debugHttpSession = new DebugHttpSession(session);
        Job job = new Job(session.getId());
        DebugBackendConnector connector = new DebugBackendConnector(job);
        SessionSerializer serializer = new SessionSerializer(connector, new DebugTransientHandler(job));
        try {
            SerializationDebugRequestHandler.trySerialize(serializer, debugHttpSession, job);
            SessionInfo info = connector.waitForCompletion(LOGGER);
            if (info != null) {
                debugHttpSession = new DebugHttpSession("DEBUG-DESERIALIZE-" + session.getId());
                SerializationDebugRequestHandler.tryDeserialize(serializer, info, debugHttpSession, job);
            }
        }
        finally {
            List<String> notSerializableClasses;
            Result result = job.complete();
            StringBuilder message = new StringBuilder("Session serialization attempt completed in ").append(result.getDuration()).append(" ms with outcomes: ").append(result.getOutcomes());
            List<String> errors = result.getErrors();
            if (!errors.isEmpty()) {
                message.append(System.lineSeparator()).append(System.lineSeparator()).append("ERRORS DURING SERIALIZATION/DESERIALIZATION PROCESS:").append(System.lineSeparator()).append("====================================================").append(System.lineSeparator()).append(String.join((CharSequence)(System.lineSeparator() + System.lineSeparator()), errors));
            }
            if (!(notSerializableClasses = result.getNotSerializableClasses()).isEmpty()) {
                message.append(System.lineSeparator()).append(System.lineSeparator()).append("NOT SERIALIZABLE CLASSES FOUND:").append(System.lineSeparator()).append("===============================").append(System.lineSeparator()).append(System.lineSeparator()).append(String.join((CharSequence)System.lineSeparator(), notSerializableClasses));
            }
            LOGGER.info(message.toString());
            onComplete.accept(result);
        }
    }

    private static void trySerialize(SessionSerializer serializer, HttpSession session, Job job) {
        try {
            serializer.serialize(session);
        }
        catch (Exception e) {
            job.serializationFailed(e);
            LOGGER.error("Test Session serialization failed", (Throwable)e);
        }
    }

    private static void tryDeserialize(SessionSerializer serializer, SessionInfo info, HttpSession debugHttpSession, Job job) {
        try {
            serializer.deserialize(info, debugHttpSession);
            job.deserialized();
        }
        catch (Exception e) {
            job.deserializationFailed(e);
            LOGGER.error("Test Session Deserialization failed", (Throwable)e);
        }
    }

    public static class InitListener
    implements VaadinServiceInitListener {
        public void serviceInit(ServiceInitEvent serviceInitEvent) {
            ApplicationConfiguration appConfiguration = ApplicationConfiguration.get((VaadinContext)serviceInitEvent.getSource().getContext());
            Logger logger = LoggerFactory.getLogger(InitListener.class);
            if (appConfiguration.isProductionMode()) {
                logger.warn("SerializationDebugRequestHandler cannot be installed in production mode");
            } else if (!appConfiguration.isDevModeSessionSerializationEnabled()) {
                logger.warn("To install SerializationDebugRequestHandler enable session serialization setting 'vaadin.devmode.sessionSerialization.enabled=true'");
            } else if (!DebugMode.isTrackingAvailable(logger)) {
                logger.warn("SerializationDebugRequestHandler cannot be installed if above preconditions are not met");
            } else {
                logger.info("Installing SerializationDebugRequestHandler for session serialization debug");
                serviceInitEvent.addRequestHandler((RequestHandler)new SerializationDebugRequestHandler());
            }
        }
    }

    private static class DebugHttpSession
    implements HttpSession {
        private final Map<String, Object> storage = new HashMap<String, Object>();
        private final String sessionId;

        DebugHttpSession(String sessionId) {
            this.sessionId = sessionId;
        }

        DebugHttpSession(WrappedSession source) {
            this.sessionId = "DEBUG-SERIALIZE-" + source.getId();
            source.getAttributeNames().forEach(key -> this.storage.put((String)key, source.getAttribute(key)));
            this.storage.put("clusterKey", UUID.randomUUID() + "_SOURCE:" + source.getId());
        }

        public long getCreationTime() {
            return 0L;
        }

        public String getId() {
            return this.sessionId;
        }

        public long getLastAccessedTime() {
            return 0L;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public void setMaxInactiveInterval(int interval) {
        }

        public int getMaxInactiveInterval() {
            return 0;
        }

        public Object getAttribute(String name) {
            return this.storage.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.storage.keySet());
        }

        public void setAttribute(String name, Object value) {
            this.storage.put(name, value);
        }

        public void removeAttribute(String name) {
            this.storage.remove(name);
        }

        public void invalidate() {
        }

        public boolean isNew() {
            return false;
        }
    }

    static class Runner
    implements Consumer<HttpServletRequest> {
        private final Consumer<Result> onSuccess;

        public Runner(Consumer<Result> onSuccess) {
            this.onSuccess = onSuccess;
        }

        private void executeOnSuccess(Result result) {
            if (this.onSuccess != null) {
                try {
                    this.onSuccess.accept(result);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void accept(HttpServletRequest request) {
            HttpSession session = request.getSession(false);
            if (session != null && request.isRequestedSessionIdValid()) {
                SerializationDebugRequestHandler.serializeAndDeserialize((WrappedSession)new WrappedHttpSession(session), this::executeOnSuccess);
            }
        }
    }

    public static class Filter
    extends HttpFilter {
        private static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);

        protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            Object action = req.getAttribute(SERIALIZATION_TEST_REQUEST_ATTRIBUTE_KEY);
            if (action instanceof Runner) {
                LOGGER.debug("Vaadin Request processed, Running Session Serialized Debug Tool");
                ((Runner)action).accept(req);
            }
        }
    }
}

