/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import java.io.Serializable;
import java.util.function.ToIntFunction;

public final class Track
implements Serializable {
    public final int id;
    public final int depth;
    public final String stackInfo;
    private int handle = -1;
    public final String className;
    transient Object object;

    public Track(int id, int depth, String stackInfo, Object object) {
        this.id = id;
        this.depth = depth;
        this.stackInfo = stackInfo;
        this.object = object;
        this.className = object != null ? object.getClass().getName() : "NULL";
    }

    private Track(int depth, Class<?> type) {
        this.id = -1;
        this.depth = depth;
        this.stackInfo = null;
        this.object = null;
        this.className = type.getName();
    }

    public int getHandle() {
        return this.handle;
    }

    public Track assignHandle(ToIntFunction<Object> handleLookup) {
        if (this.object != null) {
            this.handle = handleLookup.applyAsInt(this.object);
        }
        return this;
    }

    public Track withEstimatedDepth(int depth) {
        return new Track(this.id, depth, null, this.object);
    }

    public Track withEstimatedHandle(int handle) {
        Track track = new Track(this.id, this.depth, null, this.object);
        track.handle = handle;
        return track;
    }

    public static Track unknown(int depth, Class<?> type) {
        return new Track(depth, type);
    }
}

