/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.kubernetes.starter.ui.SwitchVersionListener;
import com.vaadin.kubernetes.starter.ui.VersionNotifier;
import jakarta.servlet.http.Cookie;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSupport
implements VaadinServiceInitListener {
    private static final long serialVersionUID = 1L;
    public static final String ENV_APP_VERSION = "APP_VERSION";
    public static final String UPDATE_VERSION_HEADER = "X-AppUpdate";
    public static final String STICKY_CLUSTER_COOKIE = "INGRESSCOOKIE";
    private SwitchVersionListener switchVersionListener;
    private String appVersion;

    public static ClusterSupport getCurrent() {
        return (ClusterSupport)CurrentInstance.get(ClusterSupport.class);
    }

    public void setSwitchVersionListener(SwitchVersionListener listener) {
        this.switchVersionListener = listener;
    }

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        this.appVersion = System.getenv(ENV_APP_VERSION);
        if (this.appVersion == null) {
            ClusterSupport.getLogger().error("Missing environment variable 'APP_VERSION'. ClusterSupport service not initialized.");
            return;
        }
        ClusterSupport.getLogger().info("ClusterSupport service initialized. Registering RequestHandler with Application Version: " + this.appVersion);
        CurrentInstance.set(ClusterSupport.class, (Object)this);
        serviceInitEvent.addRequestHandler(this::handleRequest);
    }

    private boolean handleRequest(VaadinSession vaadinSession, VaadinRequest vaadinRequest, VaadinResponse vaadinResponse) {
        vaadinSession.access((Command & Serializable)() -> {
            String versionHeader = vaadinRequest.getHeader(UPDATE_VERSION_HEADER);
            vaadinSession.getUIs().forEach(ui -> {
                WrappedSession session = VaadinRequest.getCurrent().getWrappedSession();
                Optional<Component> versionNotifier = ui.getChildren().filter(child -> child instanceof VersionNotifier).findFirst();
                if (versionNotifier.isPresent()) {
                    if (versionHeader == null || versionHeader.isEmpty() || this.appVersion.equals(versionHeader)) {
                        ClusterSupport.getLogger().info("Removing notifier: updateVersion=" + versionHeader + ", appVersion=" + this.appVersion + ", session=" + session.getId());
                        ui.remove(new Component[]{versionNotifier.get()});
                    }
                } else if (versionHeader != null && !versionHeader.isEmpty() && !this.appVersion.equals(versionHeader)) {
                    VersionNotifier notifier = new VersionNotifier(this.appVersion, versionHeader);
                    notifier.addSwitchVersionEventListener((ComponentEventListener<VersionNotifier.SwitchVersionEvent>)((ComponentEventListener & Serializable)this::onComponentEvent));
                    ClusterSupport.getLogger().info("Notifying version update: updateVersion=" + versionHeader + ", appVersion=" + this.appVersion + ", session=" + session.getId());
                    ui.add(new Component[]{notifier});
                }
            });
        });
        return false;
    }

    private void onComponentEvent(VersionNotifier.SwitchVersionEvent event) {
        if (this.switchVersionListener != null) {
            if (!this.switchVersionListener.nodeSwitch(VaadinRequest.getCurrent(), VaadinResponse.getCurrent())) {
                return;
            }
            this.switchVersionListener.doAppCleanup();
        }
        this.removeStickyClusterCookie();
        WrappedSession session = VaadinRequest.getCurrent().getWrappedSession();
        ClusterSupport.getLogger().debug("Invalidating session " + session.getId());
        session.invalidate();
    }

    private void removeStickyClusterCookie() {
        ClusterSupport.getLogger().debug("Removing cookie '{}'.", (Object)STICKY_CLUSTER_COOKIE);
        Cookie cookie = new Cookie(STICKY_CLUSTER_COOKIE, "");
        cookie.setMaxAge(0);
        VaadinResponse.getCurrent().addCookie(cookie);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ClusterSupport.class);
    }
}

