/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.contextmenu.ContextMenuBase;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

@Tag(value="vaadin-context-menu-item")
@HtmlImport(value="frontend://bower_components/vaadin-item/src/vaadin-item.html")
public abstract class MenuItemBase<C extends ContextMenuBase<C, I, S>, I extends MenuItemBase<C, I, S>, S extends SubMenuBase<C, I, S>>
extends Component
implements HasText,
HasComponents,
HasEnabled {
    private final C contextMenu;
    private S subMenu;
    private boolean checkable = false;

    public MenuItemBase(C contextMenu) {
        this.contextMenu = contextMenu;
        this.getElement().addEventListener("click", (DomEventListener & Serializable)e -> {
            if (this.checkable) {
                this.setChecked(!this.isChecked());
            }
        });
    }

    public C getContextMenu() {
        return this.contextMenu;
    }

    public S getSubMenu() {
        if (this.subMenu == null) {
            this.subMenu = this.createSubMenu();
        }
        return this.subMenu;
    }

    public boolean isParentItem() {
        return ((SubMenuBase)this.getSubMenu()).getChildren().findAny().isPresent();
    }

    public void setCheckable(boolean checkable) {
        if (checkable && this.isParentItem()) {
            throw new IllegalStateException("A checkable item cannot have a sub menu");
        }
        this.checkable = checkable;
        if (!checkable) {
            this.setChecked(false);
        }
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setChecked(boolean checked) {
        if (this.isChecked() == checked) {
            return;
        }
        if (!this.checkable && checked) {
            throw new IllegalStateException("Trying to set a non-checkable menu item checked. Use setCheckable() to make the item checkable first.");
        }
        this.getElement().setProperty("_checked", checked);
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJavaScript("window.Vaadin.Flow.contextMenuConnector.setChecked($0, $1)", new Serializable[]{this.getElement(), Boolean.valueOf(checked)})));
    }

    public boolean isChecked() {
        return this.getElement().getProperty("_checked", false);
    }

    protected abstract S createSubMenu();
}

