/*
 * Copyright 2000-2017 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.component.grid.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * Base class for other random data generators used in the demo.
 * 
 * @author Vaadin Ltd.
 *
 */
abstract class BeanGenerator {

    /*
     * Each property of the bean should use its own Random instance. This
     * ensures that new added fields don't change the values of old fields
     * already present in the bean.
     */
    private final Map<String, Random> randomMap = new HashMap<>();

    protected Random getRandom(String propertyName) {
        return randomMap.computeIfAbsent(propertyName, key -> new Random(0));
    }
}
