/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4);
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared.ui.ui;

import com.vaadin.shared.annotations.NoLoadingIndicator;
import com.vaadin.shared.annotations.Delayed;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.ui.ClickRpc;

public interface UIServerRpc extends ClickRpc, ServerRpc {
    @Delayed(lastOnly = true)
    public void resize(int viewWidth, int viewHeight, int windowWidth,
            int windowHeight);

    @Delayed(lastOnly = true)
    public void scroll(int scrollTop, int scrollLeft);

    @NoLoadingIndicator
    @Delayed(lastOnly = true)
    /*
     * @Delayed just to get lastOnly semantics, sendPendingVariableChanges()
     * should always be called to ensure the message is flushed right away.
     */
    public void poll();
}
