/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util;

import com.intellij.diagnostic.DebugLogManager;
import com.vladsch.flexmark.util.collection.iteration.ArrayIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DebugLogSettings {
    final HashMap<String, DebugLogManager.DebugLogLevel> myOptions = new HashMap();

    public DebugLogSettings debug(CharSequence ... options) {
        return this.debug((Iterable<? extends CharSequence>)ArrayIterable.of((Object[])options));
    }

    public DebugLogSettings debug(@NotNull Iterable<? extends CharSequence> options) {
        for (CharSequence charSequence : options) {
            this.myOptions.put(charSequence.toString(), DebugLogManager.DebugLogLevel.DEBUG);
        }
        return this;
    }

    public DebugLogSettings trace(CharSequence ... options) {
        return this.trace((Iterable<? extends CharSequence>)ArrayIterable.of((Object[])options));
    }

    public DebugLogSettings trace(@NotNull Iterable<? extends CharSequence> options) {
        for (CharSequence charSequence : options) {
            this.myOptions.put(charSequence.toString(), DebugLogManager.DebugLogLevel.TRACE);
        }
        return this;
    }

    public DebugLogSettings remove(CharSequence ... options) {
        return this.remove((Iterable<? extends CharSequence>)ArrayIterable.of((Object[])options));
    }

    public DebugLogSettings remove(@NotNull Iterable<? extends CharSequence> options) {
        for (CharSequence charSequence : options) {
            this.myOptions.remove(charSequence.toString());
        }
        return this;
    }

    public List<DebugLogManager.Category> getLogCategories() {
        ArrayList<DebugLogManager.Category> categories = new ArrayList<DebugLogManager.Category>();
        for (Map.Entry<String, DebugLogManager.DebugLogLevel> entry : this.myOptions.entrySet()) {
            categories.add(new DebugLogManager.Category(entry.getKey(), entry.getValue()));
        }
        return categories;
    }

    public HashMap<String, DebugLogManager.DebugLogLevel> getOptions() {
        return this.myOptions;
    }
}

