/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.TextRange;
import com.vladsch.flexmark.util.sequence.Range;
import org.jetbrains.annotations.NotNull;

public class IntentionInfo
implements Comparable<IntentionInfo> {
    public static final IntentionInfo[] EMPTY_INTENTION_INFO = new IntentionInfo[0];
    public final boolean fileLevel;
    @NotNull
    public final IntentionAction action;
    @NotNull
    public final Range range;
    @NotNull
    public final IntentionInfo[] subActions;

    public IntentionInfo(boolean fileLevel, @NotNull IntentionAction action, @NotNull Range range, @NotNull IntentionInfo[] subActions) {
        this.fileLevel = fileLevel;
        this.action = action;
        this.range = range;
        this.subActions = subActions;
    }

    private int firstNonZero(int ... values) {
        for (int value : values) {
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    @Override
    public int compareTo(@NotNull IntentionInfo o) {
        int fileLevelCompare = this.fileLevel != o.fileLevel ? (this.fileLevel ? 1 : -1) : 0;
        int textCompare = this.action.getText().compareTo(o.action.getText());
        int rangeCompare = this.range.compare(o.range);
        return this.firstNonZero(fileLevelCompare, textCompare, rangeCompare);
    }

    public static IntentionInfo of(boolean fileLevel, @NotNull IntentionAction action) {
        return new IntentionInfo(fileLevel, action, Range.NULL, EMPTY_INTENTION_INFO);
    }

    public static IntentionInfo of(boolean fileLevel, @NotNull IntentionAction action, @NotNull Range range, @NotNull IntentionInfo[] subActions) {
        return new IntentionInfo(fileLevel, action, range, subActions);
    }

    public static IntentionInfo of(boolean fileLevel, @NotNull IntentionAction action, @NotNull TextRange range, @NotNull IntentionInfo[] subActions) {
        return new IntentionInfo(fileLevel, action, Range.of((int)range.getStartOffset(), (int)range.getEndOffset()), subActions);
    }
}

