/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.plugin.test.util.cases.CodeInsightFixtureSpecTestCase;
import com.vladsch.plugin.test.util.cases.SpecTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class LightPlatformCodeInsightFixtureSpecTestCase
extends BasePlatformTestCase
implements CodeInsightFixtureSpecTestCase {
    @Rule
    public final ExpectedException myThrown = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    @NotNull
    public SpecExample myExample = SpecExample.NULL;
    private static final Map<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();
    private final Map<String, ? extends DataHolder> myOptionsMap;
    @NotNull
    private final DataHolder myDefaultOptions;

    @Before
    public void before() throws Throwable {
    }

    @After
    public void after() throws Throwable {
        this.checkJavaSwingTimersAreDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void checkJavaSwingTimersAreDisposed() {
        try {
            timerQueueClass = Class.forName("javax.swing.TimerQueue");
            sharedInstance = timerQueueClass.getMethod("sharedInstance", new Class[0]);
            sharedInstance.setAccessible(true);
            timerQueue = sharedInstance.invoke(null, new Object[0]);
            delayQueue = (DelayQueue)ReflectionUtil.getField(timerQueueClass, (Object)timerQueue, DelayQueue.class, (String)"queue");
            while (true) lbl-1000:
            // 3 sources

            {
                if ((timer = delayQueue.peek()) == null) {
                    return;
                }
                delay = Math.toIntExact(timer.getDelay(TimeUnit.MILLISECONDS));
                text = "(delayed for " + delay + "ms)";
                getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
                swingTimer = (Timer)getTimer.invoke(timer, new Object[0]);
                text = "Timer (listeners: " + Arrays.toString(swingTimer.getActionListeners()) + ") " + text;
                try {
                    System.out.println("Not disposed javax.swing.Timer: " + text + "; queue:" + timerQueue);
                }
                finally {
                    swingTimer.stop();
                    continue;
                }
                break;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        ** GOTO lbl-1000
    }

    public LightPlatformCodeInsightFixtureSpecTestCase(@Nullable Map<String, ? extends DataHolder> optionMap, DataHolder ... defaultOptions) {
        DataHolder options = TestUtils.combineDefaultOptions((DataHolder[])defaultOptions);
        this.myDefaultOptions = options == null ? new DataSet() : options;
        this.myOptionsMap = CodeInsightFixtureSpecTestCase.optionsMaps(optionsMap, optionMap);
    }

    public final DataHolder options(@NotNull String option) {
        return TestUtils.processOption(this.myOptionsMap, (String)option);
    }

    @Test
    public final void test_case() {
        this.defaultTestCase();
    }

    @Override
    @NotNull
    public final DataHolder getDefaultOptions() {
        return this.myDefaultOptions;
    }

    @Override
    public final CodeInsightTestFixture getFixture() {
        return this.myFixture;
    }

    @Override
    public final Logger LOG() {
        return LOG;
    }

    @Override
    @NotNull
    public final SpecExample getExample() {
        return this.myExample;
    }

    @Override
    @NotNull
    public final ExpectedException getThrown() {
        return this.myThrown;
    }

    @Override
    @NotNull
    public final TempDirTestFixture getTempDirFixture() {
        return this.getFixture().getTempDirFixture();
    }

    @Override
    public final Project getProject() {
        return super.getProject();
    }

    @Override
    public final PsiManager getPsiManager() {
        return super.getPsiManager();
    }

    @Override
    public final PsiFile createLightFile(FileType fileType, String text) {
        return super.createLightFile(fileType, text);
    }

    @Override
    public final PsiFile createLightFile(String fileName, Language language, String text) {
        return super.createLightFile(fileName, language, text);
    }

    @Override
    @NotNull
    public final Module getModule() {
        return super.getModule();
    }

    @Override
    public final void addSuppressedException(@NotNull Throwable e) {
        super.addSuppressedException(e);
    }

    @Override
    public final boolean shouldContainTempFiles() {
        return super.shouldContainTempFiles();
    }

    @Override
    public final boolean isIconRequired() {
        return super.isIconRequired();
    }

    @Override
    @NotNull
    public final Disposable getTestRootDisposable() {
        return super.getTestRootDisposable();
    }

    @Override
    public final boolean shouldRunTest() {
        return super.shouldRunTest();
    }

    @Override
    public final void defaultRunBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        super.defaultRunBare(testRunnable);
    }

    @Override
    public final boolean runInDispatchThread() {
        return super.runInDispatchThread();
    }

    @Override
    @NotNull
    public final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        return (T)super.disposeOnTearDown(disposable);
    }

    @Override
    @NotNull
    public final String getTestName(boolean lowercaseFirstLetter) {
        return super.getTestName(lowercaseFirstLetter);
    }

    @Override
    @NotNull
    public final String getTestDirectoryName() {
        return super.getTestDirectoryName();
    }

    @Override
    public final boolean isPerformanceTest() {
        return super.isPerformanceTest();
    }

    @Override
    public final boolean isStressTest() {
        return super.isStressTest();
    }

    @Override
    public final void assertNoThrowable(@NotNull Runnable closure) {
        super.assertNoThrowable(closure);
    }

    @Override
    public final boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        return super.annotatedWith(annotationClass);
    }

    @Override
    @NotNull
    public final String getHomePath() {
        return super.getHomePath();
    }

    static {
        optionsMap.putAll(SpecTest.getOptionsMap());
    }
}

