/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class LineMarkerSettings {
    final HashMap<GutterIconDescriptor, Boolean> myOptions = new HashMap();

    public LineMarkerSettings disable(GutterIconDescriptor ... options) {
        for (GutterIconDescriptor option : options) {
            this.myOptions.put(option, false);
        }
        return this;
    }

    public LineMarkerSettings enable(GutterIconDescriptor ... options) {
        for (GutterIconDescriptor option : options) {
            this.myOptions.put(option, true);
        }
        return this;
    }

    public LineMarkerSettings remove(GutterIconDescriptor ... options) {
        for (GutterIconDescriptor option : options) {
            this.myOptions.remove(option);
        }
        return this;
    }

    public HashMap<GutterIconDescriptor, Boolean> getOptions() {
        return this.myOptions;
    }

    @NotNull
    public Map<String, Boolean> getOptionsById() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (GutterIconDescriptor option : this.myOptions.keySet()) {
            result.put(option.getId(), this.myOptions.get(option));
        }
        return result;
    }

    @NotNull
    public Set<String> getDisabledIds() {
        HashSet<String> result = new HashSet<String>();
        for (GutterIconDescriptor option : this.myOptions.keySet()) {
            if (this.myOptions.get(option).booleanValue()) continue;
            result.add(option.getId());
        }
        return result;
    }

    @NotNull
    public Set<String> getEnabledIds() {
        HashSet<String> result = new HashSet<String>();
        for (GutterIconDescriptor option : this.myOptions.keySet()) {
            if (!this.myOptions.get(option).booleanValue()) continue;
            result.add(option.getId());
        }
        return result;
    }
}

