/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParamRowGenerator {
    @Nullable
    private final String locationPrefix;
    private int index;
    public static final Decorator NULL_DECORATOR = (index, prefix, suffix) -> prefix + suffix;
    public static final ColumnProvider NULL_COLUMN_PROVIDER = row -> 0;
    public static final LineProvider NULL_LINE_PROVIDER = row -> 0;
    public final ArrayList<Object[]> rows = new ArrayList();

    public final ArrayList<Object[]> getRows() {
        return this.rows;
    }

    public ParamRowGenerator(@NotNull String locationPrefix) {
        this(locationPrefix, null);
    }

    public ParamRowGenerator(@NotNull String testRoot, @Nullable Class<?> testClass) {
        Object rootPrefix = testRoot.endsWith("/") ? testRoot : testRoot + "/";
        this.locationPrefix = testClass == null ? rootPrefix : (String)rootPrefix + testClass.getPackage().getName().replace('.', '/') + "/";
        this.index = 0;
    }

    public ParamRowGenerator() {
        this.locationPrefix = null;
        this.index = 0;
    }

    public ParamRowGenerator row(@Nullable Object @NotNull [] row) {
        return this.row(1, row, null, null, null);
    }

    protected ParamRowGenerator row(int callerOffset, @Nullable Object @NotNull [] row, @Nullable Decorator decorator) {
        return this.row(callerOffset + 1, row, decorator, null, null);
    }

    public ParamRowGenerator row(int callerOffset, @Nullable Object @NotNull [] row, @Nullable Decorator decorator, @Nullable LineProvider lineProvider, @Nullable ColumnProvider columnProvider) {
        return this.rowOffset(callerOffset + 1, 0, row, decorator, lineProvider, columnProvider);
    }

    public ParamRowGenerator rowOffset(int callerOffset, int insertAt, @Nullable Object @NotNull [] row, @Nullable Decorator decorator, @Nullable LineProvider lineProvider, @Nullable ColumnProvider columnProvider) {
        assert (insertAt >= 0 && insertAt <= row.length);
        if (decorator == null) {
            decorator = NULL_DECORATOR;
        }
        if (columnProvider == null) {
            columnProvider = NULL_COLUMN_PROVIDER;
        }
        if (lineProvider == null) {
            lineProvider = NULL_LINE_PROVIDER;
        }
        Object[] newRow = new Object[row.length + 1];
        if (insertAt == 0) {
            System.arraycopy(row, 0, newRow, insertAt + 1, row.length);
        } else {
            System.arraycopy(row, 0, newRow, 0, insertAt);
            System.arraycopy(row, insertAt, newRow, insertAt + 1, row.length - insertAt);
        }
        StackTraceElement callerInfo = Thread.currentThread().getStackTrace()[2 + callerOffset];
        int index = this.index++;
        String file = this.locationPrefix == null ? "fqn://" + ParamRowGenerator.removeSuffix(callerInfo.getClassName()) : this.locationPrefix + callerInfo.getFileName();
        int line = callerInfo.getLineNumber() + lineProvider.getLineOffset(row);
        int column = columnProvider.getColumn(row);
        String prefix = String.format("%d: ", index);
        String suffix = line <= 0 ? file : (column <= 1 ? String.format("%s:%d", file, line) : String.format("%s:%d:%d", file, line, column));
        newRow[insertAt] = decorator.decorate(index, prefix, suffix);
        this.rows.add(newRow);
        return this;
    }

    @NotNull
    public static String removeSuffix(@NotNull String className) {
        int pos = className.indexOf(36);
        if (pos > 0) {
            return className.substring(0, pos);
        }
        return className;
    }

    public static interface LineProvider {
        public int getLineOffset(@Nullable Object @NotNull [] var1);
    }

    public static interface ColumnProvider {
        public int getColumn(@Nullable Object @NotNull [] var1);
    }

    public static interface Decorator {
        public String decorate(int var1, @NotNull String var2, @NotNull String var3);
    }
}

