/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SpecTestCaseJavaProjectDescriptor
extends LightProjectDescriptor {
    public static final String MAVEN_PREFIX = "maven:";
    protected final LanguageLevel myLanguageLevel;
    protected final String[] myModuleLibraries;

    public SpecTestCaseJavaProjectDescriptor(@NotNull LanguageLevel languageLevel, String ... moduleLibraries) {
        this.myLanguageLevel = languageLevel;
        this.myModuleLibraries = moduleLibraries;
    }

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void setUpProject(@NotNull Project project, @NotNull LightProjectDescriptor.SetupHandler handler) throws Exception {
        if (this.myLanguageLevel.isPreview() || this.myLanguageLevel == LanguageLevel.JDK_X) {
            AcceptedLanguageLevelsSettings.allowLevel((Disposable)project, (LanguageLevel)this.myLanguageLevel);
        }
        super.setUpProject(project, handler);
    }

    public Sdk getSdk() {
        return IdeaTestUtil.getMockJdk((JavaVersion)this.myLanguageLevel.toJavaVersion());
    }

    public void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLanguageLevel);
        ArrayList<String> jarLibs = new ArrayList<String>();
        for (String library : this.myModuleLibraries) {
            if (library.startsWith(MAVEN_PREFIX)) {
                MavenDependencyUtil.addFromMaven((ModifiableRootModel)model, (String)library.substring(MAVEN_PREFIX.length()));
                continue;
            }
            jarLibs.add(library);
        }
        if (jarLibs.size() > 0) {
            PsiTestUtil.addProjectLibrary((Module)module, (String)"test-lib", jarLibs);
        }
    }

    @NotNull
    public String getModuleTypeId() {
        return "JAVA_MODULE";
    }
}

