/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.cases;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.vladsch.flexmark.test.util.DumpSpecReader;
import com.vladsch.flexmark.test.util.ExceptionMatcher;
import com.vladsch.flexmark.test.util.SpecExampleParse;
import com.vladsch.flexmark.test.util.SpecExampleProcessor;
import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.test.util.spec.SpecReader;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.plugin.test.util.IntentionInfo;
import com.vladsch.plugin.test.util.TestBundle;
import com.vladsch.plugin.test.util.cases.SpecTest;
import com.vladsch.plugin.test.util.renderers.LightFixtureSpecRenderer;
import com.vladsch.plugin.util.TestUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.ComparisonFailure;
import org.junit.rules.ExpectedException;

public interface CodeInsightFixtureSpecTestCase
extends SpecTest {
    public static final String BANNER_AST = CodeInsightFixtureSpecTestCase.bannerText("AST");
    public static final String BANNER_AST_AFTER_ACTION = CodeInsightFixtureSpecTestCase.bannerText("AST After Action");
    public static final String BANNER_AST_BEFORE_ACTION = CodeInsightFixtureSpecTestCase.bannerText("AST Before Action");
    public static final String BANNER_QUICK_FIXES = CodeInsightFixtureSpecTestCase.bannerText("QUICK_FIXES");
    public static final String BANNER_RANGES = CodeInsightFixtureSpecTestCase.bannerText("RANGES");
    public static final String BANNER_CLIPBOARD = CodeInsightFixtureSpecTestCase.bannerText("CLIPBOARD");
    public static final String BANNER_SEGMENTS = CodeInsightFixtureSpecTestCase.bannerText("SEGMENTS");
    public static final String BANNER_AFTER_ACTION = CodeInsightFixtureSpecTestCase.bannerText("After Action");
    public static final String BANNER_BEFORE_ACTION = CodeInsightFixtureSpecTestCase.bannerText("Before Action");
    public static final ExceptionMatcher EXCEPTION_MATCHER = ExceptionMatcher.matchPrefix(RuntimeException.class, (String)"junit.framework.ComparisonFailure: ");
    public static final Map<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();
    public static final DataKey<Boolean> TEST_CARET_MARKUP = new DataKey("TEST_CARET_MARKUP", (Object)false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DataHolder> getOptionsMap() {
        Map<String, DataHolder> map = optionsMap;
        synchronized (map) {
            if (optionsMap.isEmpty()) {
                optionsMap.putAll(SpecTest.optionsMap);
            }
            return optionsMap;
        }
    }

    @NotNull
    public static String bannerText(@NotNull String message) {
        return com.vladsch.flexmark.test.util.TestUtils.bannerText((String)message);
    }

    public static void appendBanner(@NotNull StringBuilder out, @NotNull String banner) {
        com.vladsch.flexmark.test.util.TestUtils.appendBanner((StringBuilder)out, (String)banner);
    }

    public static void appendBannerIfNeeded(@NotNull StringBuilder out, @NotNull String banner) {
        com.vladsch.flexmark.test.util.TestUtils.appendBannerIfNeeded((StringBuilder)out, (String)banner);
    }

    @NotNull
    public static List<Object[]> getTests(@NotNull ResourceLocation location) {
        return com.vladsch.flexmark.test.util.TestUtils.getTestData((ResourceLocation)location);
    }

    @Nullable
    public static Map<String, ? extends DataHolder> optionsMaps(@Nullable Map<String, ? extends DataHolder> other, @Nullable Map<String, ? extends DataHolder> overrides) {
        return com.vladsch.flexmark.test.util.TestUtils.optionsMaps(other, overrides);
    }

    @Nullable
    public static DataHolder[] dataHolders(@Nullable DataHolder other, @Nullable DataHolder[] overrides) {
        return com.vladsch.flexmark.test.util.TestUtils.dataHolders((DataHolder)other, (DataHolder[])overrides);
    }

    public static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor, Project project) {
        CommandProcessor.getInstance().executeCommand(project, () -> EditorTestUtil.executeAction((Editor)editor, (String)actionId), "", null, editor.getDocument());
    }

    public static void executeAction(@NotNull Editor editor, boolean assertActionIsEnabled, @NotNull AnAction action) {
        EditorTestUtil.executeAction((Editor)editor, (boolean)assertActionIsEnabled, (AnAction)action);
    }

    public static void executeKeystroke(@NotNull Editor editor, @NotNull KeyStroke stroke) {
        JComponent component = editor.getComponent();
        ActionListener listener = component.getActionForKeyStroke(stroke);
        listener.actionPerformed(new ActionEvent(component, 0, String.valueOf(stroke.getKeyChar()), stroke.getModifiers()));
    }

    default public String resolveIconName(@Nullable Icon icon) {
        return String.valueOf(icon);
    }

    @NotNull
    public static String getActualLineMarkerFileText(@NotNull Document myDocument, @NotNull Collection<? extends LineMarkerInfo> markerInfos, @NotNull Function<Icon, String> iconResolver) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        ArrayList<? extends LineMarkerInfo> lineMarkerInfos = new ArrayList<LineMarkerInfo>(markerInfos);
        lineMarkerInfos.sort(Comparator.comparingInt(o -> o.startOffset));
        String documentText = myDocument.getText();
        for (LineMarkerInfo lineMarkerInfo : lineMarkerInfos) {
            String lineMarkerTooltip = lineMarkerInfo.getLineMarkerTooltip();
            result.append(documentText, Math.min(index, lineMarkerInfo.startOffset), lineMarkerInfo.startOffset).append("<lineMarker ").append("icon=\"").append(iconResolver.apply(lineMarkerInfo.getIcon())).append("\" ").append("descr=\"").append(lineMarkerTooltip == null ? null : lineMarkerTooltip.replace("\"", "&quot;")).append("\" ").append(">").append(documentText, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset).append("</lineMarker>");
            index = lineMarkerInfo.endOffset;
        }
        result.append(documentText, index, myDocument.getTextLength());
        return result.toString();
    }

    public static void removeDuplicatedRangesForInjected(@NotNull List<? extends HighlightInfo> infos) {
        infos.sort((o1, o2) -> {
            int i = o2.startOffset - o1.startOffset;
            return i != 0 ? i : o1.getSeverity().myVal - o2.getSeverity().myVal;
        });
        HighlightInfo prevInfo = null;
        Iterator<? extends HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
    }

    public static void clearFields(@NotNull Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields((Object)test, aClass);
        }
    }

    @NotNull
    public static String getExampleFileName(@NotNull Class<?> testCaseClass, @NotNull SpecExample example, @NotNull DataHolder options) {
        String name = (String)SpecTest.EXAMPLE_SOURCE_NAME.get(options);
        if (!name.isEmpty()) {
            return name;
        }
        return testCaseClass.getSimpleName() + "_" + (String)(example.getSection() != null ? example.getSection().replace(' ', '_') + "_" : "") + example.getExampleNumber() + (String)SpecTest.EXAMPLE_SOURCE_EXTENSION.get(options);
    }

    @NotNull
    public static String getExampleName(@NotNull SpecExample example) {
        return String.format("[%s]", example.toString());
    }

    @NotNull
    default public List<IntentionAction> getAvailableIntentions(@NotNull LightFixtureSpecRenderer<?> specRenderer, @NotNull Editor editor, @NotNull PsiFile file, boolean atCaretOnly) {
        return (List)ReadAction.compute(() -> this.doGetAvailableIntentions(specRenderer, editor, file, atCaretOnly));
    }

    @NotNull
    default public List<IntentionAction> doGetAvailableIntentions(@NotNull LightFixtureSpecRenderer<?> specRenderer, @NotNull Editor editor, @NotNull PsiFile file, boolean atCaretOnly) {
        this.beforeDoHighlighting(specRenderer, file);
        IdeaTestExecutionPolicy current = IdeaTestExecutionPolicy.current();
        if (current != null) {
            current.waitForHighlighting(file.getProject(), editor);
        }
        ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionsPass.getActionsToShow((Editor)editor, (PsiFile)file, (boolean)false);
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        IntentionListStep intentionListStep = new IntentionListStep(null, editor, file, file.getProject(), CachedIntentions.create((Project)file.getProject(), (PsiFile)file, (Editor)editor, (ShowIntentionsPass.IntentionsInfo)intentions));
        for (Map.Entry entry : intentionListStep.getActionsWithSubActions().entrySet()) {
            result.add((IntentionAction)entry.getKey());
            result.addAll((Collection)entry.getValue());
        }
        List infos = DaemonCodeAnalyzerEx.getInstanceEx((Project)file.getProject()).getFileLevelHighlights(file.getProject(), file);
        for (HighlightInfo info : infos) {
            List fixRanges = info.quickFixActionRanges;
            if (fixRanges == null) continue;
            for (Pair pair : fixRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (!actionInGroup.getAction().isAvailable(file.getProject(), editor, file)) continue;
                result.add(actionInGroup.getAction());
                Iterable options = actionInGroup.getOptions((PsiElement)file, editor);
                for (IntentionAction subAction : options) {
                    if (!subAction.isAvailable(file.getProject(), editor, file)) continue;
                    result.add(subAction);
                }
            }
        }
        return result;
    }

    @NotNull
    default public List<IntentionInfo> getAvailableIntentionsWithRanges(@NotNull LightFixtureSpecRenderer<?> specRenderer, @NotNull Editor editor, @NotNull PsiFile file, boolean atCaretOnly) {
        this.beforeDoHighlighting(specRenderer, file);
        IdeaTestExecutionPolicy current = IdeaTestExecutionPolicy.current();
        if (current != null) {
            current.waitForHighlighting(file.getProject(), editor);
        }
        ArrayList<IntentionInfo> intentions = new ArrayList<IntentionInfo>();
        Integer atOffset = atCaretOnly ? Integer.valueOf(editor.getCaretModel().getOffset()) : null;
        DaemonCodeAnalyzerEx.processHighlights((Document)editor.getDocument(), (Project)file.getProject(), (HighlightSeverity)HighlightSeverity.INFORMATION, (int)0, (int)editor.getDocument().getTextLength(), info -> {
            CodeInsightFixtureSpecTestCase.doCollectIntentionActions(atOffset, info, false, editor, file, intentions);
            return true;
        });
        List infos = DaemonCodeAnalyzerEx.getInstanceEx((Project)file.getProject()).getFileLevelHighlights(file.getProject(), file);
        for (HighlightInfo info2 : infos) {
            CodeInsightFixtureSpecTestCase.doCollectIntentionActions(null, info2, true, editor, file, intentions);
        }
        intentions.sort(IntentionInfo::compareTo);
        return intentions;
    }

    public static void doCollectIntentionActions(@Nullable Integer atOffset, HighlightInfo info, boolean fileLevel, @NotNull Editor editor, @NotNull PsiFile file, List<IntentionInfo> intentions) {
        List fixRanges = info.quickFixActionRanges;
        if (fixRanges != null) {
            for (Pair pair : fixRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup;
                IntentionAction action;
                if (atOffset != null && !((TextRange)pair.second).contains(atOffset.intValue()) && ((TextRange)pair.second).getEndOffset() != atOffset.intValue() || !(action = (actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first).getAction()).isAvailable(file.getProject(), editor, file)) continue;
                Iterable options = actionInGroup.getOptions((PsiElement)file, editor);
                ArrayList<IntentionInfo> subActions = new ArrayList<IntentionInfo>();
                for (IntentionAction subAction : options) {
                    if (!subAction.isAvailable(file.getProject(), editor, file)) continue;
                    subActions.add(IntentionInfo.of(fileLevel, subAction));
                }
                intentions.add(IntentionInfo.of(fileLevel, action, (TextRange)pair.second, subActions.toArray(IntentionInfo.EMPTY_INTENTION_INFO)));
            }
        }
    }

    public LightFixtureSpecRenderer<?> createExampleSpecRenderer(@NotNull SpecExample var1, @Nullable DataHolder var2);

    default public DataHolder appendDefaultExampleOptions(@NotNull SpecExample example, @Nullable DataHolder options, @NotNull String optionsText) {
        DataHolder modOptions = com.vladsch.flexmark.test.util.TestUtils.getOptions((SpecExample)example, (String)optionsText, arg_0 -> ((CodeInsightFixtureSpecTestCase)this).options(arg_0));
        if (modOptions != null) {
            if (options != null) {
                modOptions = modOptions.toMutable().setAll(options).toImmutable();
            }
        } else {
            modOptions = options;
        }
        return modOptions;
    }

    public <T extends CodeInsightFixtureSpecTestCase> void initializeRenderer(@NotNull LightFixtureSpecRenderer<T> var1);

    public <T extends CodeInsightFixtureSpecTestCase> void finalizeRenderer(@NotNull LightFixtureSpecRenderer<T> var1, @NotNull DataHolder var2);

    public <T extends CodeInsightFixtureSpecTestCase> void renderSpecTestAst(@NotNull StringBuilder var1, @NotNull LightFixtureSpecRenderer<T> var2, @NotNull DataHolder var3);

    @NotNull
    default public LightFixtureSpecRenderer<?> getSpecExampleRenderer(@NotNull SpecExample example, @Nullable DataHolder exampleOptions) {
        DataHolder options = exampleOptions == null ? this.getDefaultOptions() : DataSet.aggregate((DataHolder)this.getDefaultOptions(), (DataHolder)exampleOptions);
        return this.createExampleSpecRenderer(example, options);
    }

    default public VirtualFile createImageFile(String fileName, InputStream content) {
        TempDirTestFixture fixture = this.getFixture().getTempDirFixture();
        VirtualFile virtualFile = fixture.createFile(fileName);
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)content);
                virtualFile.setBinaryContent(bytes);
            }
            catch (IOException e) {
                this.LOG().error((Throwable)e);
            }
        });
        return virtualFile;
    }

    default public void addFullSpecExample(@NotNull SpecExampleRenderer exampleRenderer, @NotNull SpecExampleParse exampleParse, @Nullable DataHolder exampleOptions, boolean ignoredTestCase, @NotNull String html, @Nullable String ast) {
    }

    default public void fullTestSpecStarting() {
    }

    default public void fullTestSpecComplete() {
    }

    default public void beforeDoHighlighting(@NotNull LightFixtureSpecRenderer<?> specRenderer, @NotNull PsiFile file) {
    }

    @NotNull
    default public DumpSpecReader create(@NotNull ResourceLocation location) {
        return (DumpSpecReader)SpecReader.create((ResourceLocation)location, (stream, fileUrl) -> new DumpSpecReader(stream, (SpecExampleProcessor)this, fileUrl, true));
    }

    @NotNull
    default public SpecExample checkExample(@NotNull SpecExample example) {
        return example;
    }

    @NotNull
    public DataHolder getDefaultOptions();

    public Logger LOG();

    @NotNull
    public SpecExample getExample();

    @NotNull
    public ExpectedException getThrown();

    @NotNull
    public TempDirTestFixture getTempDirFixture();

    public Project getProject();

    default public EditorEx getEditor() {
        return (EditorEx)this.getFixture().getEditor();
    }

    default public int getCaretOffset() {
        return this.getFixture().getCaretOffset();
    }

    default public PsiFile getFile() {
        return this.getFixture().getFile();
    }

    public PsiManager getPsiManager();

    public PsiFile createLightFile(FileType var1, String var2);

    public PsiFile createLightFile(String var1, Language var2, String var3);

    @NotNull
    public Module getModule();

    public void addSuppressedException(@NotNull Throwable var1);

    public boolean shouldContainTempFiles();

    public boolean isIconRequired();

    @NotNull
    public Disposable getTestRootDisposable();

    public boolean shouldRunTest();

    public void defaultRunBare(@NotNull ThrowableRunnable<Throwable> var1) throws Throwable;

    public boolean runInDispatchThread();

    @NotNull
    public <T extends Disposable> T disposeOnTearDown(@NotNull T var1);

    @NotNull
    public String getTestName(boolean var1);

    @NotNull
    public String getTestDirectoryName();

    public boolean isPerformanceTest();

    public boolean isStressTest();

    public void assertNoThrowable(@NotNull Runnable var1);

    public boolean annotatedWith(@NotNull Class<? extends Annotation> var1);

    @NotNull
    public String getHomePath();

    public CodeInsightTestFixture getFixture();

    default public void executeAction(@NonNls @NotNull String actionId) {
        this.executeAction(actionId, (Editor)this.getEditor());
    }

    default public void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor) {
        CodeInsightFixtureSpecTestCase.executeAction(actionId, editor, this.getProject());
    }

    @NotNull
    default public String getResultTextWithMarkup(boolean withCarets, boolean withTestCaretMarkup) {
        return this.getResultTextWithMarkup((Editor)this.getEditor(), withCarets, withTestCaretMarkup);
    }

    @NotNull
    default public String getResultTextWithMarkup(@NotNull Editor editor, boolean withCarets, boolean withTestCaretMarkup) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (!withCarets) {
            return editor.getDocument().getText();
        }
        return TestUtils.getEditorTextWithCaretMarkup((Editor)editor, (boolean)withTestCaretMarkup, (Logger)this.LOG());
    }

    default public com.vladsch.flexmark.util.misc.Pair<String, String> collectAndCheckHighlighting(@NotNull LightFixtureSpecRenderer<?> specRenderer, boolean checkLineMarkers, boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        ExpectedHighlightingData data = new ExpectedHighlightingData((Document)this.getEditor().getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting, new ResourceBundle[]{TestBundle.getBundle()});
        data.init();
        return this.collectAndCheckHighlighting(specRenderer, data, checkLineMarkers);
    }

    default public PsiFile getHostFile() {
        VirtualFile myFile = this.getFile().getVirtualFile();
        VirtualFile hostVFile = myFile instanceof VirtualFileWindow ? ((VirtualFileWindow)myFile).getDelegate() : myFile;
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(hostVFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public com.vladsch.flexmark.util.misc.Pair<String, String> collectAndCheckHighlighting(@NotNull LightFixtureSpecRenderer<?> specRenderer, @NotNull ExpectedHighlightingData data, boolean checkLineMarkers) {
        List infos;
        Project project = this.getProject();
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
        PsiFileImpl file = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file.calcTreeElement();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate((Project)project);
        long start = System.currentTimeMillis();
        final VirtualFile virtualFile = file.getVirtualFile();
        this.beforeDoHighlighting(specRenderer, (PsiFile)file);
        VirtualFileFilter fileTreeAccessFilter = new VirtualFileFilter(){

            public boolean accept(@NotNull VirtualFile file) {
                if (file instanceof VirtualFileWindow || !file.equals(virtualFile)) {
                    return false;
                }
                FileType fileType = file.getFileType();
                return (fileType == JavaFileType.INSTANCE || fileType == JavaClassFileType.INSTANCE) && !file.getName().equals("package-info.java");
            }
        };
        Disposable disposable = Disposer.newDisposable();
        PsiManagerEx.getInstanceEx((Project)project).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        try {
            infos = this.getFixture().doHighlighting();
            CodeInsightFixtureSpecTestCase.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        String actualInspection = "";
        String actualLineMarkers = "";
        try {
            data.checkResult((PsiFile)file, (Collection)infos, file.getText());
        }
        catch (ComparisonFailure cf) {
            actualInspection = cf.getActual();
        }
        if (checkLineMarkers) {
            Document document = this.getFixture().getDocument(this.getFile());
            actualLineMarkers = CodeInsightFixtureSpecTestCase.getActualLineMarkerFileText(document, DaemonCodeAnalyzerImpl.getLineMarkers((Document)document, (Project)this.getProject()), this::resolveIconName);
        }
        ObjectUtils.reachabilityFence((Object)hardRefToFileElement);
        return com.vladsch.flexmark.util.misc.Pair.of((Object)actualInspection, (Object)actualLineMarkers);
    }

    default public void defaultTestCase() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String expected;
            String actual;
            SpecExample example = this.getExample();
            boolean isFullSpec = example.isFullSpecExample();
            if (isFullSpec) {
                this.fullTestSpecStarting();
                ResourceLocation location = example.getResourceLocation();
                DumpSpecReader reader = this.create(location);
                reader.readExamples();
                this.fullTestSpecComplete();
                actual = reader.getFullSpec();
                expected = reader.getExpectedFullSpec();
            } else {
                String actualAst;
                DataHolder options = com.vladsch.flexmark.test.util.TestUtils.getOptions((SpecExample)example, (String)example.getOptionsSet(), arg_0 -> ((CodeInsightFixtureSpecTestCase)this).options(arg_0));
                LightFixtureSpecRenderer<?> exampleRenderer = this.getSpecExampleRenderer(example, options);
                if (options != null && ((Boolean)com.vladsch.flexmark.test.util.TestUtils.FAIL.get(options)).booleanValue()) {
                    this.getThrown().expect((Matcher)EXCEPTION_MATCHER);
                }
                String source = example.getSource();
                if (((Boolean)com.vladsch.flexmark.test.util.TestUtils.NO_FILE_EOL.get(options)).booleanValue()) {
                    source = com.vladsch.flexmark.test.util.TestUtils.trimTrailingEOL((String)source);
                }
                exampleRenderer.parse(source);
                exampleRenderer.finalizeDocument();
                String expectedHtml = example.getHtml();
                String actualHtml = exampleRenderer.getHtml();
                String expectedAst = example.getAst();
                String string = actualAst = expectedAst != null ? exampleRenderer.getAst() : null;
                if (example.getSection() != null) {
                    StringBuilder outExpected = new StringBuilder();
                    com.vladsch.flexmark.test.util.TestUtils.addSpecExample((boolean)true, (StringBuilder)outExpected, (String)source, (String)expectedHtml, (String)expectedAst, (String)example.getOptionsSet(), (boolean)true, (String)example.getSection(), (int)example.getExampleNumber());
                    expected = outExpected.toString();
                    StringBuilder outActual = new StringBuilder();
                    com.vladsch.flexmark.test.util.TestUtils.addSpecExample((boolean)true, (StringBuilder)outActual, (String)source, (String)actualHtml, (String)actualAst, (String)example.getOptionsSet(), (boolean)true, (String)example.getSection(), (int)example.getExampleNumber());
                    actual = outActual.toString();
                } else {
                    expected = com.vladsch.flexmark.test.util.TestUtils.addSpecExample((boolean)true, (String)source, (String)expectedHtml, (String)expectedAst, (String)example.getOptionsSet());
                    actual = com.vladsch.flexmark.test.util.TestUtils.addSpecExample((boolean)true, (String)source, (String)actualHtml, (String)actualAst, (String)example.getOptionsSet());
                }
            }
            if (!expected.equals(actual)) {
                System.out.println(CodeInsightFixtureSpecTestCase.getExampleName(example) + " Test Failed, " + example.getFileUrlWithLineNumber());
            }
            TestCase.assertEquals((String)"\n", (String)expected, (String)actual);
        });
    }

    default public void closeOpenFile(@NotNull LightFixtureSpecRenderer<?> specRenderer) {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        LookupManager.hideActiveLookup((Project)project);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        EditorEx editor = this.getEditor();
        FileEditorManagerEx.getInstanceEx((Project)project).closeFile(editor.getVirtualFile());
        EditorHistoryManager.getInstance((Project)project).removeFile(editor.getVirtualFile());
    }
}

