/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.cases;

import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.plugin.test.util.TestIdeActions;
import com.vladsch.plugin.test.util.cases.CodeInsightFixtureSpecTestCase;
import com.vladsch.plugin.test.util.renderers.ActionSpecRenderer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LightFixtureActionSpecTest
extends CodeInsightFixtureSpecTestCase,
TestIdeActions {
    public static final DataKey<String> ACTION_NAME = new DataKey("ACTION_NAME", (Object)"");
    public static final DataKey<String> TYPE_ACTION_TEXT = new DataKey("TYPE_ACTION_TEXT", (Object)"");
    public static final DataKey<String> CLIPBOARD_TEXT = new DataKey("CLIPBOARD_TEXT", (Object)"");
    public static final DataKey<String> CLIPBOARD_FILE_URL = new DataKey("CLIPBOARD_FILE_URL", (Object)"");
    public static final DataKey<String> INJECTED_TEXT = new DataKey("INJECTED_TEXT", (Object)"");
    public static final DataKey<Integer> ACTION_REPEAT = new DataKey("ACTION_REPEAT", (Object)1);
    public static final DataKey<Boolean> CLIPBOARD_CONTENT = new DataKey("CLIPBOARD_CONTENT", (Object)false);
    public static final String TYPE_ACTION = "type";
    public static final String SKIP_ACTION = "no-op";
    public static final Map<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DataHolder> getOptionsMap() {
        Map<String, DataHolder> map = optionsMap;
        synchronized (map) {
            if (optionsMap.isEmpty()) {
                optionsMap.putAll(CodeInsightFixtureSpecTestCase.getOptionsMap());
                optionsMap.put("type-comma", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)","));
                optionsMap.put("backspace", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)"EditorBackSpace"));
                optionsMap.put("show-clipboard", (DataHolder)new MutableDataSet().set(CLIPBOARD_CONTENT, (Object)true));
                optionsMap.put("enter", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)"EditorEnter"));
                optionsMap.put("copy", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)"EditorCopy"));
                optionsMap.put("paste", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)"EditorPaste"));
                optionsMap.put("tab", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)"tab"));
                optionsMap.put("back-tab", (DataHolder)new MutableDataSet().set(ACTION_NAME, (Object)"back-tab"));
                optionsMap.put(TYPE_ACTION, (DataHolder)new MutableDataSet().set(TestUtils.CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, LightFixtureActionSpecTest::typeOption)));
                optionsMap.put("clipboard", (DataHolder)new MutableDataSet().set(TestUtils.CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, LightFixtureActionSpecTest::clipboardOption)));
                optionsMap.put("clipboard-file-url", (DataHolder)new MutableDataSet().set(TestUtils.CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, LightFixtureActionSpecTest::clipboardFileUrl)));
                optionsMap.put("inject", (DataHolder)new MutableDataSet().set(TestUtils.CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, LightFixtureActionSpecTest::injectOption)));
                optionsMap.put("repeat", (DataHolder)new MutableDataSet().set(TestUtils.CUSTOM_OPTION, (option, params) -> TestUtils.customIntOption((String)option, (String)params, LightFixtureActionSpecTest::repeatOption)));
            }
            return optionsMap;
        }
    }

    public static DataHolder repeatOption(@Nullable Integer params) {
        int value = params != null ? params : 1;
        return new MutableDataSet().set(ACTION_REPEAT, (Object)value);
    }

    public static DataHolder injectOption(@Nullable String params) {
        if (params != null) {
            return new MutableDataSet().set(ACTION_NAME, (Object)"inject").set(INJECTED_TEXT, (Object)params);
        }
        throw new IllegalStateException("'inject' option requires non-empty text argument");
    }

    public static DataHolder clipboardOption(@Nullable String params) {
        if (params != null) {
            return new MutableDataSet().set(CLIPBOARD_TEXT, (Object)params);
        }
        throw new IllegalStateException("'clipboard' option requires non-empty text argument");
    }

    public static DataHolder clipboardFileUrl(@Nullable String params) {
        if (params != null) {
            return new MutableDataSet().set(CLIPBOARD_FILE_URL, (Object)params);
        }
        throw new IllegalStateException("'clipboard-file-url' option requires non-empty text argument");
    }

    public static DataHolder typeOption(@Nullable String params) {
        if (params != null) {
            return new MutableDataSet().set(ACTION_NAME, (Object)TYPE_ACTION).set(TYPE_ACTION_TEXT, (Object)params);
        }
        throw new IllegalStateException("'type' option requires non-empty text argument");
    }

    public ActionSpecRenderer<?> createExampleSpecRenderer(@NotNull SpecExample var1, @Nullable DataHolder var2);

    public <T extends LightFixtureActionSpecTest> void beforeDoTestAction(@NotNull ActionSpecRenderer<T> var1, @NotNull DataHolder var2);

    public <T extends LightFixtureActionSpecTest> void afterDoTestAction(@NotNull ActionSpecRenderer<T> var1, @NotNull DataHolder var2);

    public <T extends LightFixtureActionSpecTest> void renderTesActionHtml(@NotNull StringBuilder var1, @NotNull ActionSpecRenderer<T> var2, DataHolder var3);
}

