/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.cases;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.vladsch.flexmark.test.util.SettableInstance;
import com.vladsch.flexmark.test.util.SpecExampleProcessor;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.plugin.test.util.AdditionalProjectFiles;
import com.vladsch.plugin.test.util.DebugLogSettings;
import com.vladsch.plugin.test.util.LineMarkerSettings;
import com.vladsch.plugin.test.util.SpecTestSetup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public interface SpecTest
extends SpecExampleProcessor {
    public static final DataKey<Boolean> IGNORE = TestUtils.IGNORE;
    public static final DataKey<Boolean> FAIL = TestUtils.FAIL;
    public static final DataKey<Boolean> NO_FILE_EOL = TestUtils.NO_FILE_EOL;
    public static final DataKey<Integer> TIMED_ITERATIONS = TestUtils.TIMED_ITERATIONS;
    public static final DataKey<Boolean> EMBED_TIMED = TestUtils.EMBED_TIMED;
    public static final DataKey<Boolean> TIMED = TestUtils.TIMED;
    public static final DataKey<Boolean> WANT_AST = new DataKey("WANT_AST", (Object)false);
    public static final DataKey<Boolean> WANT_QUICK_FIXES = new DataKey("WANT_QUICK_FIXES", (Object)false);
    public static final DataKey<Boolean> WANT_RANGES = new DataKey("WANT_RANGES", (Object)false);
    public static final DataKey<Consumer<CodeStyleSettings>> CODE_STYLE_SETTINGS = SpecTestSetup.CODE_STYLE_SETTINGS;
    public static final SettableInstance<CodeStyleSettings> CODE_STYLE_SETTINGS_OPTION = SpecTestSetup.CODE_STYLE_SETTINGS_OPTION;
    public static final DataKey<Consumer<AdditionalProjectFiles>> ADDITIONAL_PROJECT_FILES = SpecTestSetup.ADDITIONAL_PROJECT_FILES;
    public static final SettableInstance<AdditionalProjectFiles> ADDITIONAL_PROJECT_FILES_OPTION = SpecTestSetup.ADDITIONAL_PROJECT_FILES_OPTION;
    public static final DataKey<Consumer<LineMarkerSettings>> LINE_MARKER_SETTINGS = SpecTestSetup.LINE_MARKER_SETTINGS;
    public static final SettableInstance<LineMarkerSettings> LINE_MARKER_SETTINGS_OPTION = SpecTestSetup.LINE_MARKER_SETTINGS_OPTION;
    public static final DataKey<Consumer<DebugLogSettings>> DEBUG_LOG_SETTINGS = SpecTestSetup.DEBUG_LOG_SETTINGS;
    public static final SettableInstance<DebugLogSettings> DEBUG_LOG_SETTINGS_OPTION = SpecTestSetup.DEBUG_LOG_SETTINGS_OPTION;
    public static final DataKey<BiFunction<String, String, DataHolder>> CUSTOM_OPTION = TestUtils.CUSTOM_OPTION;
    public static final DataKey<String> EXAMPLE_SOURCE_NAME = new DataKey("EXAMPLE_SOURCE_NAME", (Object)"");
    public static final DataKey<String> EXAMPLE_SOURCE_EXTENSION = new DataKey("EXAMPLE_SOURCE_EXTENSION", (Object)".md");
    public static final Map<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DataHolder> getOptionsMap() {
        Map<String, DataHolder> map = optionsMap;
        synchronized (map) {
            if (optionsMap.isEmpty()) {
                optionsMap.put("with-ast", (DataHolder)new MutableDataSet().set(WANT_AST, (Object)true));
                optionsMap.put("with-ranges", (DataHolder)new MutableDataSet().set(WANT_RANGES, (Object)true));
                optionsMap.put("with-quick-fixes", (DataHolder)new MutableDataSet().set(WANT_QUICK_FIXES, (Object)true));
                optionsMap.put("no-ast", (DataHolder)new MutableDataSet().set(WANT_AST, (Object)false));
                optionsMap.put("no-ranges", (DataHolder)new MutableDataSet().set(WANT_RANGES, (Object)false));
                optionsMap.put("no-quick-fixes", (DataHolder)new MutableDataSet().set(WANT_QUICK_FIXES, (Object)false));
                optionsMap.put("source-extension", (DataHolder)new MutableDataSet().set(CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, SpecTest::sourceExtensionOption)));
                optionsMap.put("source-name", (DataHolder)new MutableDataSet().set(CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, SpecTest::sourceNameOption)));
                optionsMap.put("log", (DataHolder)new MutableDataSet().set(CUSTOM_OPTION, (option, params) -> TestUtils.customStringOption((String)option, (String)params, SpecTest::debugLogOption)));
            }
            return optionsMap;
        }
    }

    public static DataHolder debugLogOption(@Nullable String params) {
        if (params != null) {
            BasedSequence basedParams = BasedSequence.of((CharSequence)params);
            List list = basedParams.splitList((CharSequence)",", 0, 6, CharPredicate.WHITESPACE_NBSP);
            return new MutableDataSet().set(DEBUG_LOG_SETTINGS, it -> it.trace(list));
        }
        throw new IllegalStateException("'log' option requires semicolon separated log ids");
    }

    public static DataHolder sourceNameOption(@Nullable String params) {
        if (params != null) {
            return new MutableDataSet().set(EXAMPLE_SOURCE_NAME, (Object)params);
        }
        throw new IllegalStateException("'source-extension' option requires text for the extension");
    }

    public static DataHolder sourceExtensionOption(@Nullable String params) {
        if (params != null) {
            return new MutableDataSet().set(EXAMPLE_SOURCE_EXTENSION, (Object)params);
        }
        throw new IllegalStateException("'source-extension' option requires text for the extension");
    }
}

