/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.renderers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ui.TextTransferable;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.plugin.test.util.cases.CodeInsightFixtureSpecTestCase;
import com.vladsch.plugin.test.util.cases.LightFixtureActionSpecTest;
import com.vladsch.plugin.test.util.cases.SpecTest;
import com.vladsch.plugin.test.util.renderers.LightFixtureSpecRenderer;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSpecRenderer<T extends LightFixtureActionSpecTest>
extends LightFixtureSpecRenderer<T> {
    Editor myResultEditor;
    PsiFile myResultFile;

    public ActionSpecRenderer(@NotNull T specTestBase, @NotNull SpecExample example, @Nullable DataHolder options) {
        super(specTestBase, example, options);
    }

    void updateResults() {
        if (this.myResultEditor == null) {
            String action = (String)LightFixtureActionSpecTest.ACTION_NAME.get(this.myOptions);
            this.myResultEditor = action.equals("inject") ? this.getHostEditor() : this.getEditor();
        }
        if (this.myResultFile == null) {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            Document document = this.myResultEditor.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile != null) {
                this.myResultFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile));
            }
        }
    }

    @Override
    public Editor getResultEditor() {
        this.updateResults();
        return this.myResultEditor == null ? this.getEditor() : this.myResultEditor;
    }

    @Override
    public PsiFile getResultFile() {
        this.updateResults();
        return this.myResultFile == null ? this.getFile() : this.myResultFile;
    }

    protected void executeRendererAction(@NotNull String action) {
        switch (action) {
            case "inject": {
                List files;
                PsiElement elementAt;
                PsiElement hostElement;
                String injectedText = (String)LightFixtureActionSpecTest.INJECTED_TEXT.get(this.getOptions());
                InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)this.getProject());
                Editor editor = this.getEditor();
                PsiFile psiFile = this.getFile();
                boolean isInjectedEditor = false;
                int offset = editor.getCaretModel().getOffset();
                for (hostElement = elementAt = psiFile.findElementAt(offset == editor.getDocument().getTextLength() ? offset - 1 : offset); hostElement != null && !(hostElement instanceof PsiLanguageInjectionHost) && !(hostElement instanceof PsiFile); hostElement = hostElement.getParent()) {
                }
                if (psiFile.getContext() == null && hostElement != null && (files = languageManager.getInjectedPsiFiles(hostElement)) != null && !files.isEmpty()) {
                    elementAt = (PsiElement)((Pair)files.get((int)0)).first;
                    psiFile = elementAt.getContainingFile();
                    editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)psiFile);
                    offset = editor.getCaretModel().getOffset();
                    hostElement = psiFile.getContext();
                    isInjectedEditor = true;
                }
                if (!isInjectedEditor && hostElement != null && hostElement.getContext() instanceof PsiLanguageInjectionHost) {
                    hostElement = hostElement.getContext();
                    isInjectedEditor = true;
                }
                assert (hostElement instanceof PsiLanguageInjectionHost) : String.format("Element at caret offset: %d is not PsiLanguageInjectionHost, got: %s", offset, elementAt == null ? "null" : elementAt.getClass().getSimpleName());
                PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)hostElement;
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)injectionHost);
                assert (manipulator != null) : "No Element manipulator for " + injectionHost.getClass().getSimpleName();
                assert (!injectedText.isEmpty());
                if (isInjectedEditor) {
                    PsiLanguageInjectionHost finalHostElement = (PsiLanguageInjectionHost)hostElement;
                    int finalOffset = offset;
                    Editor finalEditor = editor;
                    WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
                        List fragments;
                        Document document = finalEditor.getDocument();
                        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
                        String content = document.getText();
                        int insertPos = finalOffset;
                        if (document instanceof DocumentWindow && !(fragments = languageManager.getNonEditableFragments((DocumentWindow)finalEditor.getDocument())).isEmpty()) {
                            TextRange firstFragment = (TextRange)fragments.get(0);
                            TextRange lastFragment = (TextRange)fragments.get(fragments.size() - 1);
                            if (firstFragment.getStartOffset() == 0 && lastFragment.getEndOffset() == content.length()) {
                                content = content.substring(firstFragment.getEndOffset(), lastFragment.getStartOffset());
                                insertPos -= firstFragment.getEndOffset();
                            }
                            if (firstFragment.getStartOffset() == 0) {
                                content = content.substring(firstFragment.getEndOffset());
                                insertPos -= firstFragment.getEndOffset();
                            }
                            if (lastFragment.getEndOffset() == content.length()) {
                                content = content.substring(0, lastFragment.getStartOffset());
                            }
                        }
                        TextRange rangeInElement = manipulator.getRangeInElement((PsiElement)injectionHost);
                        LiteralTextEscaper escaper = injectionHost.createLiteralTextEscaper();
                        String useContent = content.substring(0, insertPos) + injectedText + content.substring(insertPos);
                        manipulator.handleContentChange((PsiElement)finalHostElement, useContent);
                    });
                    break;
                }
                TextRange rangeInElement = manipulator.getRangeInElement((PsiElement)injectionHost);
                LiteralTextEscaper escaper = injectionHost.createLiteralTextEscaper();
                StringBuilder out = new StringBuilder();
                escaper.decode(rangeInElement, out);
                String content = out.toString();
                int iMax = content.length();
                int insertPos = -1;
                int offsetDelta = injectionHost.getTextOffset();
                for (int i = 0; i <= iMax; ++i) {
                    int offsetInHost = escaper.getOffsetInHost(i, rangeInElement);
                    if (offsetInHost + offsetDelta < offset) continue;
                    insertPos = i;
                    offsetInHost = escaper.getOffsetInHost(i, rangeInElement);
                    break;
                }
                assert (insertPos != -1) : "Caret position not found in decoded element content";
                String finalInjectedText = content.substring(0, insertPos) + injectedText + content.substring(insertPos);
                PsiLanguageInjectionHost finalHostElement = (PsiLanguageInjectionHost)hostElement;
                WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> manipulator.handleContentChange((PsiElement)finalHostElement, finalInjectedText));
                break;
            }
            default: {
                this.executeAction(action);
            }
        }
    }

    @Override
    protected String getAstBanner() {
        return CodeInsightFixtureSpecTestCase.BANNER_AST_AFTER_ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestAction() {
        String action;
        if (((Boolean)SpecTest.WANT_AST.get(this.myOptions)).booleanValue() || this.wantAstByDefault() && !this.myOptions.contains(SpecTest.WANT_AST) && this.myExample.getAst() != null) {
            CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(this.ast, CodeInsightFixtureSpecTestCase.BANNER_AST_BEFORE_ACTION);
            this.renderAstText(this.ast, (PsiElement)this.getResultFile(), "");
        }
        if ((action = (String)LightFixtureActionSpecTest.ACTION_NAME.get(this.myOptions)).isEmpty()) {
            ActionSpecRenderer.assertEquals(this.getExample().getFileUrlWithLineNumber() + "\nACTION_NAME cannot be empty", "action", "");
        } else if (!action.equals("no-op")) {
            try {
                ((LightFixtureActionSpecTest)this.mySpecTest).beforeDoTestAction(this, this.myOptions);
                String clipboardFileUrl = (String)LightFixtureActionSpecTest.CLIPBOARD_FILE_URL.get(this.myOptions);
                String clipboardText = (String)LightFixtureActionSpecTest.CLIPBOARD_TEXT.get(this.myOptions);
                if (!clipboardFileUrl.isEmpty()) {
                    VirtualFile virtualFile = (VirtualFile)this.myAdditionalVirtualFiles.get(clipboardFileUrl);
                    assert (virtualFile != null) : "File: " + clipboardFileUrl + " not found in additional virtual files: " + this.myAdditionalVirtualFiles;
                    TextTransferable transferable = new TextTransferable(virtualFile.getUrl() + clipboardText);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)transferable, null);
                    CopyPasteManager.getInstance().setContents((Transferable)transferable);
                } else if (!clipboardText.isEmpty()) {
                    TextTransferable transferable = new TextTransferable(clipboardText);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)transferable, null);
                    CopyPasteManager.getInstance().setContents((Transferable)transferable);
                }
                int repeat = (Integer)LightFixtureActionSpecTest.ACTION_REPEAT.get(this.myOptions);
                assert (repeat >= 0) : "ACTION_REPEAT should be >= 0";
                if (action.equals("type")) {
                    String text = (String)LightFixtureActionSpecTest.TYPE_ACTION_TEXT.get(this.myOptions);
                    if (!text.isEmpty()) {
                        if (repeat > 1) {
                            this.type(RepeatedSequence.repeatOf((CharSequence)text, (int)repeat).toString());
                        } else {
                            this.type(text);
                        }
                    } else {
                        ActionSpecRenderer.assertEquals(this.getExample().getFileUrlWithLineNumber() + "\nTYPE_ACTION_TEXT cannot be empty for TYPE_ACTION", "text to type", "");
                    }
                } else {
                    int i = repeat;
                    while (i-- > 0) {
                        this.executeRendererAction(action);
                    }
                }
            }
            catch (Throwable t) {
                this.html.append(t.getMessage()).append("\n");
                t.printStackTrace(System.out);
                System.out.println();
            }
            finally {
                ((LightFixtureActionSpecTest)this.mySpecTest).afterDoTestAction(this, this.myOptions);
            }
        }
    }

    @Override
    @NotNull
    public String renderHtml() {
        Transferable transferable;
        this.doTestAction();
        Editor editor = this.getResultEditor();
        this.html.append(this.getResultTextWithMarkup(editor, true, false));
        if (((Boolean)LightFixtureActionSpecTest.CLIPBOARD_CONTENT.get(this.myOptions)).booleanValue() && (transferable = CopyPasteManager.getInstance().getContents()) != null) {
            CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(this.html, CodeInsightFixtureSpecTestCase.BANNER_CLIPBOARD);
            if (transferable.isDataFlavorSupported(CaretStateTransferableData.FLAVOR)) {
                try {
                    String textData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.html.append(textData);
                    if (!textData.endsWith("\n")) {
                        this.html.append("\n");
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String textData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.html.append(textData);
                    if (!textData.endsWith("\n")) {
                        this.html.append("\n");
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ((LightFixtureActionSpecTest)this.mySpecTest).renderTesActionHtml(this.html, this, this.myOptions);
        return this.html.toString();
    }
}

