/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.renderers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.plugin.test.util.cases.CodeInsightFixtureSpecTestCase;
import com.vladsch.plugin.test.util.cases.LightFixtureIntentionSpecTest;
import com.vladsch.plugin.test.util.cases.SpecTest;
import com.vladsch.plugin.test.util.renderers.ActionSpecRenderer;
import com.vladsch.plugin.util.TestUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionSpecRenderer<T extends LightFixtureIntentionSpecTest>
extends ActionSpecRenderer<T> {
    private static final Function<IntentionAction, String> INTENTION_NAME_FUN = intentionAction -> "\"" + intentionAction.getText() + "\"";

    public IntentionSpecRenderer(@NotNull T specTestBase, @NotNull SpecExample example, @Nullable DataHolder options) {
        super(specTestBase, example, options);
    }

    @Override
    protected void renderAst(StringBuilder out) {
        this.renderIntentions(out, true);
        super.renderAst(out);
    }

    @Override
    @NotNull
    public String renderHtml() {
        PsiFile file = this.getFile();
        if (file != null) {
            String[] strings = (String[])LightFixtureIntentionSpecTest.INSPECTION_OPTIONS.get(this.myOptions);
            file.putUserData(TestUtils.TEST_INTENTION_OPTIONS, (Object)strings);
        }
        this.getFixture().enableInspections((Class[])LightFixtureIntentionSpecTest.INSPECTION_CLASSES.get(this.myOptions));
        String intentionAction = (String)LightFixtureIntentionSpecTest.INTENTION_ACTION.get(this.myOptions);
        if (!intentionAction.isEmpty()) {
            List list;
            if (((Boolean)SpecTest.WANT_AST.get(this.myOptions)).booleanValue()) {
                CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(this.ast, CodeInsightFixtureSpecTestCase.BANNER_BEFORE_ACTION);
                super.renderAst(this.ast);
                CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(this.ast, CodeInsightFixtureSpecTestCase.BANNER_AFTER_ACTION);
            }
            if ((list = this.filterAvailableIntentions(intentionAction)).isEmpty()) {
                return "\"" + intentionAction + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]";
            }
            if (list.size() > 1) {
                List matchedList = ContainerUtil.filter(list, action -> action.getText().equals(intentionAction));
                if (matchedList.size() == 1) {
                    list = matchedList;
                } else {
                    return "Too many intentions found without an exact match for \"" + intentionAction + "\": [" + StringUtil.join((Collection)list, INTENTION_NAME_FUN, (String)", ") + "]";
                }
            }
            ((LightFixtureIntentionSpecTest)this.mySpecTest).beforeDoTestAction(this, this.myOptions);
            this.launchAction((IntentionAction)list.get(0));
            ((LightFixtureIntentionSpecTest)this.mySpecTest).afterDoTestAction(this, this.myOptions);
            this.html.append(this.getResultTextWithMarkup(true, (Boolean)CodeInsightFixtureSpecTestCase.TEST_CARET_MARKUP.get(this.myOptions)));
            return this.html.toString();
        }
        Pair<String, String> highlighting = ((LightFixtureIntentionSpecTest)this.mySpecTest).collectAndCheckHighlighting(this, false, true, true, true, false);
        return (String)highlighting.getFirst();
    }
}

