/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.renderers;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.diagnostic.DebugLogManager;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.vladsch.flexmark.test.util.SpecExampleRendererBase;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.builder.BasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.plugin.test.util.AdditionalProjectFiles;
import com.vladsch.plugin.test.util.DebugLogSettings;
import com.vladsch.plugin.test.util.IntentionInfo;
import com.vladsch.plugin.test.util.SpecTestSetup;
import com.vladsch.plugin.test.util.cases.CodeInsightFixtureSpecTestCase;
import com.vladsch.plugin.test.util.cases.SpecTest;
import com.vladsch.plugin.util.AppUtils;
import com.vladsch.plugin.util.PsiTreeAstRenderer;
import com.vladsch.plugin.util.TestUtils;
import gnu.trove.Equality;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import junit.framework.TestCase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightFixtureSpecRenderer<T extends CodeInsightFixtureSpecTestCase>
extends SpecExampleRendererBase {
    @NotNull
    protected final T mySpecTest;
    @NotNull
    protected final HashMap<String, VirtualFile> myAdditionalVirtualFiles = new HashMap();
    protected final AdditionalProjectFiles myAdditionalProjectFiles = new AdditionalProjectFiles();
    protected final StringBuilder ast = new StringBuilder();
    protected final StringBuilder html = new StringBuilder();
    private List<DebugLogManager.Category> mySavedCategories;
    private DebugLogSettings myDebugLogSettings;

    public LightFixtureSpecRenderer(@NotNull T specTest, @NotNull SpecExample example, @Nullable DataHolder options) {
        super(example, options, true);
        this.mySpecTest = specTest;
    }

    @NotNull
    public HashMap<String, VirtualFile> getAdditionalVirtualFiles() {
        return this.myAdditionalVirtualFiles;
    }

    public AdditionalProjectFiles getAdditionalProjectFiles() {
        return this.myAdditionalProjectFiles;
    }

    @NotNull
    public List<IntentionInfo> getAvailableIntentionsWithRanges(boolean atCaretOnly) {
        PsiFile file = this.getHostFileAtCaret();
        this.mySpecTest.beforeDoHighlighting(this, file);
        this.doHighlighting();
        return (List)ReadAction.compute(() -> this.mySpecTest.getAvailableIntentionsWithRanges(this, this.getHostEditor(), file, atCaretOnly));
    }

    @NotNull
    protected Editor getHostEditor() {
        Editor editor = this.getEditor();
        return editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
    }

    protected PsiFile getHostFileAtCaret() {
        return Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)this.getHostEditor(), (Project)this.getProject()));
    }

    public boolean includeExampleInfo() {
        return true;
    }

    @NotNull
    public final DataHolder getOptions() {
        return this.myOptions;
    }

    protected boolean wantAstByDefault() {
        return true;
    }

    protected void renderAst(StringBuilder out) {
        if (((Boolean)SpecTest.WANT_QUICK_FIXES.get(this.myOptions)).booleanValue()) {
            CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(out, CodeInsightFixtureSpecTestCase.BANNER_QUICK_FIXES);
            this.renderQuickFixesText(out);
        }
        if (((Boolean)SpecTest.WANT_AST.get(this.myOptions)).booleanValue() || this.wantAstByDefault() && !this.myOptions.contains(SpecTest.WANT_AST) && this.myExample.getAst() != null) {
            CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(out, this.getAstBanner());
            this.renderAstText(out, (PsiElement)this.getResultFile(), "");
        }
    }

    protected String getAstBanner() {
        return CodeInsightFixtureSpecTestCase.BANNER_AST;
    }

    protected void renderQuickFixesText(StringBuilder out) {
        List<IntentionAction> intentions = this.getAllQuickFixes(new String[0]);
        for (IntentionAction intention : intentions) {
            out.append("intention[").append(intention.getText()).append("]\n");
        }
    }

    public void renderRanges(StringBuilder out, BasedSequence result) {
        if (((Boolean)SpecTest.WANT_RANGES.get(this.myOptions)).booleanValue()) {
            CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(out, CodeInsightFixtureSpecTestCase.BANNER_RANGES);
            BasedSegmentBuilder builder = BasedSegmentBuilder.emptyBuilder((BasedSequence)result.getBaseSequence());
            result.addSegments((IBasedSegmentBuilder)builder);
            out.append(builder.toStringWithRanges());
            CodeInsightFixtureSpecTestCase.appendBannerIfNeeded(out, CodeInsightFixtureSpecTestCase.BANNER_SEGMENTS);
            out.append(builder.toString()).append("\n");
        }
    }

    protected Editor getResultEditor() {
        return this.getEditor();
    }

    protected PsiFile getResultFile() {
        return this.getFile();
    }

    @NotNull
    protected final String renderAst() {
        this.renderAst(this.ast);
        this.mySpecTest.renderSpecTestAst(this.ast, this, this.myOptions);
        return this.ast.toString();
    }

    public void includeDocument(@NotNull String includedText) {
    }

    protected void renderAstText(StringBuilder out, PsiElement element, String indent) {
        PsiFile file = element.getContainingFile();
        BasedSequence fileChars = BasedSequence.of((CharSequence)file.getText());
        PsiTreeAstRenderer.generateAst((BasedSequence)fileChars, (StringBuilder)out, (String)indent, (PsiElement)element);
    }

    @NotNull
    protected abstract String renderHtml();

    protected void renderIntentions(StringBuilder out, boolean atCaretOnly) {
        List<IntentionInfo> intentions = this.getAvailableIntentionsWithRanges(atCaretOnly);
        boolean first = true;
        boolean firstFileLevel = true;
        for (IntentionInfo intention : intentions) {
            Range range = intention.range;
            if (intention.fileLevel) {
                if ((first || firstFileLevel) && out.length() > 0) {
                    out.append("\n----- File Level Intentions -----\n");
                }
                first = false;
                firstFileLevel = false;
            } else {
                if (first && out.length() > 0) {
                    out.append("\n----- Intentions -----\n");
                }
                first = false;
            }
            out.append("Intention:[").append(range.getStart()).append(", ").append(range.getEnd()).append(" \"").append("intention[").append(intention.action.getText()).append("]\" ]\n");
            for (IntentionInfo subAction : intention.subActions) {
                out.append("   ").append("intention[").append(subAction.action.getText()).append("]\n");
            }
        }
    }

    public void parse(CharSequence input) {
        String name;
        this.myDebugLogSettings = new DebugLogSettings();
        SpecTest.DEBUG_LOG_SETTINGS_OPTION.setInstanceData((Object)this.myDebugLogSettings, this.myOptions);
        DebugLogManager logCustomizer = (DebugLogManager)AppUtils.getApplicationComponentOrService(DebugLogManager.class);
        this.mySavedCategories = logCustomizer.getSavedCategories();
        logCustomizer.clearCategories(this.mySavedCategories);
        logCustomizer.applyCategories(this.myDebugLogSettings.getLogCategories());
        String testInput = TestUtils.replaceCaretMarkers((CharSequence)input, (boolean)((Boolean)CodeInsightFixtureSpecTestCase.TEST_CARET_MARKUP.get(this.myOptions)));
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.getProject()).getMainProjectCodeStyle();
        assert (codeStyleSettings != null);
        CodeStyleSettings myCodeStyleSettings = codeStyleSettings.clone();
        SpecTest.CODE_STYLE_SETTINGS_OPTION.setInstanceData((Object)myCodeStyleSettings, this.myOptions);
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).setTemporarySettings(myCodeStyleSettings);
        this.mySpecTest.initializeRenderer(this);
        SpecTest.ADDITIONAL_PROJECT_FILES_OPTION.setInstanceData((Object)this.myAdditionalProjectFiles, this.myOptions);
        if (!this.myAdditionalProjectFiles.getFiles().isEmpty()) {
            for (Map.Entry<String, Object> entry : this.myAdditionalProjectFiles.getFiles().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    PsiFile psiFile = this.addFileToProject(entry.getKey(), (String)value);
                    this.myAdditionalVirtualFiles.put(entry.getKey(), psiFile.getVirtualFile());
                    this.mySpecTest.LOG().debug(String.format("Created additional file %s '%s' %d", entry.getKey(), Utils.escapeJavaString((CharSequence)((String)value)), psiFile.getModificationStamp()));
                    continue;
                }
                if (!(value instanceof ResourceLocation)) continue;
                ResourceLocation resourceLocation = (ResourceLocation)value;
                VirtualFile imageFile = this.mySpecTest.createImageFile(resourceLocation.getResourcePath(), resourceLocation.getResourceInputStream());
                this.myAdditionalVirtualFiles.put(entry.getKey(), imageFile);
                this.mySpecTest.LOG().debug(String.format("Created additional image file %s %d", entry.getKey(), imageFile.getModificationStamp()));
            }
        }
        if ((name = this.getExampleFileName(this.myExample, this.myOptions)).contains("/")) {
            PsiFile psiFile = this.addFileToProject(name, testInput);
            this.myAdditionalVirtualFiles.put(name, psiFile.getVirtualFile());
            this.configureFromExistingVirtualFile(psiFile.getVirtualFile());
        } else {
            this.configureByText(name, testInput);
        }
        CharSequence dummy = this.getEditor().getDocument().getCharsSequence();
        SpecTestSetup.CUSTOMIZE_FILE_OPTION.setInstanceData((Object)this.getFile(), this.myOptions);
    }

    public void finalizeDocument() {
    }

    public void finalizeRender() {
        this.mySpecTest.closeOpenFile(this);
        EditorHistoryManager historyManager = EditorHistoryManager.getInstance((Project)this.getProject());
        if (!this.myAdditionalVirtualFiles.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
                for (Map.Entry<String, VirtualFile> entry : this.myAdditionalVirtualFiles.entrySet()) {
                    VirtualFile virtualFile = entry.getValue();
                    if (!virtualFile.isValid()) continue;
                    try {
                        historyManager.removeFile(virtualFile);
                        virtualFile.delete((Object)this);
                    }
                    catch (IOException e) {
                        this.mySpecTest.LOG().error("Deleting additional files", (Throwable)e);
                    }
                }
            });
            this.myAdditionalVirtualFiles.clear();
        }
        this.mySpecTest.finalizeRenderer(this, this.myOptions);
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).dropTemporarySettings();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.getProject()).getTemporarySettings();
        assert (codeStyleSettings == null);
        DebugLogManager logCustomizer = (DebugLogManager)AppUtils.getApplicationComponentOrService(DebugLogManager.class);
        logCustomizer.clearCategories(this.myDebugLogSettings.getLogCategories());
        logCustomizer.applyCategories(this.mySavedCategories);
    }

    public void executeAction(@NotNull String actionId) {
        this.mySpecTest.executeAction(actionId);
    }

    public void executeAction(@NotNull String actionId, @NotNull Editor editor) {
        this.mySpecTest.executeAction(actionId, editor);
    }

    public static void executeAction(@NotNull String actionId, @NotNull Editor editor, Project project) {
        CodeInsightFixtureSpecTestCase.executeAction(actionId, editor, project);
    }

    public static void executeAction(@NotNull Editor editor, boolean assertActionIsEnabled, @NotNull AnAction action) {
        CodeInsightFixtureSpecTestCase.executeAction(editor, assertActionIsEnabled, action);
    }

    public static void executeKeystroke(@NotNull Editor editor, @NotNull KeyStroke stroke) {
        CodeInsightFixtureSpecTestCase.executeKeystroke(editor, stroke);
    }

    public Editor getEditor() {
        return this.getFixture().getEditor();
    }

    public int getCaretOffset() {
        return this.getFixture().getCaretOffset();
    }

    public PsiFile getFile() {
        return this.getFixture().getFile();
    }

    public void setTestDataPath(@NotNull String dataPath) {
        this.getFixture().setTestDataPath(dataPath);
    }

    @NotNull
    public String getTempDirPath() {
        return this.getFixture().getTempDirPath();
    }

    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        return this.getFixture().getTempDirFixture();
    }

    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourceFilePath) {
        return this.getFixture().copyFileToProject(sourceFilePath);
    }

    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourceFilePath, @NotNull String targetPath) {
        return this.getFixture().copyFileToProject(sourceFilePath, targetPath);
    }

    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourceFilePath, @NotNull String targetPath) {
        return this.getFixture().copyDirectoryToProject(sourceFilePath, targetPath);
    }

    public PsiFile configureByFile(@NotNull String filePath) {
        return this.getFixture().configureByFile(filePath);
    }

    @NotNull
    public PsiFile[] configureByFiles(String ... filePaths) {
        return this.getFixture().configureByFiles(filePaths);
    }

    public PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        return this.getFixture().configureByText(fileType, text);
    }

    public PsiFile configureByText(@NotNull String fileName, @NotNull String text) {
        return this.getFixture().configureByText(fileName, text);
    }

    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        return this.getFixture().configureFromTempProjectFile(filePath);
    }

    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        this.getFixture().configureFromExistingVirtualFile(virtualFile);
    }

    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        return this.getFixture().addFileToProject(relativePath, fileText);
    }

    public void checkResultByFile(@NotNull String expectedFile) {
        this.getFixture().checkResultByFile(expectedFile);
    }

    public void checkResultByFile(@NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        this.getFixture().checkResultByFile(expectedFile, ignoreTrailingWhitespaces);
    }

    public void checkResultByFile(@NotNull String filePath, @NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        this.getFixture().checkResultByFile(filePath, expectedFile, ignoreTrailingWhitespaces);
    }

    public void enableInspections(InspectionProfileEntry ... inspections) {
        this.getFixture().enableInspections(inspections);
    }

    public void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        this.getFixture().enableInspections((Class[])inspections);
    }

    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        this.getFixture().enableInspections(inspections);
    }

    public void disableInspections(InspectionProfileEntry ... inspections) {
        this.getFixture().disableInspections(inspections);
    }

    public void enableInspections(InspectionToolProvider ... providers) {
        this.getFixture().enableInspections(providers);
    }

    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        return this.getFixture().testHighlighting(checkWarnings, checkInfos, checkWeakWarnings, filePaths);
    }

    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        return this.getFixture().testHighlightingAllFiles(checkWarnings, checkInfos, checkWeakWarnings, filePaths);
    }

    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        return this.getFixture().testHighlightingAllFiles(checkWarnings, checkInfos, checkWeakWarnings, files);
    }

    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.getFixture().checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        return this.getFixture().checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
    }

    public long checkHighlighting() {
        return this.getFixture().checkHighlighting();
    }

    public long testHighlighting(String ... filePaths) {
        return this.getFixture().testHighlighting(filePaths);
    }

    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file) {
        return this.getFixture().testHighlighting(checkWarnings, checkInfos, checkWeakWarnings, file);
    }

    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        return this.getFixture().testFile(filePath);
    }

    public void openFileInEditor(@NotNull VirtualFile file) {
        this.getFixture().openFileInEditor(file);
    }

    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper toolWrapper) {
        this.getFixture().testInspection(testDir, toolWrapper);
    }

    @NotNull
    public List<HighlightInfo> doHighlighting() {
        return this.getFixture().doHighlighting();
    }

    @NotNull
    public List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minimalSeverity) {
        return this.getFixture().doHighlighting(minimalSeverity);
    }

    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        return this.getFixture().getReferenceAtCaretPosition(filePaths);
    }

    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        return this.getFixture().getReferenceAtCaretPositionWithAssertion(filePaths);
    }

    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        return this.getFixture().getAvailableIntentions(filePaths);
    }

    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        return this.getFixture().getAllQuickFixes(filePaths);
    }

    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        return this.getFixture().getAvailableIntentions();
    }

    @NotNull
    public List<IntentionAction> filterAvailableIntentions(@NotNull String hint) {
        return this.getFixture().filterAvailableIntentions(hint);
    }

    @NotNull
    public IntentionAction findSingleIntention(@NotNull String hint) {
        return this.getFixture().findSingleIntention(hint);
    }

    @Nullable
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        return this.getFixture().getAvailableIntention(intentionName, filePaths);
    }

    public void launchAction(@NotNull IntentionAction action) {
        this.getFixture().launchAction(action);
    }

    public void testCompletion(@NotNull String[] filesBefore, @NotNull String fileAfter) {
        this.getFixture().testCompletion(filesBefore, fileAfter);
    }

    public void testCompletionTyping(@NotNull String[] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        this.getFixture().testCompletionTyping(filesBefore, toType, fileAfter);
    }

    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        this.getFixture().testCompletion(fileBefore, fileAfter, additionalFiles);
    }

    public void testCompletionTyping(@NotNull String fileBefore, @NotNull String toType, @NotNull String fileAfter, String ... additionalFiles) {
        this.getFixture().testCompletionTyping(fileBefore, toType, fileAfter, additionalFiles);
    }

    public void testCompletionVariants(@NotNull String fileBefore, String ... items) {
        this.getFixture().testCompletionVariants(fileBefore, items);
    }

    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        this.getFixture().testRename(fileBefore, fileAfter, newName, additionalFiles);
    }

    public void testRenameUsingHandler(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        this.getFixture().testRenameUsingHandler(fileBefore, fileAfter, newName, additionalFiles);
    }

    public void testRename(@NotNull String fileAfter, @NotNull String newName) {
        this.getFixture().testRename(fileAfter, newName);
    }

    public void testRenameUsingHandler(@NotNull String fileAfter, @NotNull String newName) {
        this.getFixture().testRenameUsingHandler(fileAfter, newName);
    }

    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        return this.getFixture().testFindUsages(fileNames);
    }

    @NotNull
    public Collection<Usage> testFindUsagesUsingAction(String ... fileNames) {
        return this.getFixture().testFindUsagesUsingAction(fileNames);
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement to) {
        return this.getFixture().findUsages(to);
    }

    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull Collection<? extends UsageInfo> usages) {
        return this.getFixture().getUsageViewTreeTextRepresentation(usages);
    }

    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull PsiElement to) {
        return this.getFixture().getUsageViewTreeTextRepresentation(to);
    }

    @NotNull
    public RangeHighlighter[] testHighlightUsages(String ... files) {
        return this.getFixture().testHighlightUsages(files);
    }

    public void moveFile(@NotNull String filePath, @NotNull String to, String ... additionalFiles) {
        this.getFixture().moveFile(filePath, to, additionalFiles);
    }

    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        return this.getFixture().findGutter(filePath);
    }

    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        return this.getFixture().findGuttersAtCaret();
    }

    public LookupElement[] completeBasic() {
        return this.getFixture().completeBasic();
    }

    public LookupElement[] complete(@NotNull CompletionType type) {
        return this.getFixture().complete(type);
    }

    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        return this.getFixture().complete(type, invocationCount);
    }

    public void checkResult(@NotNull String text) {
        this.getFixture().checkResult(text);
    }

    public void checkResult(@NotNull String text, boolean stripTrailingSpaces) {
        this.getFixture().checkResult(text, stripTrailingSpaces);
    }

    public void checkResult(@NotNull String filePath, @NotNull String text, boolean stripTrailingSpaces) {
        this.getFixture().checkResult(filePath, text, stripTrailingSpaces);
    }

    public Document getDocument(@NotNull PsiFile file) {
        return this.getFixture().getDocument(file);
    }

    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String filePath) {
        return this.getFixture().findAllGutters(filePath);
    }

    public List<GutterMark> findAllGutters() {
        return this.getFixture().findAllGutters();
    }

    public void type(char c) {
        this.getFixture().type(c);
    }

    public void type(@NotNull String s) {
        this.getFixture().type(s);
    }

    public void performEditorAction(@NotNull String actionId) {
        this.getFixture().performEditorAction(actionId);
    }

    @NotNull
    public Presentation testAction(@NotNull AnAction action) {
        return this.getFixture().testAction(action);
    }

    @Nullable
    public List<String> getCompletionVariants(String ... filesBefore) {
        return this.getFixture().getCompletionVariants(filesBefore);
    }

    @Nullable
    public LookupElement[] getLookupElements() {
        return this.getFixture().getLookupElements();
    }

    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        return this.getFixture().findFileInTempDir(filePath);
    }

    @Nullable
    public List<String> getLookupElementStrings() {
        return this.getFixture().getLookupElementStrings();
    }

    public void finishLookup(char completionChar) {
        this.getFixture().finishLookup(completionChar);
    }

    public LookupEx getLookup() {
        return this.getFixture().getLookup();
    }

    @NotNull
    public PsiElement getElementAtCaret() {
        return this.getFixture().getElementAtCaret();
    }

    public void renameElementAtCaret(@NotNull String newName) {
        this.getFixture().renameElementAtCaret(newName);
    }

    public void renameElementAtCaretUsingHandler(@NotNull String newName) {
        this.getFixture().renameElementAtCaretUsingHandler(newName);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName) {
        this.getFixture().renameElement(element, newName);
    }

    public void allowTreeAccessForFile(@NotNull VirtualFile file) {
        this.getFixture().allowTreeAccessForFile(file);
    }

    public void allowTreeAccessForAllFiles() {
        this.getFixture().allowTreeAccessForAllFiles();
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, boolean searchInComments, boolean searchTextOccurrences) {
        this.getFixture().renameElement(element, newName, searchInComments, searchTextOccurrences);
    }

    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Class<T> elementClass) {
        return (T)this.getFixture().findElementByText(text, elementClass);
    }

    public void testFolding(@NotNull String fileName) {
        this.getFixture().testFolding(fileName);
    }

    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName, @Nullable String destinationFileName) {
        this.getFixture().testFoldingWithCollapseStatus(verificationFileName, destinationFileName);
    }

    public void testFoldingWithCollapseStatus(@NotNull String fileName) {
        this.getFixture().testFoldingWithCollapseStatus(fileName);
    }

    public void testRainbow(@NotNull String fileName, @NotNull String text, boolean isRainbowOn, boolean withColor) {
        this.getFixture().testRainbow(fileName, text, isRainbowOn, withColor);
    }

    public void testInlays() {
        this.getFixture().testInlays();
    }

    public void testInlays(Function<? super Inlay, String> inlayPresenter, Predicate<? super Inlay> inlayFilter) {
        this.getFixture().testInlays(inlayPresenter, inlayFilter);
    }

    public void checkResultWithInlays(String text) {
        this.getFixture().checkResultWithInlays(text);
    }

    public void assertPreferredCompletionItems(int selected, String ... expected) {
        this.getFixture().assertPreferredCompletionItems(selected, expected);
    }

    public void testStructureView(@NotNull Consumer<? super StructureViewComponent> consumer) {
        this.getFixture().testStructureView(consumer);
    }

    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.getFixture().setCaresAboutInjection(caresAboutInjection);
    }

    @NotNull
    public List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        return this.getFixture().completeBasicAllCarets(charToTypeAfterCompletion);
    }

    @NotNull
    public List<Object> getGotoClassResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        return this.getFixture().getGotoClassResults(pattern, searchEverywhere, contextForSorting);
    }

    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        return this.getFixture().getBreadcrumbsAtCaret();
    }

    public void saveText(@NotNull VirtualFile file, @NotNull String text) {
        this.getFixture().saveText(file, text);
    }

    @NotNull
    public Disposable getProjectDisposable() {
        return this.getFixture().getProjectDisposable();
    }

    public CodeInsightTestFixture getFixture() {
        return this.mySpecTest.getFixture();
    }

    protected DataHolder options(String optionSet) {
        return this.mySpecTest.options(optionSet);
    }

    @NotNull
    protected String getExampleFileName(@NotNull SpecExample example, @NotNull DataHolder options) {
        return CodeInsightFixtureSpecTestCase.getExampleFileName(((Object)((Object)this)).getClass(), example, options);
    }

    @NotNull
    protected String getExampleName(@NotNull SpecExample example) {
        return CodeInsightFixtureSpecTestCase.getExampleName(example);
    }

    @NotNull
    protected String getResultTextWithMarkup(boolean withCarets, boolean withTestCaretMarkup) {
        return this.mySpecTest.getResultTextWithMarkup(withCarets, withTestCaretMarkup);
    }

    @NotNull
    protected String getResultTextWithMarkup(@NotNull Editor editor, boolean withCarets, boolean withTestCaretMarkup) {
        return this.mySpecTest.getResultTextWithMarkup(editor, withCarets, withTestCaretMarkup);
    }

    protected Project getProject() {
        return this.mySpecTest.getProject();
    }

    public PsiManager getPsiManager() {
        return this.mySpecTest.getPsiManager();
    }

    public PsiFile createLightFile(FileType fileType, String text) {
        return this.mySpecTest.createLightFile(fileType, text);
    }

    public PsiFile createLightFile(String fileName, Language language, String text) {
        return this.mySpecTest.createLightFile(fileName, language, text);
    }

    @NotNull
    public Module getModule() {
        return this.mySpecTest.getModule();
    }

    public void addSuppressedException(@NotNull Throwable e) {
        this.mySpecTest.addSuppressedException(e);
    }

    public boolean shouldContainTempFiles() {
        return this.mySpecTest.shouldContainTempFiles();
    }

    public boolean isIconRequired() {
        return this.mySpecTest.isIconRequired();
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        return this.mySpecTest.getTestRootDisposable();
    }

    public boolean shouldRunTest() {
        return this.mySpecTest.shouldRunTest();
    }

    public void defaultRunBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        this.mySpecTest.defaultRunBare(testRunnable);
    }

    public boolean runInDispatchThread() {
        return this.mySpecTest.runInDispatchThread();
    }

    @NotNull
    public <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        return this.mySpecTest.disposeOnTearDown(disposable);
    }

    @NotNull
    public String getTestName(boolean lowercaseFirstLetter) {
        return this.mySpecTest.getTestName(lowercaseFirstLetter);
    }

    @NotNull
    public String getTestDirectoryName() {
        return this.mySpecTest.getTestDirectoryName();
    }

    public boolean isPerformanceTest() {
        return this.mySpecTest.isPerformanceTest();
    }

    public boolean isStressTest() {
        return this.mySpecTest.isStressTest();
    }

    public void assertNoThrowable(@NotNull Runnable closure) {
        this.mySpecTest.assertNoThrowable(closure);
    }

    public boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        return this.mySpecTest.annotatedWith(annotationClass);
    }

    @NotNull
    public String getHomePath() {
        return this.mySpecTest.getHomePath();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals((Object[])actual, (Object[])expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(actual, (Object[])expected);
    }

    public static void assertOrderedEquals(@NotNull byte[] actual, @NotNull byte[] expected) {
        UsefulTestCase.assertOrderedEquals((byte[])actual, (byte[])expected);
    }

    public static void assertOrderedEquals(@NotNull int[] actual, @NotNull int[] expected) {
        UsefulTestCase.assertOrderedEquals((int[])actual, (int[])expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals((String)errorMsg, actual, (Object[])expected);
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals((String)errorMsg, actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull Equality<? super T> comparator) {
        UsefulTestCase.assertOrderedEquals((String)errorMsg, actual, (Object[])new Object[]{expected, comparator});
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertOrderedCollection((Object[])collection, checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] actual, T ... expected) {
        UsefulTestCase.assertSameElements((Object[])actual, (Object[])expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, T ... expected) {
        UsefulTestCase.assertSameElements(actual, (Object[])expected);
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertSameElements(actual, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertSameElements((String)message, actual, expected);
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsOrdered(collection, (Object[])expected);
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertContainsOrdered(collection, expected);
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsElements(collection, (Object[])expected);
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertContainsElements(collection, expected);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        UsefulTestCase.assertDoesntContain(collection, (Object[])notExpected);
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        UsefulTestCase.assertDoesntContain(collection, notExpected);
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertOrderedCollection(collection, checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection((Object[])collection, checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(collection, checkers);
    }

    @NotNull
    @Contract(value="null, _ -> fail")
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        return (T)UsefulTestCase.assertInstanceOf((Object)o, aClass);
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        return (T)UsefulTestCase.assertOneElement(collection);
    }

    public static <T> T assertOneElement(@NotNull T[] ts) {
        return (T)UsefulTestCase.assertOneElement((Object[])ts);
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        UsefulTestCase.assertOneOf(value, (Object[])values);
    }

    public static void assertEmpty(@NotNull Object[] array) {
        UsefulTestCase.assertEmpty((Object[])array);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        UsefulTestCase.assertNotEmpty(collection);
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        UsefulTestCase.assertEmpty(collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        UsefulTestCase.assertNullOrEmpty(collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertEmpty((String)s);
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        UsefulTestCase.assertEmpty((String)errorMsg, collection);
    }

    public static void assertSize(int expectedSize, @NotNull Object[] array) {
        UsefulTestCase.assertSize((int)expectedSize, (Object[])array);
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c) {
        UsefulTestCase.assertSize((int)expectedSize, c);
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual) {
        UsefulTestCase.assertSameLines((String)expected, (String)actual);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        UsefulTestCase.assertSameLines((String)message, (String)expected, (String)actual);
    }

    public static void assertExists(@NotNull File file) {
        UsefulTestCase.assertExists((File)file);
    }

    public static void assertDoesntExist(@NotNull File file) {
        UsefulTestCase.assertDoesntExist((File)file);
    }

    @NotNull
    public static String getTestName(@Nullable String name, boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName((String)name, (boolean)lowercaseFirstLetter);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText) {
        UsefulTestCase.assertSameLinesWithFile((String)filePath, (String)actualText);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        UsefulTestCase.assertSameLinesWithFile((String)filePath, (String)actualText, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing) {
        UsefulTestCase.assertSameLinesWithFile((String)filePath, (String)actualText, (boolean)trimBeforeComparing);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        UsefulTestCase.assertSameLinesWithFile((String)filePath, (String)actualText, (boolean)trimBeforeComparing, messageProducer);
    }

    public static void clearFields(@NotNull Object test) throws IllegalAccessException {
        CodeInsightFixtureSpecTestCase.clearFields(test);
    }

    public static void clearDeclaredFields(@NotNull Object test, @NotNull Class<?> aClass) throws IllegalAccessException {
        UsefulTestCase.clearDeclaredFields((Object)test, aClass);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) {
        UsefulTestCase.assertThrows(exceptionClass, runnable);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsg, @NotNull ThrowableRunnable<T> runnable) {
        UsefulTestCase.assertThrows(exceptionClass, (String)expectedErrorMsg, runnable);
    }

    public static void assertTrue(String message, boolean condition) {
        TestCase.assertTrue((String)message, (boolean)condition);
    }

    public static void assertTrue(boolean condition) {
        TestCase.assertTrue((boolean)condition);
    }

    public static void assertFalse(String message, boolean condition) {
        TestCase.assertFalse((String)message, (boolean)condition);
    }

    public static void assertFalse(boolean condition) {
        TestCase.assertFalse((boolean)condition);
    }

    public static void fail(String message) {
        TestCase.fail((String)message);
    }

    public static void fail() {
        TestCase.fail();
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        TestCase.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        TestCase.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        TestCase.assertEquals((String)message, (String)expected, (String)actual);
    }

    public static void assertEquals(String expected, String actual) {
        TestCase.assertEquals((String)expected, (String)actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        TestCase.assertEquals((String)message, (double)expected, (double)actual, (double)delta);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        TestCase.assertEquals((double)expected, (double)actual, (double)delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        TestCase.assertEquals((String)message, (float)expected, (float)actual, (float)delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        TestCase.assertEquals((float)expected, (float)actual, (float)delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        TestCase.assertEquals((String)message, (long)expected, (long)actual);
    }

    public static void assertEquals(long expected, long actual) {
        TestCase.assertEquals((long)expected, (long)actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        TestCase.assertEquals((String)message, (boolean)expected, (boolean)actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        TestCase.assertEquals((boolean)expected, (boolean)actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        TestCase.assertEquals((String)message, (byte)expected, (byte)actual);
    }

    public static void assertEquals(byte expected, byte actual) {
        TestCase.assertEquals((byte)expected, (byte)actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        TestCase.assertEquals((String)message, (char)expected, (char)actual);
    }

    public static void assertEquals(char expected, char actual) {
        TestCase.assertEquals((char)expected, (char)actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        TestCase.assertEquals((String)message, (short)expected, (short)actual);
    }

    public static void assertEquals(short expected, short actual) {
        TestCase.assertEquals((short)expected, (short)actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        TestCase.assertEquals((String)message, (int)expected, (int)actual);
    }

    public static void assertEquals(int expected, int actual) {
        TestCase.assertEquals((int)expected, (int)actual);
    }

    public static void assertNotNull(Object object) {
        TestCase.assertNotNull((Object)object);
    }

    public static void assertNotNull(String message, Object object) {
        TestCase.assertNotNull((String)message, (Object)object);
    }

    public static void assertNull(Object object) {
        TestCase.assertNull((Object)object);
    }

    public static void assertNull(String message, Object object) {
        TestCase.assertNull((String)message, (Object)object);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        TestCase.assertSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertSame(Object expected, Object actual) {
        TestCase.assertSame((Object)expected, (Object)actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        TestCase.assertNotSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertNotSame(Object expected, Object actual) {
        TestCase.assertNotSame((Object)expected, (Object)actual);
    }

    public static void failSame(String message) {
        TestCase.failSame((String)message);
    }

    public static void failNotSame(String message, Object expected, Object actual) {
        TestCase.failNotSame((String)message, (Object)expected, (Object)actual);
    }

    public static void failNotEquals(String message, Object expected, Object actual) {
        TestCase.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    public static String format(String message, Object expected, Object actual) {
        return TestCase.format((String)message, (Object)expected, (Object)actual);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        return UsefulTestCase.toString(collection);
    }

    @NotNull
    public static String toString(@NotNull Object[] collection, @NotNull String separator) {
        return UsefulTestCase.toString((Object[])collection, (String)separator);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        return UsefulTestCase.toString(collection, (String)separator);
    }

    public static void printThreadDump() {
        UsefulTestCase.printThreadDump();
    }

    public static void doPostponedFormatting(@NotNull Project project) {
        UsefulTestCase.doPostponedFormatting((Project)project);
    }

    public static void refreshRecursively(@NotNull VirtualFile file) {
        UsefulTestCase.refreshRecursively((VirtualFile)file);
    }

    public static VirtualFile refreshAndFindFile(@NotNull File file) {
        return UsefulTestCase.refreshAndFindFile((File)file);
    }

    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        UsefulTestCase.waitForAppLeakingThreads((long)timeout, (TimeUnit)timeUnit);
    }
}

