/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.plugin.test.util.renderers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.LineMarkerSettingsImpl;
import com.intellij.openapi.project.Project;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.plugin.test.util.LineMarkerSettings;
import com.vladsch.plugin.test.util.cases.CodeInsightFixtureSpecTestCase;
import com.vladsch.plugin.test.util.cases.LightFixtureLineMarkerSpecTest;
import com.vladsch.plugin.test.util.cases.SpecTest;
import com.vladsch.plugin.test.util.renderers.LightFixtureSpecRenderer;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerSpecRenderer<T extends LightFixtureLineMarkerSpecTest>
extends LightFixtureSpecRenderer<T> {
    public LineMarkerSpecRenderer(@NotNull T specTestBase, @NotNull SpecExample example, @Nullable DataHolder options) {
        super(specTestBase, example, options);
    }

    @Override
    protected void renderAst(StringBuilder out) {
        this.renderIntentions(out, true);
        this.renderIntentions(out, true);
        super.renderAst(out);
    }

    @Override
    @NotNull
    public String renderHtml() {
        String disableOne = ((String)LightFixtureLineMarkerSpecTest.DISABLE_ONE.get(this.myOptions)).trim();
        if (!disableOne.isEmpty()) {
            List options = SequenceUtils.splitList((CharSequence)disableOne, (CharSequence)";", (int)0, (int)6);
            for (String option : options) {
                DataHolder modOptions = TestUtils.getOptions((SpecExample)this.myExample, (String)("disable-" + option), this::options);
                LineMarkerSpecRenderer.updateDisabledLineMarkers(modOptions);
                DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart(this.getFile());
                Pair<String, String> highlighting = ((LightFixtureLineMarkerSpecTest)this.mySpecTest).collectAndCheckHighlighting(this, true, false, false, false, false);
                if (this.html.length() > 0) {
                    this.html.append("\n");
                }
                CodeInsightFixtureSpecTestCase.appendBanner(this.html, CodeInsightFixtureSpecTestCase.bannerText("Disabled: " + option));
                this.html.append((String)highlighting.getSecond());
            }
            return this.html.toString();
        }
        LineMarkerSpecRenderer.updateDisabledLineMarkers(this.myOptions);
        Pair<String, String> highlighting = ((LightFixtureLineMarkerSpecTest)this.mySpecTest).collectAndCheckHighlighting(this, true, false, false, false, false);
        return (String)highlighting.getSecond();
    }

    public static void updateDisabledLineMarkers(DataHolder options) {
        LineMarkerSettings markerSettings = (LineMarkerSettings)SpecTest.LINE_MARKER_SETTINGS_OPTION.setInstanceData((Object)new LineMarkerSettings(), options);
        Map<String, Boolean> lineMarkerOptions = markerSettings.getOptionsById();
        LineMarkerSettingsImpl lineMarkerSettings = (LineMarkerSettingsImpl)com.intellij.codeInsight.daemon.LineMarkerSettings.getSettings();
        lineMarkerSettings.providers.clear();
        lineMarkerSettings.providers.putAll(lineMarkerOptions);
    }
}

