/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import com.voltvoodoo.brew.DefaultErrorReporter;
import com.voltvoodoo.brew.FileSetChangeMonitor;
import com.voltvoodoo.brew.HamlCompiler;
import com.voltvoodoo.brew.Optimizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.JCoffeeScriptCompiler;
import org.jcoffeescript.Option;
import org.mozilla.javascript.JavaScriptException;

public class CompilerMojo
extends AbstractMojo {
    private static final String COFFEE_PATTERN = "**/*.coffee";
    private static final String HAML_PATTERN = "**/*.haml";
    private File hamlSourceDir;
    private File hamlOutputDir;
    private File moduleConversionSourceDir;
    private File moduleConversionOutputDir;
    private File coffeeSourceDir;
    private File coffeeOutputDir;
    private boolean watch = false;
    private String amdModuleSuffix;
    private HamlCompiler hamlCompiler;
    private Optimizer moduleConverter;
    private JCoffeeScriptCompiler coffeeCompiler;

    public void execute() throws MojoExecutionException {
        try {
            this.hamlCompiler = new HamlCompiler();
            this.moduleConverter = new Optimizer();
            this.coffeeCompiler = new JCoffeeScriptCompiler(new LinkedList<Option>());
            for (String relativePath : this.getCoffeeScriptsRelativePaths()) {
                try {
                    this.compileCoffeescriptFile(relativePath);
                }
                catch (JCoffeeScriptCompileException e) {
                    this.getLog().error((CharSequence)("[" + relativePath + "]: " + e.getMessage()));
                    throw e;
                }
            }
            for (String relativePath : this.getHamlRelativePaths()) {
                try {
                    this.compileHamlFile(relativePath);
                }
                catch (JavaScriptException e) {
                    this.getLog().error((CharSequence)("[" + relativePath + "]: " + e.getMessage()));
                    throw e;
                }
            }
            if (this.watch) {
                System.out.println("Watching for changes to coffeescript and haml files..");
                this.checkForChangesEvery(500L);
            }
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException(exc.getMessage(), exc);
        }
    }

    private void checkForChangesEvery(long ms) throws FileNotFoundException, JCoffeeScriptCompileException, IOException {
        FileSetChangeMonitor hamlFiles = new FileSetChangeMonitor(this.hamlSourceDir, HAML_PATTERN);
        FileSetChangeMonitor coffeeFiles = new FileSetChangeMonitor(this.coffeeSourceDir, COFFEE_PATTERN);
        try {
            block6: while (true) {
                Thread.sleep(ms);
                for (String file : hamlFiles.getModifiedFilesSinceLastTimeIAsked()) {
                    try {
                        this.compileHamlFile(file);
                        System.out.println("[" + file + "]: Compiled");
                    }
                    catch (JavaScriptException e) {
                        this.getLog().error((CharSequence)("[" + file + "]: " + e.getMessage()));
                    }
                }
                Iterator<String> i$ = coffeeFiles.getModifiedFilesSinceLastTimeIAsked().iterator();
                while (true) {
                    String file;
                    if (!i$.hasNext()) continue block6;
                    file = i$.next();
                    try {
                        this.compileCoffeescriptFile(file);
                        System.out.println("[" + file + "]: Compiled");
                    }
                    catch (JCoffeeScriptCompileException e) {
                        this.getLog().error((CharSequence)("[" + file + "]: " + e.getMessage()));
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.getLog().info((CharSequence)"Caught interrupt, quitting.");
            return;
        }
    }

    private void compileCoffeescriptFile(String relativePath) throws FileNotFoundException, JCoffeeScriptCompileException, IOException {
        File coffee = new File(this.coffeeSourceDir, relativePath);
        File js = new File(this.coffeeOutputDir, relativePath.substring(0, relativePath.lastIndexOf(46)) + ".js");
        if (js.exists()) {
            js.delete();
        }
        js.getParentFile().mkdirs();
        js.createNewFile();
        FileInputStream in = new FileInputStream(coffee);
        FileOutputStream out = new FileOutputStream(js);
        String compiled = this.coffeeCompiler.compile(IOUtil.toString((InputStream)in));
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    private void convertFromCommonModuleToAMD(String relativePath) throws IOException {
        String relativeAmdPath = relativePath.substring(0, relativePath.lastIndexOf(46)) + this.amdModuleSuffix + ".js";
        File commonFile = new File(this.moduleConversionSourceDir, relativePath).getAbsoluteFile();
        File amdFile = new File(this.moduleConversionOutputDir, relativeAmdPath).getAbsoluteFile();
        this.moduleConverter.convertCommonJsModulesToAmdModules(commonFile, amdFile, new DefaultErrorReporter(this.getLog(), true));
    }

    private void compileHamlFile(String relativePath) throws IOException {
        File coffee = new File(this.hamlSourceDir, relativePath).getAbsoluteFile();
        File js = new File(this.hamlOutputDir, relativePath.substring(0, relativePath.lastIndexOf(46)) + ".js").getAbsoluteFile();
        if (js.exists()) {
            js.delete();
        }
        js.getParentFile().mkdirs();
        js.createNewFile();
        FileInputStream in = new FileInputStream(coffee);
        FileOutputStream out = new FileOutputStream(js);
        String compiled = this.hamlCompiler.compile(IOUtil.toString((InputStream)in));
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    private String[] getHamlRelativePaths() throws MojoFailureException {
        return this.getRelativePaths(this.hamlSourceDir, HAML_PATTERN);
    }

    private String[] getCoffeeScriptsRelativePaths() throws MojoFailureException {
        return this.getRelativePaths(this.coffeeSourceDir, COFFEE_PATTERN);
    }

    private String[] getRelativePaths(File baseDir, String pattern) throws MojoFailureException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(new String[]{pattern});
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

