/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import com.voltvoodoo.brew.JSRunner;
import java.io.IOException;
import java.util.HashMap;

public class HamlCompiler
extends JSRunner {
    private static final String hamlClasspathFilename = "/haml/haml.js";
    private static final String jsonClasspathFilename = "/haml/json2.js";

    public HamlCompiler() throws IOException {
        this.evalScript(jsonClasspathFilename);
        this.evalScript(hamlClasspathFilename);
    }

    public String compile(String haml) throws IOException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("hamlSource", haml);
        return this.addModuleDefinition(this.evalString("Haml.optimize(Haml.compile(hamlSource));", "HamlCompiler", vars));
    }

    private String addModuleDefinition(String script) {
        return "(function(define){\ndefine(function(){return function(vars){\nwith(vars||{}) {\nreturn " + script + "; \n" + "}};\n" + "})" + ";})(typeof define==\"function\"?\n" + "define:\n" + "function(factory){module.exports=factory.apply(this, deps.map(require));});\n";
    }
}

