/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import com.voltvoodoo.brew.RhinoRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

public class Optimizer {
    private static final String[] requirePlugins = new String[]{"i18n.js", "order.js", "text.js"};
    private static final String buildScriptClasspathFilename = "/r.js";
    private File buildScript = File.createTempFile("build", "js");

    public Optimizer() throws IOException {
        this.copyFileFromClassPathToFilesystem(buildScriptClasspathFilename, this.buildScript);
        this.buildScript.deleteOnExit();
    }

    public void convertCommonJsModulesToAmdModules(File inputFile, File outputFile, ErrorReporter reporter) throws IOException {
        String[] includes = new String[]{};
        Object[] args = new String[]{"-v", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()};
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        RhinoRunner.exec(includes, this.buildScript.getAbsolutePath(), args, globalVariables, reporter);
    }

    public void build(File buildDir, boolean providePlugins, File buildProfile, ErrorReporter reporter) throws IOException {
        this.putRequirePluginsIn(buildDir);
        String[] includes = new String[]{};
        Object[] args = new String[]{"-o", buildProfile.getAbsolutePath()};
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        RhinoRunner.exec(includes, this.buildScript.getAbsolutePath(), args, globalVariables, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyFileFromClassPathToFilesystem(String classpathFilename, File outputFile) throws IOException {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(classpathFilename);
            out = new FileOutputStream(outputFile);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return outputFile;
    }

    private void putRequirePluginsIn(File buildDir) throws IOException {
        buildDir.mkdirs();
        for (String plugin : requirePlugins) {
            File outputFile = new File(buildDir, plugin);
            this.copyFileFromClassPathToFilesystem("/require/" + plugin, outputFile);
        }
    }
}

