/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing;

import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.DeltaCounter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.opentracing.Reference;
import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.WavefrontTracer;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.entities.tracing.SpanLog;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WavefrontSpan
implements Span {
    private final WavefrontTracer tracer;
    private final long startTimeMicros;
    private final long startTimeNanos;
    @Nullable
    private final List<Pair<String, String>> tags;
    private final List<Reference> parents;
    private final List<Reference> follows;
    @Nullable
    private final DeltaCounter spansDiscarded;
    @Nullable
    private Map<String, Pair<String, String>> singleValuedTags;
    private String operationName;
    private long durationMicroseconds;
    private WavefrontSpanContext spanContext;
    private Boolean forceSampling = null;
    private boolean finished = false;
    private boolean isError = false;
    @Nullable
    private List<SpanLog> spanLogs;
    private String componentTagValue = "none";
    private static Set<String> SINGLE_VALUED_TAG_KEYS = new HashSet<String>(Arrays.asList("application", "service", "cluster", "shard"));

    WavefrontSpan(WavefrontTracer tracer, String operationName, WavefrontSpanContext spanContext, long startTimeMicros, long startTimeNanos, List<Reference> parents, List<Reference> follows, List<Pair<String, String>> tags) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.spanContext = spanContext;
        this.startTimeMicros = startTimeMicros;
        this.startTimeNanos = startTimeNanos;
        this.parents = parents;
        this.follows = follows;
        this.spansDiscarded = tracer.getWfInternalReporter() == null ? null : tracer.getWfInternalReporter().newDeltaCounter(new MetricName("spans.discarded", Collections.emptyMap()));
        List<Pair<String, String>> globalTags = tracer.getTags();
        this.tags = !(globalTags != null && !globalTags.isEmpty() || tags != null && !tags.isEmpty()) ? null : new ArrayList();
        this.singleValuedTags = null;
        this.spanLogs = null;
        if (globalTags != null) {
            for (Pair<String, String> tag : globalTags) {
                this.setTagObject((String)tag._1, tag._2);
            }
        }
        if (tags != null) {
            for (Pair<String, String> tag : tags) {
                this.setTagObject((String)tag._1, tag._2);
            }
        }
    }

    public synchronized WavefrontSpanContext context() {
        return this.spanContext;
    }

    public WavefrontSpan setTag(String key, String value) {
        return this.setTagObject(key, value);
    }

    public WavefrontSpan setTag(String key, boolean value) {
        return this.setTagObject(key, value);
    }

    public WavefrontSpan setTag(String key, Number value) {
        return this.setTagObject(key, value);
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        return this.setTagObject(tag.getKey(), value);
    }

    private synchronized WavefrontSpan setTagObject(String key, Object value) {
        if (key != null && !key.isEmpty() && value != null && value.toString() != null && !value.toString().isEmpty()) {
            Pair tag = Pair.of((Object)key, (Object)value.toString());
            if (WavefrontSpan.isSingleValuedTagKey(key)) {
                if (this.singleValuedTags == null) {
                    this.singleValuedTags = new HashMap<String, Pair<String, String>>();
                }
                if (this.singleValuedTags.containsKey(key)) {
                    this.tags.remove(this.singleValuedTags.get(key));
                }
                this.singleValuedTags.put(key, (Pair<String, String>)tag);
            }
            this.tags.add((Pair<String, String>)tag);
            if (key.equals("component")) {
                this.componentTagValue = value.toString();
            }
            if (Tags.SAMPLING_PRIORITY.getKey().equals(key) && value instanceof Number) {
                int priority = ((Number)value).intValue();
                this.forceSampling = priority > 0 ? Boolean.TRUE : Boolean.FALSE;
                this.spanContext = this.spanContext.withSamplingDecision(this.forceSampling);
            }
            if ((this.forceSampling == null || !this.forceSampling.booleanValue()) && key.equals("debug") && value != null && value.toString().equals("true")) {
                this.forceSampling = Boolean.TRUE;
                this.spanContext = this.spanContext.withSamplingDecision(this.forceSampling);
            }
            if (Tags.ERROR.getKey().equals(key)) {
                this.isError = true;
            }
            if (this.forceSampling == null && Tags.ERROR.getKey().equals(key) && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                this.forceSampling = Boolean.TRUE;
                this.spanContext = this.spanContext.withSamplingDecision(this.forceSampling);
            }
        }
        return this;
    }

    public boolean isError() {
        return this.isError;
    }

    public WavefrontSpan log(Map<String, ?> map) {
        this.updateSpanLogsInternal(this.getCurrentTimeMicros(), map);
        return this;
    }

    public WavefrontSpan log(long currentTimeMicros, Map<String, ?> map) {
        this.updateSpanLogsInternal(currentTimeMicros, map);
        return this;
    }

    public WavefrontSpan log(String s) {
        this.updateSpanLogsInternal(this.getCurrentTimeMicros(), Collections.singletonMap("event", s));
        return this;
    }

    public WavefrontSpan log(long currentTimeMicros, String s) {
        this.updateSpanLogsInternal(currentTimeMicros, Collections.singletonMap("event", s));
        return this;
    }

    private synchronized WavefrontSpan updateSpanLogsInternal(long currentTimeMicros, Map<String, ?> fields) {
        if (this.spanLogs == null) {
            this.spanLogs = new ArrayList<SpanLog>();
        }
        if (fields != null) {
            Map<String, String> finalFields = fields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
            this.spanLogs.add(new SpanLog(currentTimeMicros, finalFields));
        }
        return this;
    }

    public synchronized WavefrontSpan setBaggageItem(String key, String value) {
        this.spanContext = this.spanContext.withBaggageItem(key, value);
        return this;
    }

    @Nullable
    public synchronized String getBaggageItem(String key) {
        return this.spanContext.getBaggageItem(key);
    }

    public synchronized WavefrontSpan setOperationName(String s) {
        this.operationName = s;
        return this;
    }

    public void finish() {
        if (this.startTimeNanos != 0L) {
            long duration = System.nanoTime() - this.startTimeNanos;
            this.doFinish(TimeUnit.NANOSECONDS.toMicros(duration));
        } else {
            this.finish(this.tracer.currentTimeMicros());
        }
    }

    public void finish(long finishTimeMicros) {
        this.doFinish(finishTimeMicros - this.startTimeMicros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinish(long durationMicros) {
        WavefrontSpan wavefrontSpan = this;
        synchronized (wavefrontSpan) {
            if (this.finished) {
                return;
            }
            this.durationMicroseconds = durationMicros;
            this.finished = true;
        }
        if (!(this.forceSampling != null || this.spanContext.isSampled() && this.spanContext.getSamplingDecision().booleanValue())) {
            boolean decision = this.tracer.sample(this.operationName, this.spanContext.getTraceId().getLeastSignificantBits(), durationMicros / 1000L, this.spanContext.isSampled() ? this.spanContext.getSamplingDecision() : true);
            WavefrontSpanContext wavefrontSpanContext = this.spanContext = decision ? this.spanContext.withSamplingDecision(decision) : this.spanContext;
        }
        if (this.spanContext.isSampled() && this.spanContext.getSamplingDecision().booleanValue()) {
            this.tracer.reportSpan(this);
        } else if (this.spansDiscarded != null) {
            this.spansDiscarded.inc();
        }
        this.tracer.reportWavefrontGeneratedData(this);
    }

    public synchronized String getOperationName() {
        return this.operationName;
    }

    public long getStartTimeMicros() {
        return this.startTimeMicros;
    }

    public synchronized long getDurationMicroseconds() {
        return this.durationMicroseconds;
    }

    public synchronized List<Pair<String, String>> getTagsAsList() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.tags);
    }

    public synchronized Map<String, Collection<String>> getTagsAsMap() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.tags.stream().collect(Collectors.groupingBy(p -> (String)p._1, Collectors.mapping(p -> (String)p._2, Collectors.toList()))));
    }

    public synchronized List<SpanLog> getSpanLogs() {
        if (this.spanLogs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.spanLogs);
    }

    @Nullable
    public synchronized String getSingleValuedTagValue(String key) {
        if (this.singleValuedTags == null || !this.singleValuedTags.containsKey(key)) {
            return null;
        }
        return (String)this.singleValuedTags.get((Object)key)._2;
    }

    public List<Reference> getParents() {
        if (this.parents == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.parents);
    }

    public List<Reference> getFollows() {
        if (this.follows == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.follows);
    }

    public String getComponentTagValue() {
        return this.componentTagValue;
    }

    public String toString() {
        return "WavefrontSpan{operationName='" + this.operationName + '\'' + ", startTimeMicros=" + this.startTimeMicros + ", durationMicroseconds=" + this.durationMicroseconds + ", tags=" + this.tags + ", spanContext=" + this.spanContext + ", parents=" + this.parents + ", follows=" + this.follows + '}';
    }

    private long getCurrentTimeMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    public static boolean isSingleValuedTagKey(String key) {
        return SINGLE_VALUED_TAG_KEYS.contains(key);
    }
}

