/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing;

import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class WavefrontSpanContext
implements SpanContext {
    private final UUID traceId;
    private final UUID spanId;
    private final Boolean samplingDecision;
    private final Map<String, String> baggage;

    public WavefrontSpanContext(UUID traceId, UUID spanId) {
        this(traceId, spanId, null, null);
    }

    public WavefrontSpanContext(UUID traceId, UUID spanId, Map<String, String> baggage, Boolean decision) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.samplingDecision = decision;
        this.baggage = baggage == null ? Collections.emptyMap() : baggage;
    }

    public String toTraceId() {
        return this.traceId.toString();
    }

    public String toSpanId() {
        return this.spanId.toString();
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return Collections.unmodifiableMap(this.baggage).entrySet();
    }

    @Nullable
    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    public WavefrontSpanContext withBaggageItem(String key, String value) {
        HashMap<String, String> items = new HashMap<String, String>(this.baggage);
        items.put(key, value);
        return new WavefrontSpanContext(this.traceId, this.spanId, items, this.samplingDecision);
    }

    Map<String, String> getBaggage() {
        return this.baggage;
    }

    WavefrontSpanContext withSamplingDecision(boolean decision) {
        return new WavefrontSpanContext(this.traceId, this.spanId, this.baggage, decision);
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public UUID getSpanId() {
        return this.spanId;
    }

    public boolean isSampled() {
        return this.samplingDecision != null;
    }

    @Nullable
    public Boolean getSamplingDecision() {
        return this.samplingDecision;
    }

    public String toString() {
        return "WavefrontSpanContext{traceId=" + this.traceId + ", spanId=" + this.spanId + '}';
    }
}

