/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing;

import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.opentracing.WavefrontSpan;
import com.wavefront.opentracing.WavefrontSpanBuilder;
import com.wavefront.opentracing.WavefrontSpanContext;
import com.wavefront.opentracing.propagation.Propagator;
import com.wavefront.opentracing.propagation.PropagatorRegistry;
import com.wavefront.opentracing.reporting.CompositeReporter;
import com.wavefront.opentracing.reporting.Reporter;
import com.wavefront.opentracing.reporting.WavefrontSpanReporter;
import com.wavefront.sdk.appagent.jvm.reporter.WavefrontJvmReporter;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.common.application.HeartbeaterService;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import com.wavefront.sdk.entities.tracing.sampling.Sampler;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.ThreadLocalScopeManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class WavefrontTracer
implements Tracer,
Closeable {
    private static final Logger logger = Logger.getLogger(WavefrontTracer.class.getName());
    private final ScopeManager scopeManager;
    private final PropagatorRegistry registry;
    private final Reporter reporter;
    private final List<Pair<String, String>> tags;
    private final List<Sampler> samplers;
    @Nullable
    private final WavefrontSpanReporter wfSpanReporter;
    @Nullable
    private final WavefrontInternalReporter wfInternalReporter;
    @Nullable
    private final WavefrontInternalReporter wfDerivedReporter;
    @Nullable
    private final HeartbeaterService heartbeaterService;
    @Nullable
    private final WavefrontJvmReporter wfJvmReporter;
    private final Supplier<Long> reportFrequencyMillis;
    private final ApplicationTags applicationTags;
    private final Set<String> redMetricsCustomTagKeys;
    private final boolean addCustomTagsToHeartbeatMetric;
    private final boolean useSpanId128Bit;
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final String WAVEFRONT_GENERATED_COMPONENT = "wavefront-generated";
    private static final String OPENTRACING_COMPONENT = "opentracing";
    private static final String JAVA_COMPONENT = "java";

    private WavefrontTracer(Builder builder) {
        this.scopeManager = builder.scopeManager;
        this.registry = builder.registry;
        this.reporter = builder.reporter;
        this.tags = builder.tags;
        this.samplers = builder.samplers;
        this.applicationTags = builder.applicationTags;
        this.reportFrequencyMillis = builder.reportingFrequencyMillis;
        this.redMetricsCustomTagKeys = builder.redMetricsCustomTagKeys;
        this.addCustomTagsToHeartbeatMetric = builder.addCustomTagsToHeartbeatMetric;
        this.useSpanId128Bit = builder.useSpanId128Bit;
        this.wfSpanReporter = this.getWavefrontSpanReporter(this.reporter);
        if (this.wfSpanReporter != null) {
            Tuple tuple = this.instantiateWavefrontStatsReporter(this.wfSpanReporter, builder.applicationTags, builder.includeJvmMetrics);
            this.wfInternalReporter = tuple.wfInternalReporter;
            this.wfDerivedReporter = tuple.wfDerivedReporter;
            this.wfJvmReporter = tuple.wfJvmReporter;
            this.heartbeaterService = tuple.heartbeaterService;
            this.wfSpanReporter.setMetricsReporter(this.wfInternalReporter);
        } else {
            this.wfInternalReporter = null;
            this.wfDerivedReporter = null;
            this.wfJvmReporter = null;
            this.heartbeaterService = null;
        }
    }

    @Nullable
    private WavefrontSpanReporter getWavefrontSpanReporter(Reporter reporter) {
        if (reporter instanceof WavefrontSpanReporter) {
            return (WavefrontSpanReporter)reporter;
        }
        if (reporter instanceof CompositeReporter) {
            CompositeReporter compositeReporter = (CompositeReporter)reporter;
            for (Reporter item : compositeReporter.getReporters()) {
                if (!(item instanceof WavefrontSpanReporter)) continue;
                return (WavefrontSpanReporter)item;
            }
        }
        return null;
    }

    private Tuple instantiateWavefrontStatsReporter(WavefrontSpanReporter wfSpanReporter, ApplicationTags applicationTags, boolean includeJvmMetrics) {
        HashMap pointTags = new HashMap(applicationTags.toPointTags());
        WavefrontInternalReporter wfInternalReporter = new WavefrontInternalReporter.Builder().prefixedWith("~sdk.java.opentracing").withSource(wfSpanReporter.getSource()).withReporterPointTags(pointTags).build(wfSpanReporter.getWavefrontSender());
        wfInternalReporter.start(1L, TimeUnit.MINUTES);
        double sdkVersion = Utils.getSemVerGauge((String)"wavefront-opentracing-sdk-java");
        wfInternalReporter.newGauge(new MetricName("version", Collections.emptyMap()), () -> () -> sdkVersion);
        WavefrontInternalReporter wfDerivedReporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource(wfSpanReporter.getSource()).withReporterPointTags(pointTags).reportMinuteDistribution().build(wfSpanReporter.getWavefrontSender());
        wfDerivedReporter.start(this.reportFrequencyMillis.get().longValue(), TimeUnit.MILLISECONDS);
        WavefrontJvmReporter wfJvmReporter = null;
        if (includeJvmMetrics) {
            wfJvmReporter = new WavefrontJvmReporter.Builder(applicationTags).withSource(wfSpanReporter.getSource()).build(wfSpanReporter.getWavefrontSender());
            wfJvmReporter.start();
        }
        HeartbeaterService heartbeaterService = new HeartbeaterService((WavefrontMetricSender)wfSpanReporter.getWavefrontSender(), applicationTags, Arrays.asList(WAVEFRONT_GENERATED_COMPONENT, OPENTRACING_COMPONENT, JAVA_COMPONENT), wfSpanReporter.getSource());
        return new Tuple(wfInternalReporter, wfDerivedReporter, wfJvmReporter, heartbeaterService);
    }

    @Nullable
    WavefrontInternalReporter getWfInternalReporter() {
        return this.wfInternalReporter;
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        return this.scopeManager.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new WavefrontSpanBuilder(operationName, this);
    }

    public <T> void inject(SpanContext spanContext, Format<T> format, T carrier) {
        Propagator<T> propagator = this.registry.get(format);
        if (propagator == null) {
            throw new IllegalArgumentException("invalid format: " + format.toString());
        }
        propagator.inject((WavefrontSpanContext)spanContext, carrier);
    }

    public <T> SpanContext extract(Format<T> format, T carrier) {
        Propagator<T> propagator = this.registry.get(format);
        if (propagator == null) {
            throw new IllegalArgumentException("invalid format: " + format.toString());
        }
        return propagator.extract(carrier);
    }

    boolean sample(String operationName, long traceId, long duration) {
        return this.sample(operationName, traceId, duration, true);
    }

    boolean sample(String operationName, long traceId, long duration, boolean defaultValue) {
        if (this.samplers == null || this.samplers.isEmpty()) {
            return defaultValue;
        }
        boolean earlySampling = duration == 0L;
        for (Sampler sampler : this.samplers) {
            boolean doSample;
            boolean bl = doSample = earlySampling == sampler.isEarly();
            if (doSample && sampler.sample(operationName, traceId, duration)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(sampler.getClass().getSimpleName() + "=" + true + " op=" + operationName);
                }
                return true;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer(sampler.getClass().getSimpleName() + "=" + false + " op=" + operationName);
        }
        return false;
    }

    void reportWavefrontGeneratedData(WavefrontSpan span) {
        if (this.wfSpanReporter == null || this.wfDerivedReporter == null) {
            return;
        }
        Pair heartbeatMetricKey = SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)this.wfDerivedReporter, (String)span.getOperationName(), (String)this.getSingleValuedTagValueOrDefault(span, "application", this.applicationTags.getApplication()), (String)this.getSingleValuedTagValueOrDefault(span, "service", this.applicationTags.getService()), (String)this.getSingleValuedTagValueOrDefault(span, "cluster", this.applicationTags.getCluster()), (String)this.getSingleValuedTagValueOrDefault(span, "shard", this.applicationTags.getCluster()), (String)this.wfSpanReporter.getSource(), (String)span.getComponentTagValue(), (boolean)span.isError(), (long)span.getDurationMicroseconds(), this.redMetricsCustomTagKeys, span.getTagsAsList());
        if (this.heartbeaterService != null && this.addCustomTagsToHeartbeatMetric) {
            this.heartbeaterService.reportCustomTags((Map)heartbeatMetricKey._1);
        }
    }

    private String getSingleValuedTagValueOrDefault(WavefrontSpan span, String key, String defaultValue) {
        String spanTagValue = span.getSingleValuedTagValue(key);
        return spanTagValue == null ? defaultValue : spanTagValue;
    }

    void reportSpan(WavefrontSpan span) {
        try {
            this.reporter.report(span);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error reporting span", ex);
        }
    }

    long currentTimeMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    List<Pair<String, String>> getTags() {
        return this.tags;
    }

    boolean isUseSpanId128Bit() {
        return this.useSpanId128Bit;
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.reporter.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing reporter", e);
        }
        if (this.wfInternalReporter != null) {
            this.wfInternalReporter.stop();
        }
        if (this.wfDerivedReporter != null) {
            this.wfDerivedReporter.stop();
        }
        if (this.wfJvmReporter != null) {
            this.wfJvmReporter.stop();
        }
        if (this.heartbeaterService != null) {
            this.heartbeaterService.close();
        }
    }

    public void flush() {
        this.reporter.flush();
        if (this.wfInternalReporter != null) {
            this.wfInternalReporter.report();
        }
        if (this.wfDerivedReporter != null) {
            this.wfDerivedReporter.report();
        }
        if (this.wfJvmReporter != null) {
            this.wfJvmReporter.report();
        }
    }

    public static class Builder {
        private final List<Pair<String, String>> tags;
        private final Reporter reporter;
        private ScopeManager scopeManager = new ThreadLocalScopeManager();
        private final ApplicationTags applicationTags;
        private final List<Sampler> samplers;
        private Supplier<Long> reportingFrequencyMillis = () -> 60000L;
        private final Set<String> redMetricsCustomTagKeys = new HashSet<String>();
        private boolean includeJvmMetrics = true;
        private final PropagatorRegistry registry = new PropagatorRegistry();
        private boolean addCustomTagsToHeartbeatMetric = true;
        private boolean useSpanId128Bit = true;

        public Builder(Reporter reporter, ApplicationTags applicationTags) {
            this.reporter = reporter;
            this.applicationTags = applicationTags;
            this.tags = new ArrayList<Pair<String, String>>();
            this.samplers = new ArrayList<Sampler>();
        }

        public Builder withGlobalTag(String key, String value) {
            if (key != null && !key.isEmpty() && value != null && !value.isEmpty()) {
                this.tags.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            }
            return this;
        }

        public Builder withGlobalTags(Map<String, String> tags) {
            if (tags != null && !tags.isEmpty()) {
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    this.withGlobalTag(tag.getKey(), tag.getValue());
                }
            }
            return this;
        }

        public Builder withGlobalMultiValuedTags(Map<String, Collection<String>> tags) {
            if (tags != null && !tags.isEmpty()) {
                for (Map.Entry<String, Collection<String>> tag : tags.entrySet()) {
                    for (String value : tag.getValue()) {
                        this.withGlobalTag(tag.getKey(), value);
                    }
                }
            }
            return this;
        }

        private void applyApplicationTags() {
            this.withGlobalTag("application", this.applicationTags.getApplication());
            this.withGlobalTag("service", this.applicationTags.getService());
            this.withGlobalTag("cluster", this.applicationTags.getCluster() == null ? "none" : this.applicationTags.getCluster());
            this.withGlobalTag("shard", this.applicationTags.getShard() == null ? "none" : this.applicationTags.getShard());
            this.withGlobalTags(this.applicationTags.getCustomTags());
        }

        public Builder withSampler(Sampler sampler) {
            this.samplers.add(sampler);
            return this;
        }

        public Builder withScopeManager(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public Builder excludeJvmMetrics() {
            this.includeJvmMetrics = false;
            return this;
        }

        public Builder excludeCustomTagsFromHeartbeatMetric() {
            this.addCustomTagsToHeartbeatMetric = false;
            return this;
        }

        public <T> Builder registerPropagator(Format<T> format, Propagator<T> propagator) {
            this.registry.register(format, propagator);
            return this;
        }

        public Builder redMetricsCustomTagKeys(Set<String> redMetricsCustomTagKeys) {
            this.redMetricsCustomTagKeys.addAll(redMetricsCustomTagKeys);
            return this;
        }

        public Builder useSpanId128Bit(boolean useSpanId128Bit) {
            this.useSpanId128Bit = useSpanId128Bit;
            return this;
        }

        Builder setReportFrequenceMillis(long reportFrequenceMillis) {
            this.reportingFrequencyMillis = () -> reportFrequenceMillis;
            return this;
        }

        public WavefrontTracer build() {
            this.applyApplicationTags();
            this.redMetricsCustomTagKeys.add(Tags.SPAN_KIND.getKey());
            return new WavefrontTracer(this);
        }
    }

    private class Tuple {
        WavefrontInternalReporter wfInternalReporter;
        WavefrontInternalReporter wfDerivedReporter;
        @Nullable
        WavefrontJvmReporter wfJvmReporter;
        HeartbeaterService heartbeaterService;

        Tuple(WavefrontInternalReporter wfInternalReporter, WavefrontInternalReporter wfDerivedReporter, WavefrontJvmReporter wfJvmReporter, HeartbeaterService heartbeaterService) {
            this.wfInternalReporter = wfInternalReporter;
            this.wfDerivedReporter = wfDerivedReporter;
            this.wfJvmReporter = wfJvmReporter;
            this.heartbeaterService = heartbeaterService;
        }
    }
}

