/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.opentracing.propagation;

import com.wavefront.opentracing.propagation.HTTPPropagator;
import com.wavefront.opentracing.propagation.Propagator;
import com.wavefront.opentracing.propagation.TextMapPropagator;
import io.opentracing.propagation.Format;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PropagatorRegistry {
    private final Map<Format<?>, Propagator<?>> propagators = new HashMap();

    public PropagatorRegistry() {
        this.register(Format.Builtin.TEXT_MAP, new TextMapPropagator());
        this.register(Format.Builtin.HTTP_HEADERS, new HTTPPropagator());
    }

    @Nullable
    public <T> Propagator<T> get(Format<T> format) {
        return this.propagators.get(format);
    }

    public <T> void register(Format<T> format, Propagator<T> propagator) {
        this.propagators.put(format, propagator);
    }
}

