/*
 * Decompiled with CFR 0.152.
 */
package com.wire.crypto;

import com.wire.crypto.FfiConverterRustBuffer;
import com.wire.crypto.RustBuffer;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/wire/crypto/FfiConverterDuration;", "Lcom/wire/crypto/FfiConverterRustBuffer;", "Ljava/time/Duration;", "()V", "allocationSize", "", "value", "read", "buf", "Ljava/nio/ByteBuffer;", "write", "", "jvm"})
public final class FfiConverterDuration
implements FfiConverterRustBuffer<Duration> {
    @NotNull
    public static final FfiConverterDuration INSTANCE = new FfiConverterDuration();

    private FfiConverterDuration() {
    }

    @Override
    @NotNull
    public Duration read(@NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        long seconds = buf.getLong();
        long nanoseconds = buf.getInt();
        if (seconds < 0L) {
            throw new DateTimeException("Duration exceeds minimum or maximum value supported by uniffi");
        }
        if (nanoseconds < 0L) {
            throw new DateTimeException("Duration nanoseconds exceed minimum or maximum supported by uniffi");
        }
        Duration duration = Duration.ofSeconds(seconds, nanoseconds);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return duration;
    }

    @Override
    public int allocationSize(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return 12;
    }

    @Override
    public void write(@NotNull Duration value, @NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (value.getSeconds() < 0L) {
            throw new IllegalArgumentException("Invalid duration, must be non-negative");
        }
        if (value.getNano() < 0) {
            throw new IllegalArgumentException("Invalid duration, nano value must be non-negative");
        }
        buf.putLong(value.getSeconds());
        buf.putInt(value.getNano());
    }

    @Override
    @NotNull
    public Duration lift(@NotNull RustBuffer.ByValue value) {
        return FfiConverterRustBuffer.DefaultImpls.lift(this, value);
    }

    @Override
    @NotNull
    public RustBuffer.ByValue lower(@NotNull Duration value) {
        return FfiConverterRustBuffer.DefaultImpls.lower(this, value);
    }

    @Override
    @NotNull
    public RustBuffer.ByValue lowerIntoRustBuffer(@NotNull Duration value) {
        return FfiConverterRustBuffer.DefaultImpls.lowerIntoRustBuffer(this, value);
    }

    @Override
    @NotNull
    public Duration liftFromRustBuffer(@NotNull RustBuffer.ByValue rbuf) {
        return FfiConverterRustBuffer.DefaultImpls.liftFromRustBuffer(this, rbuf);
    }
}

