// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package com.wire.crypto;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.locks.ReentrantLock
import kotlin.concurrent.withLock
import kotlin.coroutines.Continuation
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.isActive
import kotlinx.coroutines.launch
import kotlinx.coroutines.suspendCancellableCoroutine
import uniffi.core_crypto.CryptoError
import uniffi.core_crypto.E2eIdentityError
import uniffi.core_crypto.FfiConverterTypeCryptoError
import uniffi.core_crypto.FfiConverterTypeE2eIdentityError
import uniffi.core_crypto.RustBuffer as RustBufferCryptoError
import uniffi.core_crypto.RustBuffer as RustBufferE2eIdentityError

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    @JvmField var capacity: Int = 0
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

    companion object {
        internal fun alloc(size: Int = 0) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_core_crypto_ffi_rustbuffer_alloc(size, status).also {
                if(it.data == null) {
                   throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
               }
            }
        }

        internal fun free(buf: RustBuffer.ByValue) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_core_crypto_ffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getInt(0))
        value.writeField("len", pointer.getInt(4))
        value.writeField("data", pointer.getPointer(8))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
@Structure.FieldOrder("code", "error_buf")
internal open class RustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: RustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == 0.toByte()
    }

    fun isError(): Boolean {
        return code == 1.toByte()
    }

    fun isPanic(): Boolean {
        return code == 2.toByte()
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface CallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> rustCallWithError(errorHandler: CallStatusErrorHandler<E>, callback: (RustCallStatus) -> U): U {
    var status = RustCallStatus();
    val return_value = callback(status)
    checkCallStatus(errorHandler, status)
    return return_value
}

// Check RustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> checkCallStatus(errorHandler: CallStatusErrorHandler<E>, status: RustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// CallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object NullCallStatusErrorHandler: CallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> rustCall(callback: (RustCallStatus) -> U): U {
    return rustCallWithError(NullCallStatusErrorHandler, callback);
}

// IntegerType that matches Rust's `usize` / C's `size_t`
public class USize(value: Long = 0) : IntegerType(Native.SIZE_T_SIZE, value, true) {
    // This is needed to fill in the gaps of IntegerType's implementation of Number for Kotlin.
    override fun toByte() = toInt().toByte()
    // Needed until https://youtrack.jetbrains.com/issue/KT-47902 is fixed.
    @Deprecated("`toInt().toChar()` is deprecated")
    override fun toChar() = toInt().toChar()
    override fun toShort() = toInt().toShort()

    fun writeToBuffer(buf: ByteBuffer) {
        // Make sure we always write usize integers using native byte-order, since they may be
        // casted to pointer values
        buf.order(ByteOrder.nativeOrder())
        try {
            when (Native.SIZE_T_SIZE) {
                4 -> buf.putInt(toInt())
                8 -> buf.putLong(toLong())
                else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
            }
        } finally {
            buf.order(ByteOrder.BIG_ENDIAN)
        }
    }

    companion object {
        val size: Int
            get() = Native.SIZE_T_SIZE

        fun readFromBuffer(buf: ByteBuffer) : USize {
            // Make sure we always read usize integers using native byte-order, since they may be
            // casted from pointer values
            buf.order(ByteOrder.nativeOrder())
            try {
                return when (Native.SIZE_T_SIZE) {
                    4 -> USize(buf.getInt().toLong())
                    8 -> USize(buf.getLong())
                    else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
                }
            } finally {
                buf.order(ByteOrder.BIG_ENDIAN)
            }
        }
    }
}


// Map handles to objects
//
// This is used when the Rust code expects an opaque pointer to represent some foreign object.
// Normally we would pass a pointer to the object, but JNA doesn't support getting a pointer from an
// object reference , nor does it support leaking a reference to Rust.
//
// Instead, this class maps USize values to objects so that we can pass a pointer-sized type to
// Rust when it needs an opaque pointer.
//
// TODO: refactor callbacks to use this class
internal class UniFfiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<USize, T>()
    // Use AtomicInteger for our counter, since we may be on a 32-bit system.  4 billion possible
    // values seems like enough. If somehow we generate 4 billion handles, then this will wrap
    // around back to zero and we can assume the first handle generated will have been dropped by
    // then.
    private val counter = java.util.concurrent.atomic.AtomicInteger(0)

    val size: Int
        get() = map.size

    fun insert(obj: T): USize {
        val handle = USize(counter.getAndAdd(1).toLong())
        map.put(handle, obj)
        return handle
    }

    fun get(handle: USize): T? {
        return map.get(handle)
    }

    fun remove(handle: USize) {
        map.remove(handle)
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "core_crypto_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface _UniFFILib : Library {
    companion object {
        internal val INSTANCE: _UniFFILib by lazy {
            loadIndirect<_UniFFILib>(componentName = "core_crypto_ffi")
            .also { lib: _UniFFILib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                FfiConverterForeignExecutor.register(lib)
                FfiConverterTypeCoreCryptoCallbacks.register(lib)
                }
        }
    }

    fun uniffi_core_crypto_ffi_fn_free_corecrypto(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_add_clients_to_conversation(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`keyPackages`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_clear_pending_commit(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_clear_pending_group_from_external_commit(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_clear_pending_proposal(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`proposalRef`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_client_keypackages(`ptr`: Pointer,`ciphersuite`: Short,`credentialType`: RustBuffer.ByValue,`amountRequested`: Int,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_client_public_key(`ptr`: Pointer,`ciphersuite`: Short,`credentialType`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_client_valid_keypackages_count(`ptr`: Pointer,`ciphersuite`: Short,`credentialType`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackLong,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_commit_accepted(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_commit_pending_proposals(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_conversation_epoch(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackLong,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_conversation_exists(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_create_conversation(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`creatorCredentialType`: RustBuffer.ByValue,`config`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_decrypt_message(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`payload`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_delete_keypackages(`ptr`: Pointer,`refs`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_conversation_state(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_dump_pki_env(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_enrollment_stash(`ptr`: Pointer,`enrollment`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_enrollment_stash_pop(`ptr`: Pointer,`handle`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_is_enabled(`ptr`: Pointer,`ciphersuite`: Short,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_is_pki_env_setup(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_mls_init_only(`ptr`: Pointer,`enrollment`: Pointer,`certificateChain`: RustBuffer.ByValue,`nbKeyPackage`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_new_activation_enrollment(`ptr`: Pointer,`displayName`: RustBuffer.ByValue,`handle`: RustBuffer.ByValue,`team`: RustBuffer.ByValue,`expirySec`: Int,`ciphersuite`: Short,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_new_enrollment(`ptr`: Pointer,`clientId`: RustBuffer.ByValue,`displayName`: RustBuffer.ByValue,`handle`: RustBuffer.ByValue,`team`: RustBuffer.ByValue,`expirySec`: Int,`ciphersuite`: Short,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_new_rotate_enrollment(`ptr`: Pointer,`displayName`: RustBuffer.ByValue,`handle`: RustBuffer.ByValue,`team`: RustBuffer.ByValue,`expirySec`: Int,`ciphersuite`: Short,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_register_acme_ca(`ptr`: Pointer,`trustAnchorPem`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_register_crl(`ptr`: Pointer,`crlDp`: RustBuffer.ByValue,`crlDer`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_register_intermediate_ca(`ptr`: Pointer,`certPem`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_rotate_all(`ptr`: Pointer,`enrollment`: Pointer,`certificateChain`: RustBuffer.ByValue,`newKeyPackagesCount`: Int,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_encrypt_message(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_export_secret_key(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`keyLength`: Int,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_get_client_ids(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_get_credential_in_use(`ptr`: Pointer,`groupInfo`: RustBuffer.ByValue,`credentialType`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_get_device_identities(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`deviceIds`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_get_external_sender(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_get_user_identities(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`userIds`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_join_by_external_commit(`ptr`: Pointer,`groupInfo`: RustBuffer.ByValue,`customConfiguration`: RustBuffer.ByValue,`credentialType`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_mark_conversation_as_child_of(`ptr`: Pointer,`childId`: RustBuffer.ByValue,`parentId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_merge_pending_group_from_external_commit(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_mls_generate_keypairs(`ptr`: Pointer,`ciphersuites`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_mls_init(`ptr`: Pointer,`clientId`: RustBuffer.ByValue,`ciphersuites`: RustBuffer.ByValue,`nbKeyPackage`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_mls_init_with_client_id(`ptr`: Pointer,`clientId`: RustBuffer.ByValue,`tmpClientIds`: RustBuffer.ByValue,`ciphersuites`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_new_add_proposal(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`keypackage`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_new_external_add_proposal(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`epoch`: Long,`ciphersuite`: Short,`credentialType`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_new_remove_proposal(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`clientId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_new_update_proposal(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_process_welcome_message(`ptr`: Pointer,`welcomeMessage`: RustBuffer.ByValue,`customConfiguration`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_cryptobox_migrate(`ptr`: Pointer,`path`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_decrypt(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`ciphertext`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_encrypt(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`plaintext`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_encrypt_batched(`ptr`: Pointer,`sessions`: RustBuffer.ByValue,`plaintext`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint_local(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint_prekeybundle(`ptr`: Pointer,`prekey`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint_remote(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_init(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_last_error_code(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_last_resort_prekey(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_last_resort_prekey_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Short
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_new_prekey(`ptr`: Pointer,`prekeyId`: Short,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_new_prekey_auto(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_delete(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_exists(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_from_message(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`envelope`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_from_prekey(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`prekey`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_save(`ptr`: Pointer,`sessionId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_random_bytes(`ptr`: Pointer,`len`: Int,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_remove_clients_from_conversation(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`clients`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_reseed_rng(`ptr`: Pointer,`seed`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_restore_from_disk(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_set_callbacks(`ptr`: Pointer,`callbacks`: Long,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_unload(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_update_keying_material(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_wipe(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_corecrypto_wipe_conversation(`ptr`: Pointer,`conversationId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_free_e2eienrollment(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_certificate_request(`ptr`: Pointer,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_check_order_request(`ptr`: Pointer,`orderUrl`: RustBuffer.ByValue,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_check_order_response(`ptr`: Pointer,`order`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_create_dpop_token(`ptr`: Pointer,`expirySecs`: Int,`backendNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_directory_response(`ptr`: Pointer,`directory`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_finalize_request(`ptr`: Pointer,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_finalize_response(`ptr`: Pointer,`finalize`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_get_refresh_token(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_account_request(`ptr`: Pointer,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_account_response(`ptr`: Pointer,`account`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_authz_request(`ptr`: Pointer,`url`: RustBuffer.ByValue,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_authz_response(`ptr`: Pointer,`authz`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_dpop_challenge_request(`ptr`: Pointer,`accessToken`: RustBuffer.ByValue,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_dpop_challenge_response(`ptr`: Pointer,`challenge`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_oidc_challenge_request(`ptr`: Pointer,`idToken`: RustBuffer.ByValue,`refreshToken`: RustBuffer.ByValue,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_oidc_challenge_response(`ptr`: Pointer,`cc`: Pointer,`challenge`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_order_request(`ptr`: Pointer,`previousNonce`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_order_response(`ptr`: Pointer,`order`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_init_callback_corecryptocallbacks(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_func_core_crypto_deferred_init(`path`: RustBuffer.ByValue,`key`: RustBuffer.ByValue,`ciphersuites`: RustBuffer.ByValue,`nbKeyPackage`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_func_core_crypto_new(`path`: RustBuffer.ByValue,`key`: RustBuffer.ByValue,`clientId`: RustBuffer.ByValue,`ciphersuites`: RustBuffer.ByValue,`nbKeyPackage`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_core_crypto_ffi_fn_func_version(_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_core_crypto_ffi_rustbuffer_alloc(`size`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_core_crypto_ffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_core_crypto_ffi_rustbuffer_free(`buf`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun ffi_core_crypto_ffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_core_crypto_ffi_checksum_func_core_crypto_deferred_init(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_func_core_crypto_new(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_func_version(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_add_clients_to_conversation(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_clear_pending_commit(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_clear_pending_group_from_external_commit(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_clear_pending_proposal(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_client_keypackages(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_client_public_key(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_client_valid_keypackages_count(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_commit_accepted(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_commit_pending_proposals(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_conversation_epoch(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_conversation_exists(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_create_conversation(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_decrypt_message(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_delete_keypackages(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_conversation_state(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_dump_pki_env(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_enrollment_stash(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_enrollment_stash_pop(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_is_enabled(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_is_pki_env_setup(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_mls_init_only(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_new_activation_enrollment(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_new_enrollment(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_new_rotate_enrollment(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_register_acme_ca(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_register_crl(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_register_intermediate_ca(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_rotate_all(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_encrypt_message(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_export_secret_key(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_get_client_ids(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_get_credential_in_use(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_get_device_identities(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_get_external_sender(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_get_user_identities(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_join_by_external_commit(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_mark_conversation_as_child_of(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_merge_pending_group_from_external_commit(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_mls_generate_keypairs(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_mls_init(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_mls_init_with_client_id(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_new_add_proposal(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_new_external_add_proposal(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_new_remove_proposal(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_new_update_proposal(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_process_welcome_message(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_cryptobox_migrate(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_decrypt(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_encrypt(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_encrypt_batched(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint_local(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint_prekeybundle(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint_remote(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_init(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_last_error_code(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_last_resort_prekey(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_last_resort_prekey_id(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_new_prekey(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_new_prekey_auto(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_delete(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_exists(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_from_message(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_from_prekey(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_save(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_random_bytes(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_remove_clients_from_conversation(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_reseed_rng(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_restore_from_disk(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_set_callbacks(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_unload(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_update_keying_material(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_wipe(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecrypto_wipe_conversation(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_certificate_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_check_order_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_check_order_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_create_dpop_token(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_directory_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_finalize_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_finalize_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_get_refresh_token(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_account_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_account_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_authz_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_authz_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_dpop_challenge_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_dpop_challenge_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_oidc_challenge_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_oidc_challenge_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_order_request(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_order_response(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecryptocallbacks_authorize(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecryptocallbacks_user_authorize(
    ): Short
    fun uniffi_core_crypto_ffi_checksum_method_corecryptocallbacks_client_is_existing_group_user(
    ): Short
    fun uniffi_foreign_executor_callback_set(`callback`: UniFfiForeignExecutorCallback,
    ): Unit
    fun ffi_core_crypto_ffi_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: _UniFFILib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 23
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_core_crypto_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: _UniFFILib) {
    if (lib.uniffi_core_crypto_ffi_checksum_func_core_crypto_deferred_init() != 4029.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_func_core_crypto_new() != 42590.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_func_version() != 57049.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_add_clients_to_conversation() != 25505.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_clear_pending_commit() != 51214.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_clear_pending_group_from_external_commit() != 10634.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_clear_pending_proposal() != 38561.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_client_keypackages() != 4005.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_client_public_key() != 3054.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_client_valid_keypackages_count() != 32108.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_commit_accepted() != 25280.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_commit_pending_proposals() != 46724.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_conversation_epoch() != 64434.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_conversation_exists() != 6810.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_create_conversation() != 38220.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_decrypt_message() != 15808.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_delete_keypackages() != 1420.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_conversation_state() != 46518.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_dump_pki_env() != 13635.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_enrollment_stash() != 25889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_enrollment_stash_pop() != 23586.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_is_enabled() != 31348.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_is_pki_env_setup() != 15646.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_mls_init_only() != 42996.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_new_activation_enrollment() != 9063.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_new_enrollment() != 64148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_new_rotate_enrollment() != 58893.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_register_acme_ca() != 22098.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_register_crl() != 12655.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_register_intermediate_ca() != 54463.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_e2ei_rotate_all() != 31103.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_encrypt_message() != 9561.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_export_secret_key() != 65085.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_get_client_ids() != 13709.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_get_credential_in_use() != 54243.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_get_device_identities() != 35252.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_get_external_sender() != 52886.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_get_user_identities() != 45919.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_join_by_external_commit() != 10502.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_mark_conversation_as_child_of() != 21206.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_merge_pending_group_from_external_commit() != 44494.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_mls_generate_keypairs() != 21915.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_mls_init() != 46134.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_mls_init_with_client_id() != 15824.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_new_add_proposal() != 20172.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_new_external_add_proposal() != 44897.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_new_remove_proposal() != 31049.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_new_update_proposal() != 61789.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_process_welcome_message() != 29749.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_cryptobox_migrate() != 28450.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_decrypt() != 64229.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_encrypt() != 24790.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_encrypt_batched() != 49664.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint() != 8366.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint_local() != 47420.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint_prekeybundle() != 60388.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_fingerprint_remote() != 62918.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_init() != 30329.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_last_error_code() != 51242.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_last_resort_prekey() != 62392.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_last_resort_prekey_id() != 39946.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_new_prekey() != 33359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_new_prekey_auto() != 16010.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_delete() != 14375.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_exists() != 53577.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_from_message() != 43418.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_from_prekey() != 54693.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_proteus_session_save() != 48569.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_random_bytes() != 41134.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_remove_clients_from_conversation() != 58583.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_reseed_rng() != 10597.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_restore_from_disk() != 41369.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_set_callbacks() != 61914.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_unload() != 40210.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_update_keying_material() != 10676.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_wipe() != 42358.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecrypto_wipe_conversation() != 40186.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_certificate_request() != 17904.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_check_order_request() != 2921.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_check_order_response() != 41349.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_create_dpop_token() != 38082.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_directory_response() != 10990.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_finalize_request() != 56370.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_finalize_response() != 15817.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_get_refresh_token() != 37396.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_account_request() != 43474.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_account_response() != 32978.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_authz_request() != 480.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_authz_response() != 45815.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_dpop_challenge_request() != 62561.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_dpop_challenge_response() != 34057.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_oidc_challenge_request() != 44431.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_oidc_challenge_response() != 13253.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_order_request() != 5679.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_e2eienrollment_new_order_response() != 53479.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecryptocallbacks_authorize() != 16107.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecryptocallbacks_user_authorize() != 43230.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_core_crypto_ffi_checksum_method_corecryptocallbacks_client_is_existing_group_user() != 51162.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Public interface members begin here.


public object FfiConverterUShort: FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort {
        return value.toUShort()
    }

    override fun read(buf: ByteBuffer): UShort {
        return lift(buf.getShort())
    }

    override fun lower(value: UShort): Short {
        return value.toShort()
    }

    override fun allocationSize(value: UShort) = 2

    override fun write(value: UShort, buf: ByteBuffer) {
        buf.putShort(value.toShort())
    }
}

public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len)
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): Int {
        return 4 + value.size
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


public object FfiConverterDuration: FfiConverterRustBuffer<java.time.Duration> {
    override fun read(buf: ByteBuffer): java.time.Duration {
        // Type mismatch (should be u64) but we check for overflow/underflow below
        val seconds = buf.getLong()
        // Type mismatch (should be u32) but we check for overflow/underflow below
        val nanoseconds = buf.getInt().toLong()
        if (seconds < 0) {
            throw java.time.DateTimeException("Duration exceeds minimum or maximum value supported by uniffi")
        }
        if (nanoseconds < 0) {
            throw java.time.DateTimeException("Duration nanoseconds exceed minimum or maximum supported by uniffi")
        }
        return java.time.Duration.ofSeconds(seconds, nanoseconds)
    }

    // 8 bytes for seconds, 4 bytes for nanoseconds
    override fun allocationSize(value: java.time.Duration) = 12

    override fun write(value: java.time.Duration, buf: ByteBuffer) {
        if (value.seconds < 0) {
            // Rust does not support negative Durations
            throw IllegalArgumentException("Invalid duration, must be non-negative")
        }

        if (value.nano < 0) {
            // Java docs provide guarantee that nano will always be positive, so this should be impossible
            // See: https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html
            throw IllegalArgumentException("Invalid duration, nano value must be non-negative")
        }

        // Type mismatch (should be u64) but since Rust doesn't support negative durations we should be OK
        buf.putLong(value.seconds)
        // Type mismatch (should be u32) but since values will always be between 0 and 999,999,999 it should be OK
        buf.putInt(value.nano)
    }
}


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

// The base class for all UniFFI Object types.
//
// This class provides core operations for working with the Rust `Arc<T>` pointer to
// the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// the Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each `FFIObject` instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an `FFIObject` is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an `FFIObject` instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so will
//     leak the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each `FFIObject` an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// In the future we may be able to replace some of this with automatic finalization logic, such as using
// the new "Cleaner" functionaility in Java 9. The above scheme has been designed to work even if `destroy` is
// invoked by garbage-collection machinery rather than by calling code (which by the way, it's apparently also
// possible for the JVM to finalize an object while there is an in-flight call to one of its methods [1],
// so there would still be some complexity here).
//
// Sigh...all of this for want of a robust finalization mechanism.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//
abstract class FFIObject(
    protected val pointer: Pointer
): Disposable, AutoCloseable {

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    open protected fun freeRustArcPtr() {
        // To be overridden in subclasses.
    }

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.pointer)
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }
}

public interface CoreCryptoInterface {
    @Throws(CoreCryptoException::class)
    suspend fun `addClientsToConversation`(`conversationId`: ByteArray, `keyPackages`: List<ByteArray>): MemberAddedMessages@Throws(CoreCryptoException::class)
    suspend fun `clearPendingCommit`(`conversationId`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `clearPendingGroupFromExternalCommit`(`conversationId`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `clearPendingProposal`(`conversationId`: ByteArray, `proposalRef`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `clientKeypackages`(`ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType, `amountRequested`: UInt): List<ByteArray>@Throws(CoreCryptoException::class)
    suspend fun `clientPublicKey`(`ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `clientValidKeypackagesCount`(`ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType): ULong@Throws(CoreCryptoException::class)
    suspend fun `commitAccepted`(`conversationId`: ByteArray): List<BufferedDecryptedMessage>?@Throws(CoreCryptoException::class)
    suspend fun `commitPendingProposals`(`conversationId`: ByteArray): CommitBundle?@Throws(CoreCryptoException::class)
    suspend fun `conversationEpoch`(`conversationId`: ByteArray): ULong
    suspend fun `conversationExists`(`conversationId`: ByteArray): Boolean@Throws(CoreCryptoException::class)
    suspend fun `createConversation`(`conversationId`: ByteArray, `creatorCredentialType`: MlsCredentialType, `config`: ConversationConfiguration)@Throws(CoreCryptoException::class)
    suspend fun `decryptMessage`(`conversationId`: ByteArray, `payload`: ByteArray): DecryptedMessage@Throws(CoreCryptoException::class)
    suspend fun `deleteKeypackages`(`refs`: List<ByteArray>)@Throws(CoreCryptoException::class)
    suspend fun `e2eiConversationState`(`conversationId`: ByteArray): E2eiConversationState@Throws(CoreCryptoException::class)
    suspend fun `e2eiDumpPkiEnv`(): E2eiDumpedPkiEnv?@Throws(CoreCryptoException::class)
    suspend fun `e2eiEnrollmentStash`(`enrollment`: E2eiEnrollment): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `e2eiEnrollmentStashPop`(`handle`: ByteArray): E2eiEnrollment@Throws(CoreCryptoException::class)
    suspend fun `e2eiIsEnabled`(`ciphersuite`: Ciphersuite): Boolean
    suspend fun `e2eiIsPkiEnvSetup`(): Boolean@Throws(CoreCryptoException::class)
    suspend fun `e2eiMlsInitOnly`(`enrollment`: E2eiEnrollment, `certificateChain`: String, `nbKeyPackage`: UInt?): List<String>?@Throws(CoreCryptoException::class)
    suspend fun `e2eiNewActivationEnrollment`(`displayName`: String, `handle`: String, `team`: String?, `expirySec`: UInt, `ciphersuite`: Ciphersuite): E2eiEnrollment@Throws(CoreCryptoException::class)
    suspend fun `e2eiNewEnrollment`(`clientId`: String, `displayName`: String, `handle`: String, `team`: String?, `expirySec`: UInt, `ciphersuite`: Ciphersuite): E2eiEnrollment@Throws(CoreCryptoException::class)
    suspend fun `e2eiNewRotateEnrollment`(`displayName`: String?, `handle`: String?, `team`: String?, `expirySec`: UInt, `ciphersuite`: Ciphersuite): E2eiEnrollment@Throws(CoreCryptoException::class)
    suspend fun `e2eiRegisterAcmeCa`(`trustAnchorPem`: String)@Throws(CoreCryptoException::class)
    suspend fun `e2eiRegisterCrl`(`crlDp`: String, `crlDer`: ByteArray): CrlRegistration@Throws(CoreCryptoException::class)
    suspend fun `e2eiRegisterIntermediateCa`(`certPem`: String): List<String>?@Throws(CoreCryptoException::class)
    suspend fun `e2eiRotateAll`(`enrollment`: E2eiEnrollment, `certificateChain`: String, `newKeyPackagesCount`: UInt): RotateBundle@Throws(CoreCryptoException::class)
    suspend fun `encryptMessage`(`conversationId`: ByteArray, `message`: ByteArray): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `exportSecretKey`(`conversationId`: ByteArray, `keyLength`: UInt): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `getClientIds`(`conversationId`: ByteArray): List<ClientId>@Throws(CoreCryptoException::class)
    suspend fun `getCredentialInUse`(`groupInfo`: ByteArray, `credentialType`: MlsCredentialType): E2eiConversationState@Throws(CoreCryptoException::class)
    suspend fun `getDeviceIdentities`(`conversationId`: ByteArray, `deviceIds`: List<ClientId>): List<WireIdentity>@Throws(CoreCryptoException::class)
    suspend fun `getExternalSender`(`conversationId`: ByteArray): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `getUserIdentities`(`conversationId`: ByteArray, `userIds`: List<String>): Map<String, List<WireIdentity>>@Throws(CoreCryptoException::class)
    suspend fun `joinByExternalCommit`(`groupInfo`: ByteArray, `customConfiguration`: CustomConfiguration, `credentialType`: MlsCredentialType): ConversationInitBundle@Throws(CoreCryptoException::class)
    suspend fun `markConversationAsChildOf`(`childId`: ByteArray, `parentId`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `mergePendingGroupFromExternalCommit`(`conversationId`: ByteArray): List<BufferedDecryptedMessage>?@Throws(CoreCryptoException::class)
    suspend fun `mlsGenerateKeypairs`(`ciphersuites`: Ciphersuites): List<ClientId>@Throws(CoreCryptoException::class)
    suspend fun `mlsInit`(`clientId`: ClientId, `ciphersuites`: Ciphersuites, `nbKeyPackage`: UInt?)@Throws(CoreCryptoException::class)
    suspend fun `mlsInitWithClientId`(`clientId`: ClientId, `tmpClientIds`: List<ClientId>, `ciphersuites`: Ciphersuites)@Throws(CoreCryptoException::class)
    suspend fun `newAddProposal`(`conversationId`: ByteArray, `keypackage`: ByteArray): ProposalBundle@Throws(CoreCryptoException::class)
    suspend fun `newExternalAddProposal`(`conversationId`: ByteArray, `epoch`: ULong, `ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `newRemoveProposal`(`conversationId`: ByteArray, `clientId`: ClientId): ProposalBundle@Throws(CoreCryptoException::class)
    suspend fun `newUpdateProposal`(`conversationId`: ByteArray): ProposalBundle@Throws(CoreCryptoException::class)
    suspend fun `processWelcomeMessage`(`welcomeMessage`: ByteArray, `customConfiguration`: CustomConfiguration): WelcomeBundle@Throws(CoreCryptoException::class)
    suspend fun `proteusCryptoboxMigrate`(`path`: String)@Throws(CoreCryptoException::class)
    suspend fun `proteusDecrypt`(`sessionId`: String, `ciphertext`: ByteArray): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `proteusEncrypt`(`sessionId`: String, `plaintext`: ByteArray): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `proteusEncryptBatched`(`sessions`: List<String>, `plaintext`: ByteArray): Map<String, ByteArray>@Throws(CoreCryptoException::class)
    suspend fun `proteusFingerprint`(): String@Throws(CoreCryptoException::class)
    suspend fun `proteusFingerprintLocal`(`sessionId`: String): String@Throws(CoreCryptoException::class)
    fun `proteusFingerprintPrekeybundle`(`prekey`: ByteArray): String@Throws(CoreCryptoException::class)
    suspend fun `proteusFingerprintRemote`(`sessionId`: String): String@Throws(CoreCryptoException::class)
    suspend fun `proteusInit`()
    fun `proteusLastErrorCode`(): UInt@Throws(CoreCryptoException::class)
    suspend fun `proteusLastResortPrekey`(): ByteArray@Throws(CoreCryptoException::class)
    fun `proteusLastResortPrekeyId`(): UShort@Throws(CoreCryptoException::class)
    suspend fun `proteusNewPrekey`(`prekeyId`: UShort): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `proteusNewPrekeyAuto`(): ProteusAutoPrekeyBundle@Throws(CoreCryptoException::class)
    suspend fun `proteusSessionDelete`(`sessionId`: String)@Throws(CoreCryptoException::class)
    suspend fun `proteusSessionExists`(`sessionId`: String): Boolean@Throws(CoreCryptoException::class)
    suspend fun `proteusSessionFromMessage`(`sessionId`: String, `envelope`: ByteArray): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `proteusSessionFromPrekey`(`sessionId`: String, `prekey`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `proteusSessionSave`(`sessionId`: String)@Throws(CoreCryptoException::class)
    suspend fun `randomBytes`(`len`: UInt): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `removeClientsFromConversation`(`conversationId`: ByteArray, `clients`: List<ClientId>): CommitBundle@Throws(CoreCryptoException::class)
    suspend fun `reseedRng`(`seed`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `restoreFromDisk`()@Throws(CoreCryptoException::class)
    suspend fun `setCallbacks`(`callbacks`: CoreCryptoCallbacks)@Throws(CoreCryptoException::class)
    suspend fun `unload`()@Throws(CoreCryptoException::class)
    suspend fun `updateKeyingMaterial`(`conversationId`: ByteArray): CommitBundle@Throws(CoreCryptoException::class)
    suspend fun `wipe`()@Throws(CoreCryptoException::class)
    suspend fun `wipeConversation`(`conversationId`: ByteArray)
}

class CoreCrypto(
    pointer: Pointer
) : FFIObject(pointer), CoreCryptoInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_free_corecrypto(this.pointer, status)
        }
    }

    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addClientsToConversation`(`conversationId`: ByteArray, `keyPackages`: List<ByteArray>) : MemberAddedMessages {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeMemberAddedMessages_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_add_clients_to_conversation(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterSequenceByteArray.lower(`keyPackages`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clearPendingCommit`(`conversationId`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_clear_pending_commit(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clearPendingGroupFromExternalCommit`(`conversationId`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_clear_pending_group_from_external_commit(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clearPendingProposal`(`conversationId`: ByteArray, `proposalRef`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_clear_pending_proposal(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterByteArray.lower(`proposalRef`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clientKeypackages`(`ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType, `amountRequested`: UInt) : List<ByteArray> {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerSequenceByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_client_keypackages(
                                thisPtr,
                                FfiConverterTypeCiphersuite.lower(`ciphersuite`),FfiConverterTypeMlsCredentialType.lower(`credentialType`),FfiConverterUInt.lower(`amountRequested`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clientPublicKey`(`ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_client_public_key(
                                thisPtr,
                                FfiConverterTypeCiphersuite.lower(`ciphersuite`),FfiConverterTypeMlsCredentialType.lower(`credentialType`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clientValidKeypackagesCount`(`ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType) : ULong {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerULong_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_client_valid_keypackages_count(
                                thisPtr,
                                FfiConverterTypeCiphersuite.lower(`ciphersuite`),FfiConverterTypeMlsCredentialType.lower(`credentialType`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `commitAccepted`(`conversationId`: ByteArray) : List<BufferedDecryptedMessage>? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalSequenceTypeBufferedDecryptedMessage_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_commit_accepted(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `commitPendingProposals`(`conversationId`: ByteArray) : CommitBundle? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalTypeCommitBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_commit_pending_proposals(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `conversationEpoch`(`conversationId`: ByteArray) : ULong {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerULong_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_conversation_epoch(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `conversationExists`(`conversationId`: ByteArray) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_conversation_exists(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `createConversation`(`conversationId`: ByteArray, `creatorCredentialType`: MlsCredentialType, `config`: ConversationConfiguration) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_create_conversation(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterTypeMlsCredentialType.lower(`creatorCredentialType`),FfiConverterTypeConversationConfiguration.lower(`config`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `decryptMessage`(`conversationId`: ByteArray, `payload`: ByteArray) : DecryptedMessage {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeDecryptedMessage_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_decrypt_message(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterByteArray.lower(`payload`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `deleteKeypackages`(`refs`: List<ByteArray>) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_delete_keypackages(
                                thisPtr,
                                FfiConverterSequenceByteArray.lower(`refs`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiConversationState`(`conversationId`: ByteArray) : E2eiConversationState {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeE2eiConversationState_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_conversation_state(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiDumpPkiEnv`() : E2eiDumpedPkiEnv? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalTypeE2eiDumpedPkiEnv_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_dump_pki_env(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiEnrollmentStash`(`enrollment`: E2eiEnrollment) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_enrollment_stash(
                                thisPtr,
                                FfiConverterTypeE2eiEnrollment.lower(`enrollment`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiEnrollmentStashPop`(`handle`: ByteArray) : E2eiEnrollment {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeE2eiEnrollment_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_enrollment_stash_pop(
                                thisPtr,
                                FfiConverterByteArray.lower(`handle`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiIsEnabled`(`ciphersuite`: Ciphersuite) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_is_enabled(
                                thisPtr,
                                FfiConverterTypeCiphersuite.lower(`ciphersuite`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiIsPkiEnvSetup`() : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_is_pki_env_setup(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiMlsInitOnly`(`enrollment`: E2eiEnrollment, `certificateChain`: String, `nbKeyPackage`: UInt?) : List<String>? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalSequenceString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_mls_init_only(
                                thisPtr,
                                FfiConverterTypeE2eiEnrollment.lower(`enrollment`),FfiConverterString.lower(`certificateChain`),FfiConverterOptionalUInt.lower(`nbKeyPackage`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiNewActivationEnrollment`(`displayName`: String, `handle`: String, `team`: String?, `expirySec`: UInt, `ciphersuite`: Ciphersuite) : E2eiEnrollment {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeE2eiEnrollment_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_new_activation_enrollment(
                                thisPtr,
                                FfiConverterString.lower(`displayName`),FfiConverterString.lower(`handle`),FfiConverterOptionalString.lower(`team`),FfiConverterUInt.lower(`expirySec`),FfiConverterTypeCiphersuite.lower(`ciphersuite`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiNewEnrollment`(`clientId`: String, `displayName`: String, `handle`: String, `team`: String?, `expirySec`: UInt, `ciphersuite`: Ciphersuite) : E2eiEnrollment {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeE2eiEnrollment_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_new_enrollment(
                                thisPtr,
                                FfiConverterString.lower(`clientId`),FfiConverterString.lower(`displayName`),FfiConverterString.lower(`handle`),FfiConverterOptionalString.lower(`team`),FfiConverterUInt.lower(`expirySec`),FfiConverterTypeCiphersuite.lower(`ciphersuite`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiNewRotateEnrollment`(`displayName`: String?, `handle`: String?, `team`: String?, `expirySec`: UInt, `ciphersuite`: Ciphersuite) : E2eiEnrollment {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeE2eiEnrollment_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_new_rotate_enrollment(
                                thisPtr,
                                FfiConverterOptionalString.lower(`displayName`),FfiConverterOptionalString.lower(`handle`),FfiConverterOptionalString.lower(`team`),FfiConverterUInt.lower(`expirySec`),FfiConverterTypeCiphersuite.lower(`ciphersuite`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiRegisterAcmeCa`(`trustAnchorPem`: String) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_register_acme_ca(
                                thisPtr,
                                FfiConverterString.lower(`trustAnchorPem`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiRegisterCrl`(`crlDp`: String, `crlDer`: ByteArray) : CrlRegistration {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeCrlRegistration_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_register_crl(
                                thisPtr,
                                FfiConverterString.lower(`crlDp`),FfiConverterByteArray.lower(`crlDer`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiRegisterIntermediateCa`(`certPem`: String) : List<String>? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalSequenceString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_register_intermediate_ca(
                                thisPtr,
                                FfiConverterString.lower(`certPem`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `e2eiRotateAll`(`enrollment`: E2eiEnrollment, `certificateChain`: String, `newKeyPackagesCount`: UInt) : RotateBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeRotateBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_e2ei_rotate_all(
                                thisPtr,
                                FfiConverterTypeE2eiEnrollment.lower(`enrollment`),FfiConverterString.lower(`certificateChain`),FfiConverterUInt.lower(`newKeyPackagesCount`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `encryptMessage`(`conversationId`: ByteArray, `message`: ByteArray) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_encrypt_message(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterByteArray.lower(`message`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `exportSecretKey`(`conversationId`: ByteArray, `keyLength`: UInt) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_export_secret_key(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterUInt.lower(`keyLength`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getClientIds`(`conversationId`: ByteArray) : List<ClientId> {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerSequenceTypeClientId_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_get_client_ids(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getCredentialInUse`(`groupInfo`: ByteArray, `credentialType`: MlsCredentialType) : E2eiConversationState {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeE2eiConversationState_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_get_credential_in_use(
                                thisPtr,
                                FfiConverterByteArray.lower(`groupInfo`),FfiConverterTypeMlsCredentialType.lower(`credentialType`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getDeviceIdentities`(`conversationId`: ByteArray, `deviceIds`: List<ClientId>) : List<WireIdentity> {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerSequenceTypeWireIdentity_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_get_device_identities(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterSequenceTypeClientId.lower(`deviceIds`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getExternalSender`(`conversationId`: ByteArray) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_get_external_sender(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getUserIdentities`(`conversationId`: ByteArray, `userIds`: List<String>) : Map<String, List<WireIdentity>> {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerMapStringSequenceTypeWireIdentity_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_get_user_identities(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterSequenceString.lower(`userIds`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `joinByExternalCommit`(`groupInfo`: ByteArray, `customConfiguration`: CustomConfiguration, `credentialType`: MlsCredentialType) : ConversationInitBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeConversationInitBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_join_by_external_commit(
                                thisPtr,
                                FfiConverterByteArray.lower(`groupInfo`),FfiConverterTypeCustomConfiguration.lower(`customConfiguration`),FfiConverterTypeMlsCredentialType.lower(`credentialType`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `markConversationAsChildOf`(`childId`: ByteArray, `parentId`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_mark_conversation_as_child_of(
                                thisPtr,
                                FfiConverterByteArray.lower(`childId`),FfiConverterByteArray.lower(`parentId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `mergePendingGroupFromExternalCommit`(`conversationId`: ByteArray) : List<BufferedDecryptedMessage>? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalSequenceTypeBufferedDecryptedMessage_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_merge_pending_group_from_external_commit(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `mlsGenerateKeypairs`(`ciphersuites`: Ciphersuites) : List<ClientId> {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerSequenceTypeClientId_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_mls_generate_keypairs(
                                thisPtr,
                                FfiConverterTypeCiphersuites.lower(`ciphersuites`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `mlsInit`(`clientId`: ClientId, `ciphersuites`: Ciphersuites, `nbKeyPackage`: UInt?) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_mls_init(
                                thisPtr,
                                FfiConverterTypeClientId.lower(`clientId`),FfiConverterTypeCiphersuites.lower(`ciphersuites`),FfiConverterOptionalUInt.lower(`nbKeyPackage`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `mlsInitWithClientId`(`clientId`: ClientId, `tmpClientIds`: List<ClientId>, `ciphersuites`: Ciphersuites) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_mls_init_with_client_id(
                                thisPtr,
                                FfiConverterTypeClientId.lower(`clientId`),FfiConverterSequenceTypeClientId.lower(`tmpClientIds`),FfiConverterTypeCiphersuites.lower(`ciphersuites`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newAddProposal`(`conversationId`: ByteArray, `keypackage`: ByteArray) : ProposalBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeProposalBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_new_add_proposal(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterByteArray.lower(`keypackage`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newExternalAddProposal`(`conversationId`: ByteArray, `epoch`: ULong, `ciphersuite`: Ciphersuite, `credentialType`: MlsCredentialType) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_new_external_add_proposal(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterULong.lower(`epoch`),FfiConverterTypeCiphersuite.lower(`ciphersuite`),FfiConverterTypeMlsCredentialType.lower(`credentialType`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newRemoveProposal`(`conversationId`: ByteArray, `clientId`: ClientId) : ProposalBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeProposalBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_new_remove_proposal(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterTypeClientId.lower(`clientId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newUpdateProposal`(`conversationId`: ByteArray) : ProposalBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeProposalBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_new_update_proposal(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `processWelcomeMessage`(`welcomeMessage`: ByteArray, `customConfiguration`: CustomConfiguration) : WelcomeBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeWelcomeBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_process_welcome_message(
                                thisPtr,
                                FfiConverterByteArray.lower(`welcomeMessage`),FfiConverterTypeCustomConfiguration.lower(`customConfiguration`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusCryptoboxMigrate`(`path`: String) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_cryptobox_migrate(
                                thisPtr,
                                FfiConverterString.lower(`path`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusDecrypt`(`sessionId`: String, `ciphertext`: ByteArray) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_decrypt(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),FfiConverterByteArray.lower(`ciphertext`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusEncrypt`(`sessionId`: String, `plaintext`: ByteArray) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_encrypt(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),FfiConverterByteArray.lower(`plaintext`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusEncryptBatched`(`sessions`: List<String>, `plaintext`: ByteArray) : Map<String, ByteArray> {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerMapStringByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_encrypt_batched(
                                thisPtr,
                                FfiConverterSequenceString.lower(`sessions`),FfiConverterByteArray.lower(`plaintext`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusFingerprint`() : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusFingerprintLocal`(`sessionId`: String) : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint_local(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)override fun `proteusFingerprintPrekeybundle`(`prekey`: ByteArray): String =
        callWithPointer {
    rustCallWithError(CoreCryptoException) { _status ->
    _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint_prekeybundle(it,
        FfiConverterByteArray.lower(`prekey`),
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusFingerprintRemote`(`sessionId`: String) : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_fingerprint_remote(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusInit`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_init(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `proteusLastErrorCode`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_last_error_code(it,
        
        _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusLastResortPrekey`() : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_last_resort_prekey(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)override fun `proteusLastResortPrekeyId`(): UShort =
        callWithPointer {
    rustCallWithError(CoreCryptoException) { _status ->
    _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_last_resort_prekey_id(it,
        
        _status)
}
        }.let {
            FfiConverterUShort.lift(it)
        }
    
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusNewPrekey`(`prekeyId`: UShort) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_new_prekey(
                                thisPtr,
                                FfiConverterUShort.lower(`prekeyId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusNewPrekeyAuto`() : ProteusAutoPrekeyBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeProteusAutoPrekeyBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_new_prekey_auto(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusSessionDelete`(`sessionId`: String) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_delete(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusSessionExists`(`sessionId`: String) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_exists(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusSessionFromMessage`(`sessionId`: String, `envelope`: ByteArray) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_from_message(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),FfiConverterByteArray.lower(`envelope`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusSessionFromPrekey`(`sessionId`: String, `prekey`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_from_prekey(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),FfiConverterByteArray.lower(`prekey`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `proteusSessionSave`(`sessionId`: String) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_proteus_session_save(
                                thisPtr,
                                FfiConverterString.lower(`sessionId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `randomBytes`(`len`: UInt) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_random_bytes(
                                thisPtr,
                                FfiConverterUInt.lower(`len`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `removeClientsFromConversation`(`conversationId`: ByteArray, `clients`: List<ClientId>) : CommitBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeCommitBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_remove_clients_from_conversation(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),FfiConverterSequenceTypeClientId.lower(`clients`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `reseedRng`(`seed`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_reseed_rng(
                                thisPtr,
                                FfiConverterByteArray.lower(`seed`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `restoreFromDisk`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_restore_from_disk(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setCallbacks`(`callbacks`: CoreCryptoCallbacks) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_set_callbacks(
                                thisPtr,
                                FfiConverterTypeCoreCryptoCallbacks.lower(`callbacks`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unload`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_unload(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `updateKeyingMaterial`(`conversationId`: ByteArray) : CommitBundle {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeCommitBundle_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_update_keying_material(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `wipe`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_wipe(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `wipeConversation`(`conversationId`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_corecrypto_wipe_conversation(
                                thisPtr,
                                FfiConverterByteArray.lower(`conversationId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    

    
}

public object FfiConverterTypeCoreCrypto: FfiConverter<CoreCrypto, Pointer> {
    override fun lower(value: CoreCrypto): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): CoreCrypto {
        return CoreCrypto(value)
    }

    override fun read(buf: ByteBuffer): CoreCrypto {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: CoreCrypto) = 8

    override fun write(value: CoreCrypto, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface E2eiEnrollmentInterface {
    @Throws(CoreCryptoException::class)
    suspend fun `certificateRequest`(`previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `checkOrderRequest`(`orderUrl`: String, `previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `checkOrderResponse`(`order`: ByteArray): String@Throws(CoreCryptoException::class)
    suspend fun `createDpopToken`(`expirySecs`: UInt, `backendNonce`: String): String@Throws(CoreCryptoException::class)
    suspend fun `directoryResponse`(`directory`: ByteArray): AcmeDirectory@Throws(CoreCryptoException::class)
    suspend fun `finalizeRequest`(`previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `finalizeResponse`(`finalize`: ByteArray): String@Throws(CoreCryptoException::class)
    suspend fun `getRefreshToken`(): String@Throws(CoreCryptoException::class)
    suspend fun `newAccountRequest`(`previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `newAccountResponse`(`account`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `newAuthzRequest`(`url`: String, `previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `newAuthzResponse`(`authz`: ByteArray): NewAcmeAuthz@Throws(CoreCryptoException::class)
    suspend fun `newDpopChallengeRequest`(`accessToken`: String, `previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `newDpopChallengeResponse`(`challenge`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `newOidcChallengeRequest`(`idToken`: String, `refreshToken`: String, `previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `newOidcChallengeResponse`(`cc`: CoreCrypto, `challenge`: ByteArray)@Throws(CoreCryptoException::class)
    suspend fun `newOrderRequest`(`previousNonce`: String): ByteArray@Throws(CoreCryptoException::class)
    suspend fun `newOrderResponse`(`order`: ByteArray): NewAcmeOrder
}

class E2eiEnrollment(
    pointer: Pointer
) : FFIObject(pointer), E2eiEnrollmentInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_free_e2eienrollment(this.pointer, status)
        }
    }

    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `certificateRequest`(`previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_certificate_request(
                                thisPtr,
                                FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `checkOrderRequest`(`orderUrl`: String, `previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_check_order_request(
                                thisPtr,
                                FfiConverterString.lower(`orderUrl`),FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `checkOrderResponse`(`order`: ByteArray) : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_check_order_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`order`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `createDpopToken`(`expirySecs`: UInt, `backendNonce`: String) : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_create_dpop_token(
                                thisPtr,
                                FfiConverterUInt.lower(`expirySecs`),FfiConverterString.lower(`backendNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `directoryResponse`(`directory`: ByteArray) : AcmeDirectory {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeAcmeDirectory_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_directory_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`directory`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `finalizeRequest`(`previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_finalize_request(
                                thisPtr,
                                FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `finalizeResponse`(`finalize`: ByteArray) : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_finalize_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`finalize`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRefreshToken`() : String {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_get_refresh_token(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newAccountRequest`(`previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_account_request(
                                thisPtr,
                                FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newAccountResponse`(`account`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_account_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`account`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newAuthzRequest`(`url`: String, `previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_authz_request(
                                thisPtr,
                                FfiConverterString.lower(`url`),FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newAuthzResponse`(`authz`: ByteArray) : NewAcmeAuthz {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeNewAcmeAuthz_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_authz_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`authz`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newDpopChallengeRequest`(`accessToken`: String, `previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_dpop_challenge_request(
                                thisPtr,
                                FfiConverterString.lower(`accessToken`),FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newDpopChallengeResponse`(`challenge`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_dpop_challenge_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`challenge`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newOidcChallengeRequest`(`idToken`: String, `refreshToken`: String, `previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_oidc_challenge_request(
                                thisPtr,
                                FfiConverterString.lower(`idToken`),FfiConverterString.lower(`refreshToken`),FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newOidcChallengeResponse`(`cc`: CoreCrypto, `challenge`: ByteArray) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_oidc_challenge_response(
                                thisPtr,
                                FfiConverterTypeCoreCrypto.lower(`cc`),FfiConverterByteArray.lower(`challenge`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newOrderRequest`(`previousNonce`: String) : ByteArray {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_order_request(
                                thisPtr,
                                FfiConverterString.lower(`previousNonce`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(CoreCryptoException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `newOrderResponse`(`order`: ByteArray) : NewAcmeOrder {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCancellableCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeNewAcmeOrder_TypeCoreCryptoError(continuation)
                    uniffiActiveFutureCallbacks.add(callback)
                    continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_method_e2eienrollment_new_order_response(
                                thisPtr,
                                FfiConverterByteArray.lower(`order`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    

    
}

public object FfiConverterTypeE2eiEnrollment: FfiConverter<E2eiEnrollment, Pointer> {
    override fun lower(value: E2eiEnrollment): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): E2eiEnrollment {
        return E2eiEnrollment(value)
    }

    override fun read(buf: ByteBuffer): E2eiEnrollment {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: E2eiEnrollment) = 8

    override fun write(value: E2eiEnrollment, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}







internal const val UNIFFI_RUST_TASK_CALLBACK_SUCCESS = 0.toByte()
internal const val UNIFFI_RUST_TASK_CALLBACK_CANCELLED = 1.toByte()
internal const val UNIFFI_FOREIGN_EXECUTOR_CALLBACK_SUCCESS = 0.toByte()
internal const val UNIFFI_FOREIGN_EXECUTOR_CALLBACK_CANCELLED = 1.toByte()
internal const val UNIFFI_FOREIGN_EXECUTOR_CALLBACK_ERROR = 2.toByte()

// Callback function to execute a Rust task.  The Kotlin code schedules these in a coroutine then
// invokes them.
internal interface UniFfiRustTaskCallback : com.sun.jna.Callback {
    fun callback(rustTaskData: Pointer?, statusCode: Byte)
}

internal object UniFfiForeignExecutorCallback : com.sun.jna.Callback {
    fun callback(handle: USize, delayMs: Int, rustTask: UniFfiRustTaskCallback?, rustTaskData: Pointer?) : Byte {
        if (rustTask == null) {
            FfiConverterForeignExecutor.drop(handle)
            return UNIFFI_FOREIGN_EXECUTOR_CALLBACK_SUCCESS
        } else {
            val coroutineScope = FfiConverterForeignExecutor.lift(handle)
            if (coroutineScope.isActive) {
                val job = coroutineScope.launch {
                    if (delayMs > 0) {
                        delay(delayMs.toLong())
                    }
                    rustTask.callback(rustTaskData, UNIFFI_RUST_TASK_CALLBACK_SUCCESS)
                }
                job.invokeOnCompletion { cause ->
                    if (cause != null) {
                        rustTask.callback(rustTaskData, UNIFFI_RUST_TASK_CALLBACK_CANCELLED)
                    }
                }
                return UNIFFI_FOREIGN_EXECUTOR_CALLBACK_SUCCESS
            } else {
                return UNIFFI_FOREIGN_EXECUTOR_CALLBACK_CANCELLED
            }
        }
    }
}

public object FfiConverterForeignExecutor: FfiConverter<CoroutineScope, USize> {
    internal val handleMap = UniFfiHandleMap<CoroutineScope>()

    internal fun drop(handle: USize) {
        handleMap.remove(handle)
    }

    internal fun register(lib: _UniFFILib) {
        lib.uniffi_foreign_executor_callback_set(UniFfiForeignExecutorCallback)
    }

    // Number of live handles, exposed so we can test the memory management
    public fun handleCount() : Int {
        return handleMap.size
    }

    override fun allocationSize(value: CoroutineScope) = USize.size

    override fun lift(value: USize): CoroutineScope {
        return handleMap.get(value) ?: throw RuntimeException("unknown handle in FfiConverterForeignExecutor.lift")
    }

    override fun read(buf: ByteBuffer): CoroutineScope {
        return lift(USize.readFromBuffer(buf))
    }

    override fun lower(value: CoroutineScope): USize {
        return handleMap.insert(value)
    }

    override fun write(value: CoroutineScope, buf: ByteBuffer) {
        lower(value).writeToBuffer(buf)
    }
}




data class AcmeChallenge (
    var `delegate`: ByteArray, 
    var `url`: String, 
    var `target`: String
) {
    
}

public object FfiConverterTypeAcmeChallenge: FfiConverterRustBuffer<AcmeChallenge> {
    override fun read(buf: ByteBuffer): AcmeChallenge {
        return AcmeChallenge(
            FfiConverterByteArray.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: AcmeChallenge) = (
            FfiConverterByteArray.allocationSize(value.`delegate`) +
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterString.allocationSize(value.`target`)
    )

    override fun write(value: AcmeChallenge, buf: ByteBuffer) {
            FfiConverterByteArray.write(value.`delegate`, buf)
            FfiConverterString.write(value.`url`, buf)
            FfiConverterString.write(value.`target`, buf)
    }
}




data class AcmeDirectory (
    var `newNonce`: String, 
    var `newAccount`: String, 
    var `newOrder`: String, 
    var `revokeCert`: String
) {
    
}

public object FfiConverterTypeAcmeDirectory: FfiConverterRustBuffer<AcmeDirectory> {
    override fun read(buf: ByteBuffer): AcmeDirectory {
        return AcmeDirectory(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: AcmeDirectory) = (
            FfiConverterString.allocationSize(value.`newNonce`) +
            FfiConverterString.allocationSize(value.`newAccount`) +
            FfiConverterString.allocationSize(value.`newOrder`) +
            FfiConverterString.allocationSize(value.`revokeCert`)
    )

    override fun write(value: AcmeDirectory, buf: ByteBuffer) {
            FfiConverterString.write(value.`newNonce`, buf)
            FfiConverterString.write(value.`newAccount`, buf)
            FfiConverterString.write(value.`newOrder`, buf)
            FfiConverterString.write(value.`revokeCert`, buf)
    }
}




data class BufferedDecryptedMessage (
    var `message`: ByteArray?, 
    var `proposals`: List<ProposalBundle>, 
    var `isActive`: Boolean, 
    var `commitDelay`: ULong?, 
    var `senderClientId`: ClientId?, 
    var `hasEpochChanged`: Boolean, 
    var `identity`: WireIdentity?, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeBufferedDecryptedMessage: FfiConverterRustBuffer<BufferedDecryptedMessage> {
    override fun read(buf: ByteBuffer): BufferedDecryptedMessage {
        return BufferedDecryptedMessage(
            FfiConverterOptionalByteArray.read(buf),
            FfiConverterSequenceTypeProposalBundle.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeClientId.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeWireIdentity.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: BufferedDecryptedMessage) = (
            FfiConverterOptionalByteArray.allocationSize(value.`message`) +
            FfiConverterSequenceTypeProposalBundle.allocationSize(value.`proposals`) +
            FfiConverterBoolean.allocationSize(value.`isActive`) +
            FfiConverterOptionalULong.allocationSize(value.`commitDelay`) +
            FfiConverterOptionalTypeClientId.allocationSize(value.`senderClientId`) +
            FfiConverterBoolean.allocationSize(value.`hasEpochChanged`) +
            FfiConverterOptionalTypeWireIdentity.allocationSize(value.`identity`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: BufferedDecryptedMessage, buf: ByteBuffer) {
            FfiConverterOptionalByteArray.write(value.`message`, buf)
            FfiConverterSequenceTypeProposalBundle.write(value.`proposals`, buf)
            FfiConverterBoolean.write(value.`isActive`, buf)
            FfiConverterOptionalULong.write(value.`commitDelay`, buf)
            FfiConverterOptionalTypeClientId.write(value.`senderClientId`, buf)
            FfiConverterBoolean.write(value.`hasEpochChanged`, buf)
            FfiConverterOptionalTypeWireIdentity.write(value.`identity`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class CommitBundle (
    var `welcome`: ByteArray?, 
    var `commit`: ByteArray, 
    var `groupInfo`: GroupInfoBundle
) {
    
}

public object FfiConverterTypeCommitBundle: FfiConverterRustBuffer<CommitBundle> {
    override fun read(buf: ByteBuffer): CommitBundle {
        return CommitBundle(
            FfiConverterOptionalByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterTypeGroupInfoBundle.read(buf),
        )
    }

    override fun allocationSize(value: CommitBundle) = (
            FfiConverterOptionalByteArray.allocationSize(value.`welcome`) +
            FfiConverterByteArray.allocationSize(value.`commit`) +
            FfiConverterTypeGroupInfoBundle.allocationSize(value.`groupInfo`)
    )

    override fun write(value: CommitBundle, buf: ByteBuffer) {
            FfiConverterOptionalByteArray.write(value.`welcome`, buf)
            FfiConverterByteArray.write(value.`commit`, buf)
            FfiConverterTypeGroupInfoBundle.write(value.`groupInfo`, buf)
    }
}




data class ConversationConfiguration (
    var `ciphersuite`: Ciphersuite, 
    var `externalSenders`: List<ByteArray>, 
    var `custom`: CustomConfiguration
) {
    
}

public object FfiConverterTypeConversationConfiguration: FfiConverterRustBuffer<ConversationConfiguration> {
    override fun read(buf: ByteBuffer): ConversationConfiguration {
        return ConversationConfiguration(
            FfiConverterTypeCiphersuite.read(buf),
            FfiConverterSequenceByteArray.read(buf),
            FfiConverterTypeCustomConfiguration.read(buf),
        )
    }

    override fun allocationSize(value: ConversationConfiguration) = (
            FfiConverterTypeCiphersuite.allocationSize(value.`ciphersuite`) +
            FfiConverterSequenceByteArray.allocationSize(value.`externalSenders`) +
            FfiConverterTypeCustomConfiguration.allocationSize(value.`custom`)
    )

    override fun write(value: ConversationConfiguration, buf: ByteBuffer) {
            FfiConverterTypeCiphersuite.write(value.`ciphersuite`, buf)
            FfiConverterSequenceByteArray.write(value.`externalSenders`, buf)
            FfiConverterTypeCustomConfiguration.write(value.`custom`, buf)
    }
}




data class ConversationInitBundle (
    var `conversationId`: ByteArray, 
    var `commit`: ByteArray, 
    var `groupInfo`: GroupInfoBundle, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeConversationInitBundle: FfiConverterRustBuffer<ConversationInitBundle> {
    override fun read(buf: ByteBuffer): ConversationInitBundle {
        return ConversationInitBundle(
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterTypeGroupInfoBundle.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: ConversationInitBundle) = (
            FfiConverterByteArray.allocationSize(value.`conversationId`) +
            FfiConverterByteArray.allocationSize(value.`commit`) +
            FfiConverterTypeGroupInfoBundle.allocationSize(value.`groupInfo`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: ConversationInitBundle, buf: ByteBuffer) {
            FfiConverterByteArray.write(value.`conversationId`, buf)
            FfiConverterByteArray.write(value.`commit`, buf)
            FfiConverterTypeGroupInfoBundle.write(value.`groupInfo`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class CrlRegistration (
    var `dirty`: Boolean, 
    var `expiration`: ULong?
) {
    
}

public object FfiConverterTypeCrlRegistration: FfiConverterRustBuffer<CrlRegistration> {
    override fun read(buf: ByteBuffer): CrlRegistration {
        return CrlRegistration(
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: CrlRegistration) = (
            FfiConverterBoolean.allocationSize(value.`dirty`) +
            FfiConverterOptionalULong.allocationSize(value.`expiration`)
    )

    override fun write(value: CrlRegistration, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`dirty`, buf)
            FfiConverterOptionalULong.write(value.`expiration`, buf)
    }
}




data class CustomConfiguration (
    var `keyRotationSpan`: java.time.Duration?, 
    var `wirePolicy`: MlsWirePolicy?
) {
    
}

public object FfiConverterTypeCustomConfiguration: FfiConverterRustBuffer<CustomConfiguration> {
    override fun read(buf: ByteBuffer): CustomConfiguration {
        return CustomConfiguration(
            FfiConverterOptionalDuration.read(buf),
            FfiConverterOptionalTypeMlsWirePolicy.read(buf),
        )
    }

    override fun allocationSize(value: CustomConfiguration) = (
            FfiConverterOptionalDuration.allocationSize(value.`keyRotationSpan`) +
            FfiConverterOptionalTypeMlsWirePolicy.allocationSize(value.`wirePolicy`)
    )

    override fun write(value: CustomConfiguration, buf: ByteBuffer) {
            FfiConverterOptionalDuration.write(value.`keyRotationSpan`, buf)
            FfiConverterOptionalTypeMlsWirePolicy.write(value.`wirePolicy`, buf)
    }
}




data class DecryptedMessage (
    var `message`: ByteArray?, 
    var `proposals`: List<ProposalBundle>, 
    var `isActive`: Boolean, 
    var `commitDelay`: ULong?, 
    var `senderClientId`: ClientId?, 
    var `hasEpochChanged`: Boolean, 
    var `identity`: WireIdentity?, 
    var `bufferedMessages`: List<BufferedDecryptedMessage>?, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeDecryptedMessage: FfiConverterRustBuffer<DecryptedMessage> {
    override fun read(buf: ByteBuffer): DecryptedMessage {
        return DecryptedMessage(
            FfiConverterOptionalByteArray.read(buf),
            FfiConverterSequenceTypeProposalBundle.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeClientId.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeWireIdentity.read(buf),
            FfiConverterOptionalSequenceTypeBufferedDecryptedMessage.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: DecryptedMessage) = (
            FfiConverterOptionalByteArray.allocationSize(value.`message`) +
            FfiConverterSequenceTypeProposalBundle.allocationSize(value.`proposals`) +
            FfiConverterBoolean.allocationSize(value.`isActive`) +
            FfiConverterOptionalULong.allocationSize(value.`commitDelay`) +
            FfiConverterOptionalTypeClientId.allocationSize(value.`senderClientId`) +
            FfiConverterBoolean.allocationSize(value.`hasEpochChanged`) +
            FfiConverterOptionalTypeWireIdentity.allocationSize(value.`identity`) +
            FfiConverterOptionalSequenceTypeBufferedDecryptedMessage.allocationSize(value.`bufferedMessages`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: DecryptedMessage, buf: ByteBuffer) {
            FfiConverterOptionalByteArray.write(value.`message`, buf)
            FfiConverterSequenceTypeProposalBundle.write(value.`proposals`, buf)
            FfiConverterBoolean.write(value.`isActive`, buf)
            FfiConverterOptionalULong.write(value.`commitDelay`, buf)
            FfiConverterOptionalTypeClientId.write(value.`senderClientId`, buf)
            FfiConverterBoolean.write(value.`hasEpochChanged`, buf)
            FfiConverterOptionalTypeWireIdentity.write(value.`identity`, buf)
            FfiConverterOptionalSequenceTypeBufferedDecryptedMessage.write(value.`bufferedMessages`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class E2eiDumpedPkiEnv (
    var `rootCa`: String, 
    var `intermediates`: List<String>, 
    var `crls`: List<String>
) {
    
}

public object FfiConverterTypeE2eiDumpedPkiEnv: FfiConverterRustBuffer<E2eiDumpedPkiEnv> {
    override fun read(buf: ByteBuffer): E2eiDumpedPkiEnv {
        return E2eiDumpedPkiEnv(
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: E2eiDumpedPkiEnv) = (
            FfiConverterString.allocationSize(value.`rootCa`) +
            FfiConverterSequenceString.allocationSize(value.`intermediates`) +
            FfiConverterSequenceString.allocationSize(value.`crls`)
    )

    override fun write(value: E2eiDumpedPkiEnv, buf: ByteBuffer) {
            FfiConverterString.write(value.`rootCa`, buf)
            FfiConverterSequenceString.write(value.`intermediates`, buf)
            FfiConverterSequenceString.write(value.`crls`, buf)
    }
}




data class GroupInfoBundle (
    var `encryptionType`: MlsGroupInfoEncryptionType, 
    var `ratchetTreeType`: MlsRatchetTreeType, 
    var `payload`: ByteArray
) {
    
}

public object FfiConverterTypeGroupInfoBundle: FfiConverterRustBuffer<GroupInfoBundle> {
    override fun read(buf: ByteBuffer): GroupInfoBundle {
        return GroupInfoBundle(
            FfiConverterTypeMlsGroupInfoEncryptionType.read(buf),
            FfiConverterTypeMlsRatchetTreeType.read(buf),
            FfiConverterByteArray.read(buf),
        )
    }

    override fun allocationSize(value: GroupInfoBundle) = (
            FfiConverterTypeMlsGroupInfoEncryptionType.allocationSize(value.`encryptionType`) +
            FfiConverterTypeMlsRatchetTreeType.allocationSize(value.`ratchetTreeType`) +
            FfiConverterByteArray.allocationSize(value.`payload`)
    )

    override fun write(value: GroupInfoBundle, buf: ByteBuffer) {
            FfiConverterTypeMlsGroupInfoEncryptionType.write(value.`encryptionType`, buf)
            FfiConverterTypeMlsRatchetTreeType.write(value.`ratchetTreeType`, buf)
            FfiConverterByteArray.write(value.`payload`, buf)
    }
}




data class MemberAddedMessages (
    var `welcome`: ByteArray, 
    var `commit`: ByteArray, 
    var `groupInfo`: GroupInfoBundle, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeMemberAddedMessages: FfiConverterRustBuffer<MemberAddedMessages> {
    override fun read(buf: ByteBuffer): MemberAddedMessages {
        return MemberAddedMessages(
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterTypeGroupInfoBundle.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: MemberAddedMessages) = (
            FfiConverterByteArray.allocationSize(value.`welcome`) +
            FfiConverterByteArray.allocationSize(value.`commit`) +
            FfiConverterTypeGroupInfoBundle.allocationSize(value.`groupInfo`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: MemberAddedMessages, buf: ByteBuffer) {
            FfiConverterByteArray.write(value.`welcome`, buf)
            FfiConverterByteArray.write(value.`commit`, buf)
            FfiConverterTypeGroupInfoBundle.write(value.`groupInfo`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class NewAcmeAuthz (
    var `identifier`: String, 
    var `keyauth`: String?, 
    var `challenge`: AcmeChallenge
) {
    
}

public object FfiConverterTypeNewAcmeAuthz: FfiConverterRustBuffer<NewAcmeAuthz> {
    override fun read(buf: ByteBuffer): NewAcmeAuthz {
        return NewAcmeAuthz(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeAcmeChallenge.read(buf),
        )
    }

    override fun allocationSize(value: NewAcmeAuthz) = (
            FfiConverterString.allocationSize(value.`identifier`) +
            FfiConverterOptionalString.allocationSize(value.`keyauth`) +
            FfiConverterTypeAcmeChallenge.allocationSize(value.`challenge`)
    )

    override fun write(value: NewAcmeAuthz, buf: ByteBuffer) {
            FfiConverterString.write(value.`identifier`, buf)
            FfiConverterOptionalString.write(value.`keyauth`, buf)
            FfiConverterTypeAcmeChallenge.write(value.`challenge`, buf)
    }
}




data class NewAcmeOrder (
    var `delegate`: ByteArray, 
    var `authorizations`: List<String>
) {
    
}

public object FfiConverterTypeNewAcmeOrder: FfiConverterRustBuffer<NewAcmeOrder> {
    override fun read(buf: ByteBuffer): NewAcmeOrder {
        return NewAcmeOrder(
            FfiConverterByteArray.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: NewAcmeOrder) = (
            FfiConverterByteArray.allocationSize(value.`delegate`) +
            FfiConverterSequenceString.allocationSize(value.`authorizations`)
    )

    override fun write(value: NewAcmeOrder, buf: ByteBuffer) {
            FfiConverterByteArray.write(value.`delegate`, buf)
            FfiConverterSequenceString.write(value.`authorizations`, buf)
    }
}




data class ProposalBundle (
    var `proposal`: ByteArray, 
    var `proposalRef`: ByteArray, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeProposalBundle: FfiConverterRustBuffer<ProposalBundle> {
    override fun read(buf: ByteBuffer): ProposalBundle {
        return ProposalBundle(
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: ProposalBundle) = (
            FfiConverterByteArray.allocationSize(value.`proposal`) +
            FfiConverterByteArray.allocationSize(value.`proposalRef`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: ProposalBundle, buf: ByteBuffer) {
            FfiConverterByteArray.write(value.`proposal`, buf)
            FfiConverterByteArray.write(value.`proposalRef`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class ProteusAutoPrekeyBundle (
    var `id`: UShort, 
    var `pkb`: ByteArray
) {
    
}

public object FfiConverterTypeProteusAutoPrekeyBundle: FfiConverterRustBuffer<ProteusAutoPrekeyBundle> {
    override fun read(buf: ByteBuffer): ProteusAutoPrekeyBundle {
        return ProteusAutoPrekeyBundle(
            FfiConverterUShort.read(buf),
            FfiConverterByteArray.read(buf),
        )
    }

    override fun allocationSize(value: ProteusAutoPrekeyBundle) = (
            FfiConverterUShort.allocationSize(value.`id`) +
            FfiConverterByteArray.allocationSize(value.`pkb`)
    )

    override fun write(value: ProteusAutoPrekeyBundle, buf: ByteBuffer) {
            FfiConverterUShort.write(value.`id`, buf)
            FfiConverterByteArray.write(value.`pkb`, buf)
    }
}




data class RotateBundle (
    var `commits`: Map<String, CommitBundle>, 
    var `newKeyPackages`: List<ByteArray>, 
    var `keyPackageRefsToRemove`: List<ByteArray>, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeRotateBundle: FfiConverterRustBuffer<RotateBundle> {
    override fun read(buf: ByteBuffer): RotateBundle {
        return RotateBundle(
            FfiConverterMapStringTypeCommitBundle.read(buf),
            FfiConverterSequenceByteArray.read(buf),
            FfiConverterSequenceByteArray.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: RotateBundle) = (
            FfiConverterMapStringTypeCommitBundle.allocationSize(value.`commits`) +
            FfiConverterSequenceByteArray.allocationSize(value.`newKeyPackages`) +
            FfiConverterSequenceByteArray.allocationSize(value.`keyPackageRefsToRemove`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: RotateBundle, buf: ByteBuffer) {
            FfiConverterMapStringTypeCommitBundle.write(value.`commits`, buf)
            FfiConverterSequenceByteArray.write(value.`newKeyPackages`, buf)
            FfiConverterSequenceByteArray.write(value.`keyPackageRefsToRemove`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class WelcomeBundle (
    var `id`: ByteArray, 
    var `crlNewDistributionPoints`: List<String>?
) {
    
}

public object FfiConverterTypeWelcomeBundle: FfiConverterRustBuffer<WelcomeBundle> {
    override fun read(buf: ByteBuffer): WelcomeBundle {
        return WelcomeBundle(
            FfiConverterByteArray.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: WelcomeBundle) = (
            FfiConverterByteArray.allocationSize(value.`id`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`crlNewDistributionPoints`)
    )

    override fun write(value: WelcomeBundle, buf: ByteBuffer) {
            FfiConverterByteArray.write(value.`id`, buf)
            FfiConverterOptionalSequenceString.write(value.`crlNewDistributionPoints`, buf)
    }
}




data class WireIdentity (
    var `clientId`: String, 
    var `handle`: String, 
    var `displayName`: String, 
    var `domain`: String, 
    var `certificate`: String, 
    var `status`: DeviceStatus, 
    var `thumbprint`: String, 
    var `serialNumber`: String, 
    var `notBefore`: ULong, 
    var `notAfter`: ULong
) {
    
}

public object FfiConverterTypeWireIdentity: FfiConverterRustBuffer<WireIdentity> {
    override fun read(buf: ByteBuffer): WireIdentity {
        return WireIdentity(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeDeviceStatus.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: WireIdentity) = (
            FfiConverterString.allocationSize(value.`clientId`) +
            FfiConverterString.allocationSize(value.`handle`) +
            FfiConverterString.allocationSize(value.`displayName`) +
            FfiConverterString.allocationSize(value.`domain`) +
            FfiConverterString.allocationSize(value.`certificate`) +
            FfiConverterTypeDeviceStatus.allocationSize(value.`status`) +
            FfiConverterString.allocationSize(value.`thumbprint`) +
            FfiConverterString.allocationSize(value.`serialNumber`) +
            FfiConverterULong.allocationSize(value.`notBefore`) +
            FfiConverterULong.allocationSize(value.`notAfter`)
    )

    override fun write(value: WireIdentity, buf: ByteBuffer) {
            FfiConverterString.write(value.`clientId`, buf)
            FfiConverterString.write(value.`handle`, buf)
            FfiConverterString.write(value.`displayName`, buf)
            FfiConverterString.write(value.`domain`, buf)
            FfiConverterString.write(value.`certificate`, buf)
            FfiConverterTypeDeviceStatus.write(value.`status`, buf)
            FfiConverterString.write(value.`thumbprint`, buf)
            FfiConverterString.write(value.`serialNumber`, buf)
            FfiConverterULong.write(value.`notBefore`, buf)
            FfiConverterULong.write(value.`notAfter`, buf)
    }
}




enum class CiphersuiteName {
    MLS_128_DHKEMX25519_AES128GCM_SHA256_ED25519,MLS_128_DHKEMP256_AES128GCM_SHA256_P256,MLS_128_DHKEMX25519_CHACHA20POLY1305_SHA256_ED25519,MLS_256_DHKEMX448_AES256GCM_SHA512_ED448,MLS_256_DHKEMP521_AES256GCM_SHA512_P521,MLS_256_DHKEMX448_CHACHA20POLY1305_SHA512_ED448,MLS_256_DHKEMP384_AES256GCM_SHA384_P384,MLS_128_X25519KYBER768DRAFT00_AES128GCM_SHA256_ED25519;
}

public object FfiConverterTypeCiphersuiteName: FfiConverterRustBuffer<CiphersuiteName> {
    override fun read(buf: ByteBuffer) = try {
        CiphersuiteName.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: CiphersuiteName) = 4

    override fun write(value: CiphersuiteName, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class CoreCryptoException: Exception() {
    // Each variant is a nested class
    
    class CryptoException(
        val `error`: CryptoError
        ) : CoreCryptoException() {
        override val message
            get() = "error=${ `error` }"
    }
    
    class E2eIdentityException(
        val `error`: E2eIdentityError
        ) : CoreCryptoException() {
        override val message
            get() = "error=${ `error` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<CoreCryptoException> {
        override fun lift(error_buf: RustBuffer.ByValue): CoreCryptoException = FfiConverterTypeCoreCryptoError.lift(error_buf)
    }

    
}

public object FfiConverterTypeCoreCryptoError : FfiConverterRustBuffer<CoreCryptoException> {
    override fun read(buf: ByteBuffer): CoreCryptoException {
        

        return when(buf.getInt()) {
            1 -> CoreCryptoException.CryptoException(
                FfiConverterTypeCryptoError.read(buf),
                )
            2 -> CoreCryptoException.E2eIdentityException(
                FfiConverterTypeE2eIdentityError.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: CoreCryptoException): Int {
        return when(value) {
            is CoreCryptoException.CryptoException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterTypeCryptoError.allocationSize(value.`error`)
            )
            is CoreCryptoException.E2eIdentityException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterTypeE2eIdentityError.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: CoreCryptoException, buf: ByteBuffer) {
        when(value) {
            is CoreCryptoException.CryptoException -> {
                buf.putInt(1)
                FfiConverterTypeCryptoError.write(value.`error`, buf)
                Unit
            }
            is CoreCryptoException.E2eIdentityException -> {
                buf.putInt(2)
                FfiConverterTypeE2eIdentityError.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class DeviceStatus {
    VALID,EXPIRED,REVOKED;
}

public object FfiConverterTypeDeviceStatus: FfiConverterRustBuffer<DeviceStatus> {
    override fun read(buf: ByteBuffer) = try {
        DeviceStatus.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: DeviceStatus) = 4

    override fun write(value: DeviceStatus, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class E2eiConversationState {
    VERIFIED,NOT_VERIFIED,NOT_ENABLED;
}

public object FfiConverterTypeE2eiConversationState: FfiConverterRustBuffer<E2eiConversationState> {
    override fun read(buf: ByteBuffer) = try {
        E2eiConversationState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: E2eiConversationState) = 4

    override fun write(value: E2eiConversationState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MlsCredentialType {
    BASIC,X509;
}

public object FfiConverterTypeMlsCredentialType: FfiConverterRustBuffer<MlsCredentialType> {
    override fun read(buf: ByteBuffer) = try {
        MlsCredentialType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MlsCredentialType) = 4

    override fun write(value: MlsCredentialType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MlsGroupInfoEncryptionType {
    PLAINTEXT,JWE_ENCRYPTED;
}

public object FfiConverterTypeMlsGroupInfoEncryptionType: FfiConverterRustBuffer<MlsGroupInfoEncryptionType> {
    override fun read(buf: ByteBuffer) = try {
        MlsGroupInfoEncryptionType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MlsGroupInfoEncryptionType) = 4

    override fun write(value: MlsGroupInfoEncryptionType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MlsRatchetTreeType {
    FULL,DELTA,BY_REF;
}

public object FfiConverterTypeMlsRatchetTreeType: FfiConverterRustBuffer<MlsRatchetTreeType> {
    override fun read(buf: ByteBuffer) = try {
        MlsRatchetTreeType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MlsRatchetTreeType) = 4

    override fun write(value: MlsRatchetTreeType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MlsWirePolicy {
    PLAINTEXT,CIPHERTEXT;
}

public object FfiConverterTypeMlsWirePolicy: FfiConverterRustBuffer<MlsWirePolicy> {
    override fun read(buf: ByteBuffer) = try {
        MlsWirePolicy.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MlsWirePolicy) = 4

    override fun write(value: MlsWirePolicy, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






internal typealias Handle = Long
internal class ConcurrentHandleMap<T>(
    private val leftMap: MutableMap<Handle, T> = mutableMapOf(),
    private val rightMap: MutableMap<T, Handle> = mutableMapOf()
) {
    private val lock = java.util.concurrent.locks.ReentrantLock()
    private val currentHandle = AtomicLong(0L)
    private val stride = 1L

    fun insert(obj: T): Handle =
        lock.withLock {
            rightMap[obj] ?:
                currentHandle.getAndAdd(stride)
                    .also { handle ->
                        leftMap[handle] = obj
                        rightMap[obj] = handle
                    }
            }

    fun get(handle: Handle) = lock.withLock {
        leftMap[handle]
    }

    fun delete(handle: Handle) {
        this.remove(handle)
    }

    fun remove(handle: Handle): T? =
        lock.withLock {
            leftMap.remove(handle)?.let { obj ->
                rightMap.remove(obj)
                obj
            }
        }
}

interface ForeignCallback : com.sun.jna.Callback {
    public fun callback(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface>(
    protected val foreignCallback: ForeignCallback
): FfiConverter<CallbackInterface, Handle> {
    private val handleMap = ConcurrentHandleMap<CallbackInterface>()

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal abstract fun register(lib: _UniFFILib)

    fun drop(handle: Handle): RustBuffer.ByValue {
        return handleMap.remove(handle).let { RustBuffer.ByValue() }
    }

    override fun lift(value: Handle): CallbackInterface {
        return handleMap.get(value) ?: throw InternalException("No callback in handlemap; this is a Uniffi bug")
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) =
        handleMap.insert(value).also {
            assert(handleMap.get(it) === value) { "Handle map is not returning the object we just placed there. This is a bug in the HandleMap." }
        }

    override fun allocationSize(value: CallbackInterface) = 8

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Declaration and FfiConverters for CoreCryptoCallbacks Callback Interface

public interface CoreCryptoCallbacks {
    fun `authorize`(`conversationId`: ByteArray, `clientId`: ClientId): Boolean
    fun `userAuthorize`(`conversationId`: ByteArray, `externalClientId`: ClientId, `existingClients`: List<ClientId>): Boolean
    fun `clientIsExistingGroupUser`(`conversationId`: ByteArray, `clientId`: ClientId, `existingClients`: List<ClientId>, `parentConversationClients`: List<ClientId>?): Boolean
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeCoreCryptoCallbacks : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun callback(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeCoreCryptoCallbacks.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeCoreCryptoCallbacks.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeAuthorize`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeUserAuthorize`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            3 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeClientIsExistingGroupUser`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeAuthorize`(kotlinCallbackInterface: CoreCryptoCallbacks, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            val returnValue = kotlinCallbackInterface.`authorize`(
                FfiConverterByteArray.read(argsBuf)
                , 
                FfiConverterTypeClientId.read(argsBuf)
                
            )
            outBuf.setValue(FfiConverterBoolean.lowerIntoRustBuffer(returnValue))
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeUserAuthorize`(kotlinCallbackInterface: CoreCryptoCallbacks, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            val returnValue = kotlinCallbackInterface.`userAuthorize`(
                FfiConverterByteArray.read(argsBuf)
                , 
                FfiConverterTypeClientId.read(argsBuf)
                , 
                FfiConverterSequenceTypeClientId.read(argsBuf)
                
            )
            outBuf.setValue(FfiConverterBoolean.lowerIntoRustBuffer(returnValue))
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeClientIsExistingGroupUser`(kotlinCallbackInterface: CoreCryptoCallbacks, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            val returnValue = kotlinCallbackInterface.`clientIsExistingGroupUser`(
                FfiConverterByteArray.read(argsBuf)
                , 
                FfiConverterTypeClientId.read(argsBuf)
                , 
                FfiConverterSequenceTypeClientId.read(argsBuf)
                , 
                FfiConverterOptionalSequenceTypeClientId.read(argsBuf)
                
            )
            outBuf.setValue(FfiConverterBoolean.lowerIntoRustBuffer(returnValue))
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeCoreCryptoCallbacks: FfiConverterCallbackInterface<CoreCryptoCallbacks>(
    foreignCallback = ForeignCallbackTypeCoreCryptoCallbacks()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_core_crypto_ffi_fn_init_callback_corecryptocallbacks(this.foreignCallback, status)
        }
    }
}




public object FfiConverterOptionalUInt: FfiConverterRustBuffer<UInt?> {
    override fun read(buf: ByteBuffer): UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: UInt?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalULong: FfiConverterRustBuffer<ULong?> {
    override fun read(buf: ByteBuffer): ULong? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterULong.read(buf)
    }

    override fun allocationSize(value: ULong?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterULong.allocationSize(value)
        }
    }

    override fun write(value: ULong?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterULong.write(value, buf)
        }
    }
}




public object FfiConverterOptionalString: FfiConverterRustBuffer<String?> {
    override fun read(buf: ByteBuffer): String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: String?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalByteArray: FfiConverterRustBuffer<ByteArray?> {
    override fun read(buf: ByteBuffer): ByteArray? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterByteArray.read(buf)
    }

    override fun allocationSize(value: ByteArray?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterByteArray.allocationSize(value)
        }
    }

    override fun write(value: ByteArray?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterByteArray.write(value, buf)
        }
    }
}




public object FfiConverterOptionalDuration: FfiConverterRustBuffer<java.time.Duration?> {
    override fun read(buf: ByteBuffer): java.time.Duration? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterDuration.read(buf)
    }

    override fun allocationSize(value: java.time.Duration?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterDuration.allocationSize(value)
        }
    }

    override fun write(value: java.time.Duration?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterDuration.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeCommitBundle: FfiConverterRustBuffer<CommitBundle?> {
    override fun read(buf: ByteBuffer): CommitBundle? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeCommitBundle.read(buf)
    }

    override fun allocationSize(value: CommitBundle?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeCommitBundle.allocationSize(value)
        }
    }

    override fun write(value: CommitBundle?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeCommitBundle.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeE2eiDumpedPkiEnv: FfiConverterRustBuffer<E2eiDumpedPkiEnv?> {
    override fun read(buf: ByteBuffer): E2eiDumpedPkiEnv? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeE2eiDumpedPkiEnv.read(buf)
    }

    override fun allocationSize(value: E2eiDumpedPkiEnv?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeE2eiDumpedPkiEnv.allocationSize(value)
        }
    }

    override fun write(value: E2eiDumpedPkiEnv?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeE2eiDumpedPkiEnv.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeWireIdentity: FfiConverterRustBuffer<WireIdentity?> {
    override fun read(buf: ByteBuffer): WireIdentity? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeWireIdentity.read(buf)
    }

    override fun allocationSize(value: WireIdentity?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeWireIdentity.allocationSize(value)
        }
    }

    override fun write(value: WireIdentity?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeWireIdentity.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMlsWirePolicy: FfiConverterRustBuffer<MlsWirePolicy?> {
    override fun read(buf: ByteBuffer): MlsWirePolicy? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMlsWirePolicy.read(buf)
    }

    override fun allocationSize(value: MlsWirePolicy?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMlsWirePolicy.allocationSize(value)
        }
    }

    override fun write(value: MlsWirePolicy?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMlsWirePolicy.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<String>?> {
    override fun read(buf: ByteBuffer): List<String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<String>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeBufferedDecryptedMessage: FfiConverterRustBuffer<List<BufferedDecryptedMessage>?> {
    override fun read(buf: ByteBuffer): List<BufferedDecryptedMessage>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeBufferedDecryptedMessage.read(buf)
    }

    override fun allocationSize(value: List<BufferedDecryptedMessage>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeBufferedDecryptedMessage.allocationSize(value)
        }
    }

    override fun write(value: List<BufferedDecryptedMessage>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeBufferedDecryptedMessage.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeClientId: FfiConverterRustBuffer<List<ClientId>?> {
    override fun read(buf: ByteBuffer): List<ClientId>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeClientId.read(buf)
    }

    override fun allocationSize(value: List<ClientId>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeClientId.allocationSize(value)
        }
    }

    override fun write(value: List<ClientId>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeClientId.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeClientId: FfiConverterRustBuffer<ClientId?> {
    override fun read(buf: ByteBuffer): ClientId? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeClientId.read(buf)
    }

    override fun allocationSize(value: ClientId?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeClientId.allocationSize(value)
        }
    }

    override fun write(value: ClientId?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeClientId.write(value, buf)
        }
    }
}




public object FfiConverterSequenceUShort: FfiConverterRustBuffer<List<UShort>> {
    override fun read(buf: ByteBuffer): List<UShort> {
        val len = buf.getInt()
        return List<UShort>(len) {
            FfiConverterUShort.read(buf)
        }
    }

    override fun allocationSize(value: List<UShort>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterUShort.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UShort>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterUShort.write(it, buf)
        }
    }
}




public object FfiConverterSequenceString: FfiConverterRustBuffer<List<String>> {
    override fun read(buf: ByteBuffer): List<String> {
        val len = buf.getInt()
        return List<String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<String>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




public object FfiConverterSequenceByteArray: FfiConverterRustBuffer<List<ByteArray>> {
    override fun read(buf: ByteBuffer): List<ByteArray> {
        val len = buf.getInt()
        return List<ByteArray>(len) {
            FfiConverterByteArray.read(buf)
        }
    }

    override fun allocationSize(value: List<ByteArray>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterByteArray.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ByteArray>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterByteArray.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeBufferedDecryptedMessage: FfiConverterRustBuffer<List<BufferedDecryptedMessage>> {
    override fun read(buf: ByteBuffer): List<BufferedDecryptedMessage> {
        val len = buf.getInt()
        return List<BufferedDecryptedMessage>(len) {
            FfiConverterTypeBufferedDecryptedMessage.read(buf)
        }
    }

    override fun allocationSize(value: List<BufferedDecryptedMessage>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeBufferedDecryptedMessage.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<BufferedDecryptedMessage>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeBufferedDecryptedMessage.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeProposalBundle: FfiConverterRustBuffer<List<ProposalBundle>> {
    override fun read(buf: ByteBuffer): List<ProposalBundle> {
        val len = buf.getInt()
        return List<ProposalBundle>(len) {
            FfiConverterTypeProposalBundle.read(buf)
        }
    }

    override fun allocationSize(value: List<ProposalBundle>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeProposalBundle.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ProposalBundle>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeProposalBundle.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeWireIdentity: FfiConverterRustBuffer<List<WireIdentity>> {
    override fun read(buf: ByteBuffer): List<WireIdentity> {
        val len = buf.getInt()
        return List<WireIdentity>(len) {
            FfiConverterTypeWireIdentity.read(buf)
        }
    }

    override fun allocationSize(value: List<WireIdentity>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeWireIdentity.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<WireIdentity>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeWireIdentity.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeClientId: FfiConverterRustBuffer<List<ClientId>> {
    override fun read(buf: ByteBuffer): List<ClientId> {
        val len = buf.getInt()
        return List<ClientId>(len) {
            FfiConverterTypeClientId.read(buf)
        }
    }

    override fun allocationSize(value: List<ClientId>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeClientId.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ClientId>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeClientId.write(it, buf)
        }
    }
}



public object FfiConverterMapStringByteArray: FfiConverterRustBuffer<Map<String, ByteArray>> {
    override fun read(buf: ByteBuffer): Map<String, ByteArray> {
        // TODO: Once Kotlin's `buildMap` API is stabilized we should use it here.
        val items : MutableMap<String, ByteArray> = mutableMapOf()
        val len = buf.getInt()
        repeat(len) {
            val k = FfiConverterString.read(buf)
            val v = FfiConverterByteArray.read(buf)
            items[k] = v
        }
        return items
    }

    override fun allocationSize(value: Map<String, ByteArray>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterByteArray.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, ByteArray>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterByteArray.write(v, buf)
        }
    }
}



public object FfiConverterMapStringTypeCommitBundle: FfiConverterRustBuffer<Map<String, CommitBundle>> {
    override fun read(buf: ByteBuffer): Map<String, CommitBundle> {
        // TODO: Once Kotlin's `buildMap` API is stabilized we should use it here.
        val items : MutableMap<String, CommitBundle> = mutableMapOf()
        val len = buf.getInt()
        repeat(len) {
            val k = FfiConverterString.read(buf)
            val v = FfiConverterTypeCommitBundle.read(buf)
            items[k] = v
        }
        return items
    }

    override fun allocationSize(value: Map<String, CommitBundle>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterTypeCommitBundle.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, CommitBundle>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterTypeCommitBundle.write(v, buf)
        }
    }
}



public object FfiConverterMapStringSequenceTypeWireIdentity: FfiConverterRustBuffer<Map<String, List<WireIdentity>>> {
    override fun read(buf: ByteBuffer): Map<String, List<WireIdentity>> {
        // TODO: Once Kotlin's `buildMap` API is stabilized we should use it here.
        val items : MutableMap<String, List<WireIdentity>> = mutableMapOf()
        val len = buf.getInt()
        repeat(len) {
            val k = FfiConverterString.read(buf)
            val v = FfiConverterSequenceTypeWireIdentity.read(buf)
            items[k] = v
        }
        return items
    }

    override fun allocationSize(value: Map<String, List<WireIdentity>>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterSequenceTypeWireIdentity.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, List<WireIdentity>>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterSequenceTypeWireIdentity.write(v, buf)
        }
    }
}











/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias Ciphersuite = UShort
public typealias FfiConverterTypeCiphersuite = FfiConverterUShort



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias Ciphersuites = List<UShort>
public typealias FfiConverterTypeCiphersuites = FfiConverterSequenceUShort



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias ClientId = ByteArray
public typealias FfiConverterTypeClientId = FfiConverterByteArray
// Async return type handlers










// Stores all active future callbacks to ensure they're not GC'ed while waiting for the Rust code to
// complete the callback
val uniffiActiveFutureCallbacks = mutableSetOf<Any>()

// FFI type for callback handlers
internal interface UniFfiFutureCallbackByte : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun callback(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackShort : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun callback(_callbackData: USize, returnValue: Short?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackInt : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun callback(_callbackData: USize, returnValue: Int?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackLong : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun callback(_callbackData: USize, returnValue: Long?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackPointer : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun callback(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackRustBuffer : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue);
}

// Callback handlers for an async call.  These are invoked by Rust when the future is ready.  They
// lift the return value or error and resume the suspended function.

internal class UniFfiFutureCallbackHandlerVoid_TypeCoreCryptoError(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun callback(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerUShort_TypeCoreCryptoError(val continuation: Continuation<UShort>)
    : UniFfiFutureCallbackShort {
    override fun callback(_callbackData: USize, returnValue: Short?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterUShort.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerUInt(val continuation: Continuation<UInt>)
    : UniFfiFutureCallbackInt {
    override fun callback(_callbackData: USize, returnValue: Int?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterUInt.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerULong_TypeCoreCryptoError(val continuation: Continuation<ULong>)
    : UniFfiFutureCallbackLong {
    override fun callback(_callbackData: USize, returnValue: Long?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterULong.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerBoolean(val continuation: Continuation<Boolean>)
    : UniFfiFutureCallbackByte {
    override fun callback(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterBoolean.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerBoolean_TypeCoreCryptoError(val continuation: Continuation<Boolean>)
    : UniFfiFutureCallbackByte {
    override fun callback(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterBoolean.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerString(val continuation: Continuation<String>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerString_TypeCoreCryptoError(val continuation: Continuation<String>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerByteArray_TypeCoreCryptoError(val continuation: Continuation<ByteArray>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterByteArray.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeCoreCrypto_TypeCoreCryptoError(val continuation: Continuation<CoreCrypto>)
    : UniFfiFutureCallbackPointer {
    override fun callback(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeCoreCrypto.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeE2eiEnrollment_TypeCoreCryptoError(val continuation: Continuation<E2eiEnrollment>)
    : UniFfiFutureCallbackPointer {
    override fun callback(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeE2eiEnrollment.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeAcmeDirectory_TypeCoreCryptoError(val continuation: Continuation<AcmeDirectory>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeAcmeDirectory.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeCommitBundle_TypeCoreCryptoError(val continuation: Continuation<CommitBundle>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeCommitBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeConversationInitBundle_TypeCoreCryptoError(val continuation: Continuation<ConversationInitBundle>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeConversationInitBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeCrlRegistration_TypeCoreCryptoError(val continuation: Continuation<CrlRegistration>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeCrlRegistration.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeDecryptedMessage_TypeCoreCryptoError(val continuation: Continuation<DecryptedMessage>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeDecryptedMessage.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeMemberAddedMessages_TypeCoreCryptoError(val continuation: Continuation<MemberAddedMessages>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeMemberAddedMessages.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeNewAcmeAuthz_TypeCoreCryptoError(val continuation: Continuation<NewAcmeAuthz>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeNewAcmeAuthz.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeNewAcmeOrder_TypeCoreCryptoError(val continuation: Continuation<NewAcmeOrder>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeNewAcmeOrder.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeProposalBundle_TypeCoreCryptoError(val continuation: Continuation<ProposalBundle>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeProposalBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeProteusAutoPrekeyBundle_TypeCoreCryptoError(val continuation: Continuation<ProteusAutoPrekeyBundle>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeProteusAutoPrekeyBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRotateBundle_TypeCoreCryptoError(val continuation: Continuation<RotateBundle>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeRotateBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeWelcomeBundle_TypeCoreCryptoError(val continuation: Continuation<WelcomeBundle>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeWelcomeBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeE2eiConversationState_TypeCoreCryptoError(val continuation: Continuation<E2eiConversationState>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterTypeE2eiConversationState.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeCommitBundle_TypeCoreCryptoError(val continuation: Continuation<CommitBundle?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterOptionalTypeCommitBundle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeE2eiDumpedPkiEnv_TypeCoreCryptoError(val continuation: Continuation<E2eiDumpedPkiEnv?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterOptionalTypeE2eiDumpedPkiEnv.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalSequenceString_TypeCoreCryptoError(val continuation: Continuation<List<String>?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterOptionalSequenceString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalSequenceTypeBufferedDecryptedMessage_TypeCoreCryptoError(val continuation: Continuation<List<BufferedDecryptedMessage>?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterOptionalSequenceTypeBufferedDecryptedMessage.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceByteArray_TypeCoreCryptoError(val continuation: Continuation<List<ByteArray>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterSequenceByteArray.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceTypeWireIdentity_TypeCoreCryptoError(val continuation: Continuation<List<WireIdentity>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterSequenceTypeWireIdentity.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceTypeClientId_TypeCoreCryptoError(val continuation: Continuation<List<ClientId>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterSequenceTypeClientId.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerMapStringByteArray_TypeCoreCryptoError(val continuation: Continuation<Map<String, ByteArray>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterMapStringByteArray.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerMapStringSequenceTypeWireIdentity_TypeCoreCryptoError(val continuation: Continuation<Map<String, List<WireIdentity>>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun callback(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        uniffiActiveFutureCallbacks.remove(this)
        try {
            checkCallStatus(CoreCryptoException, callStatus)
            continuation.resume(FfiConverterMapStringSequenceTypeWireIdentity.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}
@Throws(CoreCryptoException::class)

@Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
suspend fun `coreCryptoDeferredInit`(`path`: String, `key`: String, `ciphersuites`: Ciphersuites, `nbKeyPackage`: UInt?) : CoreCrypto {
    // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
    // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
    return coroutineScope {
        val scope = this
        return@coroutineScope suspendCancellableCoroutine { continuation ->
            try {
                val callback = UniFfiFutureCallbackHandlerTypeCoreCrypto_TypeCoreCryptoError(continuation)
                uniffiActiveFutureCallbacks.add(callback)
                continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                rustCall { status ->
                    _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_func_core_crypto_deferred_init(
                        FfiConverterString.lower(`path`),FfiConverterString.lower(`key`),FfiConverterTypeCiphersuites.lower(`ciphersuites`),FfiConverterOptionalUInt.lower(`nbKeyPackage`),
                        FfiConverterForeignExecutor.lower(scope),
                        callback,
                        USize(0),
                        status,
                    )
                }
            } catch (e: Exception) {
                continuation.resumeWithException(e)
            }
        }
    }
}
@Throws(CoreCryptoException::class)

@Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
suspend fun `coreCryptoNew`(`path`: String, `key`: String, `clientId`: ClientId, `ciphersuites`: Ciphersuites, `nbKeyPackage`: UInt?) : CoreCrypto {
    // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
    // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
    return coroutineScope {
        val scope = this
        return@coroutineScope suspendCancellableCoroutine { continuation ->
            try {
                val callback = UniFfiFutureCallbackHandlerTypeCoreCrypto_TypeCoreCryptoError(continuation)
                uniffiActiveFutureCallbacks.add(callback)
                continuation.invokeOnCancellation { uniffiActiveFutureCallbacks.remove(callback) }
                rustCall { status ->
                    _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_func_core_crypto_new(
                        FfiConverterString.lower(`path`),FfiConverterString.lower(`key`),FfiConverterTypeClientId.lower(`clientId`),FfiConverterTypeCiphersuites.lower(`ciphersuites`),FfiConverterOptionalUInt.lower(`nbKeyPackage`),
                        FfiConverterForeignExecutor.lower(scope),
                        callback,
                        USize(0),
                        status,
                    )
                }
            } catch (e: Exception) {
                continuation.resumeWithException(e)
            }
        }
    }
}

fun `version`(): String {
    return FfiConverterString.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_core_crypto_ffi_fn_func_version(_status)
})
}


