// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package uniffi.core_crypto;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.ConcurrentHashMap

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    @JvmField var capacity: Int = 0
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

    companion object {
        internal fun alloc(size: Int = 0) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_core_crypto_rustbuffer_alloc(size, status).also {
                if(it.data == null) {
                   throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
               }
            }
        }

        internal fun free(buf: RustBuffer.ByValue) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_core_crypto_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getInt(0))
        value.writeField("len", pointer.getInt(4))
        value.writeField("data", pointer.getPointer(8))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
@Structure.FieldOrder("code", "error_buf")
internal open class RustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: RustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == 0.toByte()
    }

    fun isError(): Boolean {
        return code == 1.toByte()
    }

    fun isPanic(): Boolean {
        return code == 2.toByte()
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface CallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> rustCallWithError(errorHandler: CallStatusErrorHandler<E>, callback: (RustCallStatus) -> U): U {
    var status = RustCallStatus();
    val return_value = callback(status)
    checkCallStatus(errorHandler, status)
    return return_value
}

// Check RustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> checkCallStatus(errorHandler: CallStatusErrorHandler<E>, status: RustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// CallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object NullCallStatusErrorHandler: CallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> rustCall(callback: (RustCallStatus) -> U): U {
    return rustCallWithError(NullCallStatusErrorHandler, callback);
}

// IntegerType that matches Rust's `usize` / C's `size_t`
public class USize(value: Long = 0) : IntegerType(Native.SIZE_T_SIZE, value, true) {
    // This is needed to fill in the gaps of IntegerType's implementation of Number for Kotlin.
    override fun toByte() = toInt().toByte()
    // Needed until https://youtrack.jetbrains.com/issue/KT-47902 is fixed.
    @Deprecated("`toInt().toChar()` is deprecated")
    override fun toChar() = toInt().toChar()
    override fun toShort() = toInt().toShort()

    fun writeToBuffer(buf: ByteBuffer) {
        // Make sure we always write usize integers using native byte-order, since they may be
        // casted to pointer values
        buf.order(ByteOrder.nativeOrder())
        try {
            when (Native.SIZE_T_SIZE) {
                4 -> buf.putInt(toInt())
                8 -> buf.putLong(toLong())
                else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
            }
        } finally {
            buf.order(ByteOrder.BIG_ENDIAN)
        }
    }

    companion object {
        val size: Int
            get() = Native.SIZE_T_SIZE

        fun readFromBuffer(buf: ByteBuffer) : USize {
            // Make sure we always read usize integers using native byte-order, since they may be
            // casted from pointer values
            buf.order(ByteOrder.nativeOrder())
            try {
                return when (Native.SIZE_T_SIZE) {
                    4 -> USize(buf.getInt().toLong())
                    8 -> USize(buf.getLong())
                    else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
                }
            } finally {
                buf.order(ByteOrder.BIG_ENDIAN)
            }
        }
    }
}


// Map handles to objects
//
// This is used when the Rust code expects an opaque pointer to represent some foreign object.
// Normally we would pass a pointer to the object, but JNA doesn't support getting a pointer from an
// object reference , nor does it support leaking a reference to Rust.
//
// Instead, this class maps USize values to objects so that we can pass a pointer-sized type to
// Rust when it needs an opaque pointer.
//
// TODO: refactor callbacks to use this class
internal class UniFfiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<USize, T>()
    // Use AtomicInteger for our counter, since we may be on a 32-bit system.  4 billion possible
    // values seems like enough. If somehow we generate 4 billion handles, then this will wrap
    // around back to zero and we can assume the first handle generated will have been dropped by
    // then.
    private val counter = java.util.concurrent.atomic.AtomicInteger(0)

    val size: Int
        get() = map.size

    fun insert(obj: T): USize {
        val handle = USize(counter.getAndAdd(1).toLong())
        map.put(handle, obj)
        return handle
    }

    fun get(handle: USize): T? {
        return map.get(handle)
    }

    fun remove(handle: USize) {
        map.remove(handle)
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "core_crypto_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface _UniFFILib : Library {
    companion object {
        internal val INSTANCE: _UniFFILib by lazy {
            loadIndirect<_UniFFILib>(componentName = "core_crypto")
            .also { lib: _UniFFILib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                }
        }
    }

    fun ffi_core_crypto_rustbuffer_alloc(`size`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_core_crypto_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_core_crypto_rustbuffer_free(`buf`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun ffi_core_crypto_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_core_crypto_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: _UniFFILib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 23
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_core_crypto_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: _UniFFILib) {
}

// Public interface members begin here.


public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len)
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}





sealed class CryptoError(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class E2eiException(message: String) : CryptoError(message)
        class ConversationNotFound(message: String) : CryptoError(message)
        class ConversationAlreadyExists(message: String) : CryptoError(message)
        class ClientNotFound(message: String) : CryptoError(message)
        class PendingProposalNotFound(message: String) : CryptoError(message)
        class PendingCommitNotFound(message: String) : CryptoError(message)
        class MalformedIdentifier(message: String) : CryptoError(message)
        class ClientSignatureNotFound(message: String) : CryptoError(message)
        class IdentityAlreadyPresent(message: String) : CryptoError(message)
        class NoProvisionalIdentityFound(message: String) : CryptoError(message)
        class TooManyIdentitiesPresent(message: String) : CryptoError(message)
        class LockPoisonException(message: String) : CryptoError(message)
        class ImplementationException(message: String) : CryptoError(message)
        class CredentialBundleConflict(message: String) : CryptoError(message)
        class ConsumerException(message: String) : CryptoError(message)
        class MlsProviderException(message: String) : CryptoError(message)
        class KeyStoreException(message: String) : CryptoError(message)
        class MlsException(message: String) : CryptoError(message)
        class Utf8Exception(message: String) : CryptoError(message)
        class StringUtf8Exception(message: String) : CryptoError(message)
        class ParseIntException(message: String) : CryptoError(message)
        class ConvertIntException(message: String) : CryptoError(message)
        class HexDecodeException(message: String) : CryptoError(message)
        class InvalidByteArrayException(message: String) : CryptoError(message)
        class IoException(message: String) : CryptoError(message)
        class Unauthorized(message: String) : CryptoError(message)
        class CallbacksNotSet(message: String) : CryptoError(message)
        class UnauthorizedExternalAddProposal(message: String) : CryptoError(message)
        class UnauthorizedExternalCommit(message: String) : CryptoError(message)
        class InvalidHashReference(message: String) : CryptoError(message)
        class DecryptionException(message: String) : CryptoError(message)
        class WrongEpoch(message: String) : CryptoError(message)
        class BufferedFutureMessage(message: String) : CryptoError(message)
        class ProteusException(message: String) : CryptoError(message)
        class CryptoboxMigrationException(message: String) : CryptoError(message)
        class ProteusNotInitialized(message: String) : CryptoError(message)
        class ProteusSupportNotEnabled(message: String) : CryptoError(message)
        class MlsNotInitialized(message: String) : CryptoError(message)
        class InvalidKeyPackage(message: String) : CryptoError(message)
        class InvalidIdentity(message: String) : CryptoError(message)
        class IdentityInitializationException(message: String) : CryptoError(message)
        class ParentGroupNotFound(message: String) : CryptoError(message)
        class MessageEpochTooOld(message: String) : CryptoError(message)
        class E2eiEnrollmentNotDone(message: String) : CryptoError(message)
        class CredentialNotFound(message: String) : CryptoError(message)
        class InternalMlsException(message: String) : CryptoError(message)
        class DuplicateMessage(message: String) : CryptoError(message)
        class ClearingPendingCommitException(message: String) : CryptoError(message)
        class SelfCommitIgnored(message: String) : CryptoError(message)
        class UnmergedPendingGroup(message: String) : CryptoError(message)
        class X509CertDerException(message: String) : CryptoError(message)
        class PemException(message: String) : CryptoError(message)
        class DomainNameNotFound(message: String) : CryptoError(message)
        class DomainNamesDontMatch(message: String) : CryptoError(message)
        class DuplicateDomainName(message: String) : CryptoError(message)
        class InvalidCertificateChain(message: String) : CryptoError(message)
        class EmptyTrustAnchorUpdate(message: String) : CryptoError(message)
        class DuplicateCertificateChain(message: String) : CryptoError(message)
        class OrphanWelcome(message: String) : CryptoError(message)
        class InvalidClientId(message: String) : CryptoError(message)
        class JsonException(message: String) : CryptoError(message)
        class StaleCommit(message: String) : CryptoError(message)
        class StaleProposal(message: String) : CryptoError(message)
        class MissingExternalSenderExtension(message: String) : CryptoError(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<CryptoError> {
        override fun lift(error_buf: RustBuffer.ByValue): CryptoError = FfiConverterTypeCryptoError.lift(error_buf)
    }
}

public object FfiConverterTypeCryptoError : FfiConverterRustBuffer<CryptoError> {
    override fun read(buf: ByteBuffer): CryptoError {
        
            return when(buf.getInt()) {
            1 -> CryptoError.E2eiException(FfiConverterString.read(buf))
            2 -> CryptoError.ConversationNotFound(FfiConverterString.read(buf))
            3 -> CryptoError.ConversationAlreadyExists(FfiConverterString.read(buf))
            4 -> CryptoError.ClientNotFound(FfiConverterString.read(buf))
            5 -> CryptoError.PendingProposalNotFound(FfiConverterString.read(buf))
            6 -> CryptoError.PendingCommitNotFound(FfiConverterString.read(buf))
            7 -> CryptoError.MalformedIdentifier(FfiConverterString.read(buf))
            8 -> CryptoError.ClientSignatureNotFound(FfiConverterString.read(buf))
            9 -> CryptoError.IdentityAlreadyPresent(FfiConverterString.read(buf))
            10 -> CryptoError.NoProvisionalIdentityFound(FfiConverterString.read(buf))
            11 -> CryptoError.TooManyIdentitiesPresent(FfiConverterString.read(buf))
            12 -> CryptoError.LockPoisonException(FfiConverterString.read(buf))
            13 -> CryptoError.ImplementationException(FfiConverterString.read(buf))
            14 -> CryptoError.CredentialBundleConflict(FfiConverterString.read(buf))
            15 -> CryptoError.ConsumerException(FfiConverterString.read(buf))
            16 -> CryptoError.MlsProviderException(FfiConverterString.read(buf))
            17 -> CryptoError.KeyStoreException(FfiConverterString.read(buf))
            18 -> CryptoError.MlsException(FfiConverterString.read(buf))
            19 -> CryptoError.Utf8Exception(FfiConverterString.read(buf))
            20 -> CryptoError.StringUtf8Exception(FfiConverterString.read(buf))
            21 -> CryptoError.ParseIntException(FfiConverterString.read(buf))
            22 -> CryptoError.ConvertIntException(FfiConverterString.read(buf))
            23 -> CryptoError.HexDecodeException(FfiConverterString.read(buf))
            24 -> CryptoError.InvalidByteArrayException(FfiConverterString.read(buf))
            25 -> CryptoError.IoException(FfiConverterString.read(buf))
            26 -> CryptoError.Unauthorized(FfiConverterString.read(buf))
            27 -> CryptoError.CallbacksNotSet(FfiConverterString.read(buf))
            28 -> CryptoError.UnauthorizedExternalAddProposal(FfiConverterString.read(buf))
            29 -> CryptoError.UnauthorizedExternalCommit(FfiConverterString.read(buf))
            30 -> CryptoError.InvalidHashReference(FfiConverterString.read(buf))
            31 -> CryptoError.DecryptionException(FfiConverterString.read(buf))
            32 -> CryptoError.WrongEpoch(FfiConverterString.read(buf))
            33 -> CryptoError.BufferedFutureMessage(FfiConverterString.read(buf))
            34 -> CryptoError.ProteusException(FfiConverterString.read(buf))
            35 -> CryptoError.CryptoboxMigrationException(FfiConverterString.read(buf))
            36 -> CryptoError.ProteusNotInitialized(FfiConverterString.read(buf))
            37 -> CryptoError.ProteusSupportNotEnabled(FfiConverterString.read(buf))
            38 -> CryptoError.MlsNotInitialized(FfiConverterString.read(buf))
            39 -> CryptoError.InvalidKeyPackage(FfiConverterString.read(buf))
            40 -> CryptoError.InvalidIdentity(FfiConverterString.read(buf))
            41 -> CryptoError.IdentityInitializationException(FfiConverterString.read(buf))
            42 -> CryptoError.ParentGroupNotFound(FfiConverterString.read(buf))
            43 -> CryptoError.MessageEpochTooOld(FfiConverterString.read(buf))
            44 -> CryptoError.E2eiEnrollmentNotDone(FfiConverterString.read(buf))
            45 -> CryptoError.CredentialNotFound(FfiConverterString.read(buf))
            46 -> CryptoError.InternalMlsException(FfiConverterString.read(buf))
            47 -> CryptoError.DuplicateMessage(FfiConverterString.read(buf))
            48 -> CryptoError.ClearingPendingCommitException(FfiConverterString.read(buf))
            49 -> CryptoError.SelfCommitIgnored(FfiConverterString.read(buf))
            50 -> CryptoError.UnmergedPendingGroup(FfiConverterString.read(buf))
            51 -> CryptoError.X509CertDerException(FfiConverterString.read(buf))
            52 -> CryptoError.PemException(FfiConverterString.read(buf))
            53 -> CryptoError.DomainNameNotFound(FfiConverterString.read(buf))
            54 -> CryptoError.DomainNamesDontMatch(FfiConverterString.read(buf))
            55 -> CryptoError.DuplicateDomainName(FfiConverterString.read(buf))
            56 -> CryptoError.InvalidCertificateChain(FfiConverterString.read(buf))
            57 -> CryptoError.EmptyTrustAnchorUpdate(FfiConverterString.read(buf))
            58 -> CryptoError.DuplicateCertificateChain(FfiConverterString.read(buf))
            59 -> CryptoError.OrphanWelcome(FfiConverterString.read(buf))
            60 -> CryptoError.InvalidClientId(FfiConverterString.read(buf))
            61 -> CryptoError.JsonException(FfiConverterString.read(buf))
            62 -> CryptoError.StaleCommit(FfiConverterString.read(buf))
            63 -> CryptoError.StaleProposal(FfiConverterString.read(buf))
            64 -> CryptoError.MissingExternalSenderExtension(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: CryptoError): Int {
        return 4
    }

    override fun write(value: CryptoError, buf: ByteBuffer) {
        when(value) {
            is CryptoError.E2eiException -> {
                buf.putInt(1)
                Unit
            }
            is CryptoError.ConversationNotFound -> {
                buf.putInt(2)
                Unit
            }
            is CryptoError.ConversationAlreadyExists -> {
                buf.putInt(3)
                Unit
            }
            is CryptoError.ClientNotFound -> {
                buf.putInt(4)
                Unit
            }
            is CryptoError.PendingProposalNotFound -> {
                buf.putInt(5)
                Unit
            }
            is CryptoError.PendingCommitNotFound -> {
                buf.putInt(6)
                Unit
            }
            is CryptoError.MalformedIdentifier -> {
                buf.putInt(7)
                Unit
            }
            is CryptoError.ClientSignatureNotFound -> {
                buf.putInt(8)
                Unit
            }
            is CryptoError.IdentityAlreadyPresent -> {
                buf.putInt(9)
                Unit
            }
            is CryptoError.NoProvisionalIdentityFound -> {
                buf.putInt(10)
                Unit
            }
            is CryptoError.TooManyIdentitiesPresent -> {
                buf.putInt(11)
                Unit
            }
            is CryptoError.LockPoisonException -> {
                buf.putInt(12)
                Unit
            }
            is CryptoError.ImplementationException -> {
                buf.putInt(13)
                Unit
            }
            is CryptoError.CredentialBundleConflict -> {
                buf.putInt(14)
                Unit
            }
            is CryptoError.ConsumerException -> {
                buf.putInt(15)
                Unit
            }
            is CryptoError.MlsProviderException -> {
                buf.putInt(16)
                Unit
            }
            is CryptoError.KeyStoreException -> {
                buf.putInt(17)
                Unit
            }
            is CryptoError.MlsException -> {
                buf.putInt(18)
                Unit
            }
            is CryptoError.Utf8Exception -> {
                buf.putInt(19)
                Unit
            }
            is CryptoError.StringUtf8Exception -> {
                buf.putInt(20)
                Unit
            }
            is CryptoError.ParseIntException -> {
                buf.putInt(21)
                Unit
            }
            is CryptoError.ConvertIntException -> {
                buf.putInt(22)
                Unit
            }
            is CryptoError.HexDecodeException -> {
                buf.putInt(23)
                Unit
            }
            is CryptoError.InvalidByteArrayException -> {
                buf.putInt(24)
                Unit
            }
            is CryptoError.IoException -> {
                buf.putInt(25)
                Unit
            }
            is CryptoError.Unauthorized -> {
                buf.putInt(26)
                Unit
            }
            is CryptoError.CallbacksNotSet -> {
                buf.putInt(27)
                Unit
            }
            is CryptoError.UnauthorizedExternalAddProposal -> {
                buf.putInt(28)
                Unit
            }
            is CryptoError.UnauthorizedExternalCommit -> {
                buf.putInt(29)
                Unit
            }
            is CryptoError.InvalidHashReference -> {
                buf.putInt(30)
                Unit
            }
            is CryptoError.DecryptionException -> {
                buf.putInt(31)
                Unit
            }
            is CryptoError.WrongEpoch -> {
                buf.putInt(32)
                Unit
            }
            is CryptoError.BufferedFutureMessage -> {
                buf.putInt(33)
                Unit
            }
            is CryptoError.ProteusException -> {
                buf.putInt(34)
                Unit
            }
            is CryptoError.CryptoboxMigrationException -> {
                buf.putInt(35)
                Unit
            }
            is CryptoError.ProteusNotInitialized -> {
                buf.putInt(36)
                Unit
            }
            is CryptoError.ProteusSupportNotEnabled -> {
                buf.putInt(37)
                Unit
            }
            is CryptoError.MlsNotInitialized -> {
                buf.putInt(38)
                Unit
            }
            is CryptoError.InvalidKeyPackage -> {
                buf.putInt(39)
                Unit
            }
            is CryptoError.InvalidIdentity -> {
                buf.putInt(40)
                Unit
            }
            is CryptoError.IdentityInitializationException -> {
                buf.putInt(41)
                Unit
            }
            is CryptoError.ParentGroupNotFound -> {
                buf.putInt(42)
                Unit
            }
            is CryptoError.MessageEpochTooOld -> {
                buf.putInt(43)
                Unit
            }
            is CryptoError.E2eiEnrollmentNotDone -> {
                buf.putInt(44)
                Unit
            }
            is CryptoError.CredentialNotFound -> {
                buf.putInt(45)
                Unit
            }
            is CryptoError.InternalMlsException -> {
                buf.putInt(46)
                Unit
            }
            is CryptoError.DuplicateMessage -> {
                buf.putInt(47)
                Unit
            }
            is CryptoError.ClearingPendingCommitException -> {
                buf.putInt(48)
                Unit
            }
            is CryptoError.SelfCommitIgnored -> {
                buf.putInt(49)
                Unit
            }
            is CryptoError.UnmergedPendingGroup -> {
                buf.putInt(50)
                Unit
            }
            is CryptoError.X509CertDerException -> {
                buf.putInt(51)
                Unit
            }
            is CryptoError.PemException -> {
                buf.putInt(52)
                Unit
            }
            is CryptoError.DomainNameNotFound -> {
                buf.putInt(53)
                Unit
            }
            is CryptoError.DomainNamesDontMatch -> {
                buf.putInt(54)
                Unit
            }
            is CryptoError.DuplicateDomainName -> {
                buf.putInt(55)
                Unit
            }
            is CryptoError.InvalidCertificateChain -> {
                buf.putInt(56)
                Unit
            }
            is CryptoError.EmptyTrustAnchorUpdate -> {
                buf.putInt(57)
                Unit
            }
            is CryptoError.DuplicateCertificateChain -> {
                buf.putInt(58)
                Unit
            }
            is CryptoError.OrphanWelcome -> {
                buf.putInt(59)
                Unit
            }
            is CryptoError.InvalidClientId -> {
                buf.putInt(60)
                Unit
            }
            is CryptoError.JsonException -> {
                buf.putInt(61)
                Unit
            }
            is CryptoError.StaleCommit -> {
                buf.putInt(62)
                Unit
            }
            is CryptoError.StaleProposal -> {
                buf.putInt(63)
                Unit
            }
            is CryptoError.MissingExternalSenderExtension -> {
                buf.putInt(64)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}





sealed class E2eIdentityError(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class ImplementationException(message: String) : E2eIdentityError(message)
        class NotYetSupported(message: String) : E2eIdentityError(message)
        class MissingExistingClient(message: String) : E2eIdentityError(message)
        class InvalidIdentity(message: String) : E2eIdentityError(message)
        class InvalidSignatureKey(message: String) : E2eIdentityError(message)
        class OutOfOrderEnrollment(message: String) : E2eIdentityError(message)
        class E2eiInvalidDomain(message: String) : E2eIdentityError(message)
        class InvalidRefreshToken(message: String) : E2eIdentityError(message)
        class KeyStoreException(message: String) : E2eIdentityError(message)
        class CryptoError(message: String) : E2eIdentityError(message)
        class IdentityException(message: String) : E2eIdentityError(message)
        class X509Exception(message: String) : E2eIdentityError(message)
        class UrlException(message: String) : E2eIdentityError(message)
        class JsonException(message: String) : E2eIdentityError(message)
        class Utf8Exception(message: String) : E2eIdentityError(message)
        class LockPoisonException(message: String) : E2eIdentityError(message)
        class TrustAnchorAlreadyRegistered(message: String) : E2eIdentityError(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<E2eIdentityError> {
        override fun lift(error_buf: RustBuffer.ByValue): E2eIdentityError = FfiConverterTypeE2eIdentityError.lift(error_buf)
    }
}

public object FfiConverterTypeE2eIdentityError : FfiConverterRustBuffer<E2eIdentityError> {
    override fun read(buf: ByteBuffer): E2eIdentityError {
        
            return when(buf.getInt()) {
            1 -> E2eIdentityError.ImplementationException(FfiConverterString.read(buf))
            2 -> E2eIdentityError.NotYetSupported(FfiConverterString.read(buf))
            3 -> E2eIdentityError.MissingExistingClient(FfiConverterString.read(buf))
            4 -> E2eIdentityError.InvalidIdentity(FfiConverterString.read(buf))
            5 -> E2eIdentityError.InvalidSignatureKey(FfiConverterString.read(buf))
            6 -> E2eIdentityError.OutOfOrderEnrollment(FfiConverterString.read(buf))
            7 -> E2eIdentityError.E2eiInvalidDomain(FfiConverterString.read(buf))
            8 -> E2eIdentityError.InvalidRefreshToken(FfiConverterString.read(buf))
            9 -> E2eIdentityError.KeyStoreException(FfiConverterString.read(buf))
            10 -> E2eIdentityError.CryptoError(FfiConverterString.read(buf))
            11 -> E2eIdentityError.IdentityException(FfiConverterString.read(buf))
            12 -> E2eIdentityError.X509Exception(FfiConverterString.read(buf))
            13 -> E2eIdentityError.UrlException(FfiConverterString.read(buf))
            14 -> E2eIdentityError.JsonException(FfiConverterString.read(buf))
            15 -> E2eIdentityError.Utf8Exception(FfiConverterString.read(buf))
            16 -> E2eIdentityError.LockPoisonException(FfiConverterString.read(buf))
            17 -> E2eIdentityError.TrustAnchorAlreadyRegistered(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: E2eIdentityError): Int {
        return 4
    }

    override fun write(value: E2eIdentityError, buf: ByteBuffer) {
        when(value) {
            is E2eIdentityError.ImplementationException -> {
                buf.putInt(1)
                Unit
            }
            is E2eIdentityError.NotYetSupported -> {
                buf.putInt(2)
                Unit
            }
            is E2eIdentityError.MissingExistingClient -> {
                buf.putInt(3)
                Unit
            }
            is E2eIdentityError.InvalidIdentity -> {
                buf.putInt(4)
                Unit
            }
            is E2eIdentityError.InvalidSignatureKey -> {
                buf.putInt(5)
                Unit
            }
            is E2eIdentityError.OutOfOrderEnrollment -> {
                buf.putInt(6)
                Unit
            }
            is E2eIdentityError.E2eiInvalidDomain -> {
                buf.putInt(7)
                Unit
            }
            is E2eIdentityError.InvalidRefreshToken -> {
                buf.putInt(8)
                Unit
            }
            is E2eIdentityError.KeyStoreException -> {
                buf.putInt(9)
                Unit
            }
            is E2eIdentityError.CryptoError -> {
                buf.putInt(10)
                Unit
            }
            is E2eIdentityError.IdentityException -> {
                buf.putInt(11)
                Unit
            }
            is E2eIdentityError.X509Exception -> {
                buf.putInt(12)
                Unit
            }
            is E2eIdentityError.UrlException -> {
                buf.putInt(13)
                Unit
            }
            is E2eIdentityError.JsonException -> {
                buf.putInt(14)
                Unit
            }
            is E2eIdentityError.Utf8Exception -> {
                buf.putInt(15)
                Unit
            }
            is E2eIdentityError.LockPoisonException -> {
                buf.putInt(16)
                Unit
            }
            is E2eIdentityError.TrustAnchorAlreadyRegistered -> {
                buf.putInt(17)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}

