/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.wix.restaurants.availability.DateTimeWindow;
import java.util.Calendar;
import java.util.Comparator;
import java.util.TimeZone;

public class DateTimeWindowComparator
implements Comparator<DateTimeWindow> {
    private final TimeZone tz;

    public DateTimeWindowComparator(TimeZone tz) {
        this.tz = tz;
    }

    @Override
    public int compare(DateTimeWindow o1, DateTimeWindow o2) {
        Calendar o1start = o1.start(this.tz);
        Calendar o1end = o1.end(this.tz);
        Calendar o2start = o2.start(this.tz);
        Calendar o2end = o2.end(this.tz);
        if (DateTimeWindowComparator.strictlyBefore(o1end, o2start)) {
            return -1;
        }
        if (DateTimeWindowComparator.strictlyBefore(o2end, o1start)) {
            return 1;
        }
        return 0;
    }

    private static boolean strictlyBefore(Calendar window1end, Calendar window2start) {
        if (window1end == null || window2start == null) {
            return false;
        }
        return !window1end.after(window2start);
    }
}

