/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.wix.restaurants.availability.DateTimeWindow;
import com.wix.restaurants.availability.DateTimeWindowComparator;
import com.wix.restaurants.availability.Status;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class DateTimeWindowsIterator
implements Iterator<Status> {
    private final TimeZone tz;
    private final Index index;
    private final boolean lastWindowUntilForever;
    private final List<DateTimeWindow> timeWindows;

    public DateTimeWindowsIterator(Calendar cal, List<DateTimeWindow> timeWindows) {
        if (timeWindows == null) {
            timeWindows = Collections.emptyList();
        }
        this.tz = cal.getTimeZone();
        this.timeWindows = timeWindows;
        if (!timeWindows.isEmpty()) {
            DateTimeWindow timeWindow = DateTimeWindow.create((Calendar)cal, null);
            int searchIndex = Collections.binarySearch(timeWindows, timeWindow, new DateTimeWindowComparator(this.tz));
            if (searchIndex >= 0) {
                this.index = new Index(searchIndex, false);
            } else {
                int insertionIndex = -searchIndex - 1;
                this.index = new Index(insertionIndex, true);
            }
            this.lastWindowUntilForever = ((DateTimeWindow)timeWindows.get((int)(timeWindows.size() - 1))).end == null;
        } else {
            this.index = new Index(0, true);
            this.lastWindowUntilForever = false;
        }
    }

    private static Date toJavaDate(Calendar cal) {
        return cal != null ? cal.getTime() : null;
    }

    @Override
    public boolean hasNext() {
        if (this.index.index() < this.timeWindows.size()) {
            return true;
        }
        return this.index.isDummyBefore() && !this.lastWindowUntilForever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status next() {
        try {
            if (this.index.index() == this.timeWindows.size()) {
                Status status = Status.UNKNOWN;
                return status;
            }
            DateTimeWindow nextTimeWindow = this.timeWindows.get(this.index.index());
            if (!this.index.isDummyBefore) {
                Status status = new Status(nextTimeWindow.available != false ? "available" : "unavailable", DateTimeWindowsIterator.toJavaDate(nextTimeWindow.end(this.tz)), nextTimeWindow.reason, nextTimeWindow.comment);
                return status;
            }
            Status status = new Status("unknown", DateTimeWindowsIterator.toJavaDate(nextTimeWindow.start(this.tz)));
            return status;
        }
        finally {
            this.index.advance();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported");
    }

    private class Index {
        private int index;
        private boolean isDummyBefore;

        public Index(int index, boolean isDummyBefore) {
            this.index = index;
            this.isDummyBefore = isDummyBefore;
        }

        public int index() {
            return this.index;
        }

        public boolean isDummyBefore() {
            return this.isDummyBefore;
        }

        public void advance() {
            if (this.isDummyBefore) {
                this.isDummyBefore = false;
            } else {
                this.isDummyBefore = true;
                ++this.index;
            }
        }
    }
}

