/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.wix.restaurants.availability.Status;
import java.util.Iterator;

public class MergingStatusIterator
implements Iterator<Status> {
    private final Iterator<Status> it;
    private Status nextStatus;

    public MergingStatusIterator(Iterator<Status> it) {
        this.it = it;
        this.nextStatus = it.hasNext() ? it.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.nextStatus != null;
    }

    @Override
    public Status next() {
        Status mergedStatus = this.nextStatus;
        while (true) {
            if (!this.it.hasNext()) {
                this.nextStatus = null;
                break;
            }
            this.nextStatus = this.it.next();
            if (!this.nextStatus.equalsIgnoreUntil(mergedStatus)) break;
            mergedStatus.until = this.nextStatus.until;
        }
        return mergedStatus;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported");
    }
}

