/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.wix.restaurants.availability.Availability;
import com.wix.restaurants.availability.DateTimeWindowsIterator;
import com.wix.restaurants.availability.Status;
import com.wix.restaurants.availability.WeeklyTimeWindowsIterator;
import java.util.Calendar;
import java.util.Iterator;

class TimeWindowsIterator
implements Iterator<Status> {
    private final WeeklyTimeWindowsIterator regularIt;
    private final DateTimeWindowsIterator exceptionsIt;
    private Status regularStatus;
    private Status exceptionStatus;
    private boolean hasNext = true;

    public TimeWindowsIterator(Calendar cal, Availability availability) {
        this.regularIt = new WeeklyTimeWindowsIterator(cal, availability.weekly);
        this.exceptionsIt = new DateTimeWindowsIterator(cal, availability.exceptions);
        this.regularStatus = this.regularIt.next();
        this.exceptionStatus = this.exceptionsIt.next();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Status next() {
        if ("unknown".equals(this.exceptionStatus.status) && this.exceptionStatus.until == null) {
            Status lastRegularStatus = this.regularStatus;
            if (this.regularIt.hasNext()) {
                this.regularStatus = this.regularIt.next();
            } else {
                this.hasNext = false;
            }
            return lastRegularStatus;
        }
        if (!"unknown".equals(this.exceptionStatus.status)) {
            if (this.exceptionStatus.until == null) {
                this.hasNext = false;
                return this.exceptionStatus;
            }
            Status lastExceptionStatus = this.exceptionStatus;
            this.exceptionStatus = this.exceptionsIt.next();
            while (this.regularStatus.until != null && !this.regularStatus.until().after(lastExceptionStatus.until())) {
                this.regularStatus = this.regularIt.next();
            }
            return lastExceptionStatus;
        }
        if (this.regularStatus.until == null || this.regularStatus.until().after(this.exceptionStatus.until())) {
            Status lastExceptionStatus = this.exceptionStatus;
            this.exceptionStatus = this.exceptionsIt.next();
            return new Status(this.regularStatus.status, lastExceptionStatus.until());
        }
        if (this.regularStatus.until().before(this.exceptionStatus.until())) {
            Status lastRegularStatus = this.regularStatus;
            this.regularStatus = this.regularIt.next();
            return lastRegularStatus;
        }
        this.exceptionStatus = this.exceptionsIt.next();
        Status lastRegularStatus = this.regularStatus;
        this.regularStatus = this.regularIt.next();
        return lastRegularStatus;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported");
    }
}

