/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.wix.restaurants.availability.Status;
import com.wix.restaurants.availability.WeeklyTimeWindow;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class WeeklyTimeWindowsIterator
implements Iterator<Status> {
    private final Calendar cal;
    private final List<WeeklyTimeWindowPlus> timeWindows = new ArrayList<WeeklyTimeWindowPlus>();
    private final boolean isConstant;
    private final boolean isFirstAndLastSame;
    private boolean hasNext = true;

    public WeeklyTimeWindowsIterator(Calendar cal, List<WeeklyTimeWindow> weekly) {
        if (weekly == null) {
            weekly = Collections.emptyList();
        }
        this.cal = (Calendar)cal.clone();
        if (weekly.isEmpty()) {
            this.timeWindows.add(new WeeklyTimeWindowPlus(0, 10080, "available"));
            this.isFirstAndLastSame = true;
        } else {
            int minuteOfWeek = 0;
            for (WeeklyTimeWindow weeklyTimeWindow : weekly) {
                if (weeklyTimeWindow.minuteOfWeek > minuteOfWeek) {
                    this.timeWindows.add(new WeeklyTimeWindowPlus(minuteOfWeek, weeklyTimeWindow.minuteOfWeek - minuteOfWeek, "unavailable"));
                }
                this.timeWindows.add(new WeeklyTimeWindowPlus(weeklyTimeWindow.minuteOfWeek, weeklyTimeWindow.durationMins, "available"));
                minuteOfWeek = weeklyTimeWindow.endMinuteOfWeek();
            }
            if (minuteOfWeek < 10080) {
                this.timeWindows.add(new WeeklyTimeWindowPlus(minuteOfWeek, 10080 - minuteOfWeek, "unavailable"));
            }
            WeeklyTimeWindowPlus firstWindow = this.timeWindows.get(0);
            WeeklyTimeWindowPlus weeklyTimeWindowPlus = this.timeWindows.get(this.timeWindows.size() - 1);
            this.isFirstAndLastSame = firstWindow.status() == weeklyTimeWindowPlus.status();
        }
        this.isConstant = this.timeWindows.size() == 1;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Status next() {
        if (this.isConstant) {
            this.hasNext = false;
            return new Status(this.timeWindows.get(0).status(), null);
        }
        int minuteOfWeek = WeeklyTimeWindowsIterator.minutesFromStartOfWeek(this.cal);
        WeeklyTimeWindowPlus currentWindow = this.timeWindows.get(this.find(minuteOfWeek));
        int newMinuteOfWeek = currentWindow.endMinuteOfWeek();
        if (newMinuteOfWeek == 10080) {
            newMinuteOfWeek = this.isFirstAndLastSame ? this.timeWindows.get(0).endMinuteOfWeek() : 0;
        }
        this.advanceCalender(minuteOfWeek, newMinuteOfWeek);
        return new Status(currentWindow.status(), this.cal.getTime());
    }

    private void advanceCalender(int oldMinuteOfWeek, int newMinuteOfWeek) {
        int minutesToAdvance = newMinuteOfWeek - oldMinuteOfWeek;
        if (minutesToAdvance < 0) {
            minutesToAdvance += 10080;
        }
        int daysToAdvance = minutesToAdvance / 1440;
        int hoursToAdvance = (minutesToAdvance -= daysToAdvance * 1440) / 60;
        this.cal.add(5, daysToAdvance);
        this.cal.add(11, hoursToAdvance);
        this.cal.add(12, minutesToAdvance -= hoursToAdvance * 60);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported");
    }

    private int find(int minuteOfWeek) {
        WeeklyTimeWindow timeWindow = new WeeklyTimeWindow(Integer.valueOf(minuteOfWeek), Integer.valueOf(1));
        int index = Collections.binarySearch(this.timeWindows, timeWindow, new Comparator<WeeklyTimeWindow>(){

            @Override
            public int compare(WeeklyTimeWindow o1, WeeklyTimeWindow o2) {
                if (o1.endMinuteOfWeek() <= o2.minuteOfWeek) {
                    return -1;
                }
                if (o2.endMinuteOfWeek() <= o1.minuteOfWeek) {
                    return 1;
                }
                return 0;
            }
        });
        if (index < 0) {
            throw new IllegalStateException("Unexpected weekly windows");
        }
        return index;
    }

    private static int minutesFromStartOfWeek(Calendar cal) {
        return (cal.get(7) - 1) * 1440 + cal.get(11) * 60 + cal.get(12);
    }

    private class WeeklyTimeWindowPlus
    extends WeeklyTimeWindow {
        private final String status;
        private static final long serialVersionUID = 1L;

        public WeeklyTimeWindowPlus(int minuteOfWeek, int durationMins, String status) {
            this.minuteOfWeek = minuteOfWeek;
            this.durationMins = durationMins;
            this.status = status;
        }

        public String status() {
            return this.status;
        }
    }
}

