/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.wordnik.mongo.connection.MongoDBConnectionManager;
import com.wordnik.mongo.connection.SchemaType;
import com.wordnik.system.mongodb.MongoUtil;
import com.wordnik.system.mongodb.OplogFileWriter;
import com.wordnik.system.mongodb.OplogTailThread;
import com.wordnik.system.mongodb.StopFileMonitor;
import java.util.ArrayList;

public class IncrementalBackupUtil
extends MongoUtil {
    protected static String DATABASE_HOST = null;
    protected static String DATABASE_USER_NAME = null;
    protected static String DATABASE_PASSWORD = null;
    protected static String COLLECTIONS_STRING;
    protected static boolean COMPRESS_OUTPUT_FILES;
    protected static int UNCOMPRESSED_FILE_SIZE_MB;
    protected static String OUTPUT_DIRECTORY;

    public static void main(String ... args) {
        if (!IncrementalBackupUtil.parseArgs(args)) {
            IncrementalBackupUtil.usage();
            return;
        }
        new IncrementalBackupUtil().run();
    }

    void run() {
        try {
            OplogFileWriter util = new OplogFileWriter();
            util.setOutputDirectory(OUTPUT_DIRECTORY);
            OplogTailThread thd = new OplogTailThread(util, MongoDBConnectionManager.getConnection((String)"OPLOG", (String)DATABASE_HOST, (int)27017, (String)"local", (String)DATABASE_USER_NAME, (String)DATABASE_PASSWORD, (int)SchemaType.READ_WRITE()));
            ArrayList<String> inclusions = new ArrayList<String>();
            ArrayList<String> exclusions = new ArrayList<String>();
            this.selectCollections(COLLECTIONS_STRING, inclusions, exclusions);
            thd.setBaseDir(OUTPUT_DIRECTORY);
            thd.setInclusions(inclusions);
            thd.setExclusions(exclusions);
            thd.start();
            new StopFileMonitor(thd).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean parseArgs(String ... args) {
        block9: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(1)) {
                case 'o': {
                    OUTPUT_DIRECTORY = args[++i];
                    IncrementalBackupUtil.validateDirectory(OUTPUT_DIRECTORY);
                    continue block9;
                }
                case 's': {
                    UNCOMPRESSED_FILE_SIZE_MB = Integer.parseInt(args[++i]);
                    continue block9;
                }
                case 'Z': {
                    COMPRESS_OUTPUT_FILES = true;
                    continue block9;
                }
                case 'c': {
                    COLLECTIONS_STRING = args[++i];
                    continue block9;
                }
                case 'u': {
                    DATABASE_USER_NAME = args[++i];
                    continue block9;
                }
                case 'p': {
                    DATABASE_PASSWORD = args[++i];
                    continue block9;
                }
                case 'h': {
                    DATABASE_HOST = args[++i];
                    continue block9;
                }
                default: {
                    System.out.println("unknown argument " + args[i]);
                    return false;
                }
            }
        }
        return true;
    }

    public static void usage() {
        System.out.println("usage: IncrementalBackupUtil");
        System.out.println(" -c : CSV of collections to process, scoped to the db (database.collection), ! will exclude");
        System.out.println(" -h : source database host[:port]");
        System.out.println(" -o : output directory");
        System.out.println(" [-u : source database username]");
        System.out.println(" [-p : source database password]");
        System.out.println(" [-s : max file size in MB, default 100]");
        System.out.println(" [-Z : gzip files]");
    }

    static {
        COMPRESS_OUTPUT_FILES = false;
        UNCOMPRESSED_FILE_SIZE_MB = 100;
    }
}

