/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import java.io.File;
import java.util.List;

public abstract class MongoUtil {
    protected void selectCollections(String collectionString, List<String> collectionsToAdd, List<String> collectionsToSkip) {
        if (collectionString != null) {
            String[] collectionNames;
            boolean hasIncludes = false;
            for (String collectionName : collectionNames = collectionString.split(",")) {
                if (collectionName.startsWith("!")) {
                    collectionsToSkip.add(collectionName.substring(1).trim());
                    continue;
                }
                collectionsToAdd.add(collectionName.trim());
                hasIncludes = true;
            }
            if (!hasIncludes) {
                collectionsToAdd.add("*");
            }
        } else {
            collectionsToAdd.add("*");
        }
    }

    protected static void validateDirectory(String directory) {
        File dir = new File(directory);
        if (!dir.exists() && !dir.mkdir()) {
            throw new RuntimeException("can't create output dir");
        }
    }
}

