/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.BasicDBObject;
import com.wordnik.system.mongodb.OplogRecordProcessor;
import com.wordnik.util.AbstractFileWriter;
import com.wordnik.util.BinaryRotatingFileWriter;
import com.wordnik.util.RotatingFileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bson.BSON;
import org.bson.BSONObject;

public class OplogFileWriter
implements OplogRecordProcessor {
    protected String outputDirectory;
    protected String collectionName = "oplog";
    protected static boolean WRITE_JSON = false;
    protected static boolean COMPRESS_OUTPUT_FILES = false;
    protected static int UNCOMPRESSED_FILE_SIZE_MB = 100;
    protected static Map<String, AbstractFileWriter> WRITERS = new HashMap<String, AbstractFileWriter>();

    @Override
    public void processRecord(BasicDBObject dbo) throws Exception {
        if (WRITE_JSON) {
            RotatingFileWriter writer = (RotatingFileWriter)WRITERS.get(this.collectionName);
            if (writer == null) {
                writer = new RotatingFileWriter(this.collectionName, this.outputDirectory, "json", (long)UNCOMPRESSED_FILE_SIZE_MB * 0x100000L, COMPRESS_OUTPUT_FILES);
                WRITERS.put(this.collectionName, writer);
            }
            writer.write(dbo.toString());
        } else {
            BinaryRotatingFileWriter writer = (BinaryRotatingFileWriter)WRITERS.get(this.collectionName);
            if (writer == null) {
                writer = new BinaryRotatingFileWriter(this.collectionName, this.outputDirectory, "bson", (long)UNCOMPRESSED_FILE_SIZE_MB * 0x100000L, COMPRESS_OUTPUT_FILES);
                WRITERS.put(this.collectionName, writer);
            }
            writer.write(BSON.encode((BSONObject)dbo));
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void close(String string) throws IOException {
        AbstractFileWriter writer = WRITE_JSON ? (RotatingFileWriter)WRITERS.get(this.collectionName) : WRITERS.get(this.collectionName);
        if (writer != null) {
            writer.close();
        }
    }
}

