/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.wordnik.mongo.connection.MongoDBConnectionManager;
import com.wordnik.mongo.connection.SchemaType;
import com.wordnik.system.mongodb.OplogRecordProcessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bson.BasicBSONObject;

public class OplogReplayWriter
implements OplogRecordProcessor {
    protected static Map<String, String> COLLECTION_MAPPING = new HashMap<String, String>();
    protected static Map<String, String> DATABASE_MAPPING = new HashMap<String, String>();
    protected static Map<String, String> NAMESPACE_COLLECTION_MAP = new HashMap<String, String>();
    protected static Map<String, String> UNMAPPED_NAMESPACE_COLLECTION_MAP = new HashMap<String, String>();
    protected String destinationDatabaseUsername;
    protected String destinationDatabasePassword;
    protected String destinationDatabaseHost;
    protected long insertCount;
    protected long updateCount;
    protected long deleteCount;
    protected long commandCount;

    public void addDatabaseMapping(String src, String dst) {
        DATABASE_MAPPING.put(src, dst);
    }

    public void setDatabaseMappings(Map<String, String> mappings) {
        DATABASE_MAPPING = mappings;
    }

    public void addCollectionMapping(String src, String dst) {
        COLLECTION_MAPPING.put(src, dst);
    }

    public void setCollectionMappings(Map<String, String> mappings) {
        COLLECTION_MAPPING = mappings;
    }

    public long getInsertCount() {
        return this.insertCount;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public long getDeleteCount() {
        return this.deleteCount;
    }

    public long getCommandCount() {
        return this.commandCount;
    }

    public String getDestinationDatabaseUsername() {
        return this.destinationDatabaseUsername;
    }

    public void setDestinationDatabaseUsername(String destinationDatabaseUsername) {
        this.destinationDatabaseUsername = destinationDatabaseUsername;
    }

    public String getDestinationDatabasePassword() {
        return this.destinationDatabasePassword;
    }

    public void setDestinationDatabasePassword(String destinationDatabasePassword) {
        this.destinationDatabasePassword = destinationDatabasePassword;
    }

    public String getDestinationDatabaseHost() {
        return this.destinationDatabaseHost;
    }

    public void setDestinationDatabaseHost(String destinationDatabaseHost) {
        this.destinationDatabaseHost = destinationDatabaseHost;
    }

    @Override
    public void processRecord(BasicDBObject dbo) throws Exception {
        String operationType = dbo.getString("op");
        String namespace = dbo.getString("ns");
        String targetCollection = this.getMappedCollectionFromNamespace(namespace);
        BasicDBObject operation = new BasicDBObject((Map)((BasicBSONObject)dbo.get("o")));
        String targetDatabase = this.getDatabaseMapping(namespace);
        if (this.shouldProcessRecord(targetDatabase, targetCollection)) {
            DB db = MongoDBConnectionManager.getConnection((String)"REPLAY", (String)this.destinationDatabaseHost, (String)targetDatabase, (String)this.destinationDatabaseUsername, (String)this.destinationDatabasePassword, (int)SchemaType.READ_WRITE());
            DBCollection coll = db.getCollection(targetCollection);
            if ("i".equals(operationType)) {
                ++this.insertCount;
                coll.insert(new DBObject[]{operation});
            } else if ("d".equals(operationType)) {
                ++this.deleteCount;
                coll.remove((DBObject)operation);
            } else if ("u".equals(operationType)) {
                ++this.updateCount;
                BasicDBObject o2 = new BasicDBObject((Map)((BasicBSONObject)dbo.get("o2")));
                coll.update((DBObject)o2, (DBObject)operation);
            } else if ("c".equals(operationType)) {
                ++this.commandCount;
                db.command((DBObject)operation);
            }
        }
    }

    protected boolean shouldProcessRecord(String database, String collection) {
        return database != null && collection != null;
    }

    public String getUnmappedCollectionFromNamespace(String namespace) {
        if (UNMAPPED_NAMESPACE_COLLECTION_MAP.containsKey(namespace)) {
            return UNMAPPED_NAMESPACE_COLLECTION_MAP.get(namespace);
        }
        String[] parts = namespace.split("\\.");
        if (parts == null || parts.length == 1) {
            return null;
        }
        String collection = null;
        collection = parts.length == 2 ? parts[1] : namespace.substring(parts[0].length() + 1);
        UNMAPPED_NAMESPACE_COLLECTION_MAP.put(namespace, collection);
        return collection;
    }

    public String getMappedCollectionFromNamespace(String namespace) {
        if (NAMESPACE_COLLECTION_MAP.containsKey(namespace)) {
            return NAMESPACE_COLLECTION_MAP.get(namespace);
        }
        String[] parts = namespace.split("\\.");
        if (parts == null || parts.length == 1) {
            return null;
        }
        String collection = null;
        collection = parts.length == 2 ? parts[1] : namespace.substring(parts[0].length() + 1);
        collection = this.remapCollection(collection);
        NAMESPACE_COLLECTION_MAP.put(namespace, collection);
        return collection;
    }

    public String remapCollection(String collection) {
        String o = COLLECTION_MAPPING.get(collection);
        return o == null ? collection : o;
    }

    public String getDatabaseMapping(String namespace) {
        String[] parts = namespace.split("\\.");
        if (parts == null || parts.length == 1) {
            return null;
        }
        String databaseName = parts[0];
        databaseName = this.remapDatabase(databaseName);
        return databaseName;
    }

    public String remapDatabase(String databaseName) {
        String o = DATABASE_MAPPING.get(databaseName);
        return o == null ? databaseName : o;
    }

    @Override
    public void close(String string) throws IOException {
    }
}

