/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoInternalException;
import com.wordnik.system.mongodb.OplogRecordProcessor;
import com.wordnik.util.PrintFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.bson.types.BSONTimestamp;

public class OplogTailThread
extends Thread {
    protected boolean running = false;
    protected boolean killMe = false;
    protected long reportInterval = 10000L;
    protected List<String> inclusions;
    protected List<String> exclusions;
    protected OplogRecordProcessor processor;
    protected DB db;
    protected static String OPLOG_LAST_FILENAME = "last_timestamp.txt";
    protected String collectionName = "oplog.$main";

    public OplogTailThread(OplogRecordProcessor processor, DB db) {
        this.db = db;
        this.processor = processor;
        this.setName("OplogTailThread");
    }

    public void setBaseDir(String dir) {
        if (dir != null) {
            OPLOG_LAST_FILENAME = dir + File.separator + OPLOG_LAST_FILENAME;
        }
    }

    public void setInclusions(List<String> inclusions) {
        this.inclusions = inclusions;
    }

    public void setExclusions(List<String> exclusions) {
        this.exclusions = exclusions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLastTimestamp(BSONTimestamp ts) {
        if (ts == null) {
            return;
        }
        Writer writer = null;
        try {
            FileOutputStream out = new FileOutputStream(new File(OPLOG_LAST_FILENAME));
            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            writer.write(Integer.toString(ts.getTime()) + "|" + Integer.toString(ts.getInc()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BSONTimestamp getLastTimestamp() {
        block16: {
            BSONTimestamp bSONTimestamp;
            BufferedReader input = null;
            try {
                File file = new File(OPLOG_LAST_FILENAME);
                if (!file.exists()) {
                    BSONTimestamp bSONTimestamp2 = null;
                    return bSONTimestamp2;
                }
                input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                String line = input.readLine();
                String[] parts = line.split("\\|");
                bSONTimestamp = new BSONTimestamp(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            }
            catch (Exception e) {
                e.printStackTrace();
                break block16;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return bSONTimestamp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        BSONTimestamp lastTimestamp = null;
        try {
            lastTimestamp = this.getLastTimestamp();
            long lastWrite = 0L;
            long startTime = System.currentTimeMillis();
            long lastOutput = System.currentTimeMillis();
            block17: while (true) {
                try {
                    if (this.killMe) {
                        System.out.println("exiting thread");
                        return;
                    }
                }
                catch (MongoInternalException ex) {
                    this.killMe = true;
                    this.writeLastTimestamp(lastTimestamp);
                    ex.printStackTrace();
                    Thread.sleep(1000L);
                    this.writeLastTimestamp(lastTimestamp);
                    try {
                        this.processor.close("oplog");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                {
                    DBCollection oplog = this.db.getCollection(this.collectionName);
                    DBCursor cursor = null;
                    cursor = lastTimestamp != null ? oplog.find((DBObject)new BasicDBObject("ts", (Object)new BasicDBObject("$gt", (Object)lastTimestamp))) : oplog.find();
                    cursor.addOption(2);
                    cursor.addOption(32);
                    long count = 0L;
                    long skips = 0L;
                    while (true) {
                        long duration;
                        if (this.killMe || !cursor.hasNext()) continue block17;
                        DBObject x = cursor.next();
                        lastTimestamp = (BSONTimestamp)x.get("ts");
                        if (this.shouldWrite(x)) {
                            this.processor.processRecord((BasicDBObject)x);
                            ++count;
                        } else {
                            ++skips;
                        }
                        if (System.currentTimeMillis() - lastWrite > 1000L) {
                            this.writeLastTimestamp(lastTimestamp);
                            lastWrite = System.currentTimeMillis();
                        }
                        if ((duration = System.currentTimeMillis() - lastOutput) <= this.reportInterval) continue;
                        this.report("oplog", count, skips, System.currentTimeMillis() - startTime);
                        lastOutput = System.currentTimeMillis();
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.writeLastTimestamp(lastTimestamp);
            try {
                this.processor.close("oplog");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.running = false;
    }

    boolean shouldWrite(DBObject obj) {
        String ns = (String)obj.get("ns");
        if (ns == null || "".equals(ns)) {
            return false;
        }
        if (this.exclusions.size() == 0 && this.inclusions.size() == 0) {
            return true;
        }
        if (this.exclusions.contains(ns)) {
            return false;
        }
        if (this.inclusions.contains(ns) || this.inclusions.contains("*")) {
            System.out.println("including " + ns);
            return true;
        }
        if (ns.indexOf(46) > 0 && this.inclusions.contains(ns.substring(0, ns.indexOf(46)))) {
            System.out.println("including* " + ns);
            return true;
        }
        return false;
    }

    void report(String collectionName, long count, long skips, long duration) {
        double brate = (double)count / ((double)duration / 1000.0);
        System.out.println(collectionName + ": " + PrintFormat.LONG_FORMAT.format(count) + " records, " + PrintFormat.LONG_FORMAT.format(brate) + " req/sec, " + PrintFormat.LONG_FORMAT.format(skips) + " skips");
    }
}

