/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.BasicDBObject;
import com.wordnik.system.mongodb.MongoUtil;
import com.wordnik.system.mongodb.OplogReplayWriter;
import com.wordnik.util.PrintFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;

public class ReplayUtil
extends MongoUtil {
    protected static String INPUT_DIR;
    protected static String COLLECTION_STRING;
    protected static String COLLECTION_MAPPING_STRING;
    protected static String DATABASE_MAPPING_STRING;
    protected static Map<String, String> COLLECTION_MAPPING;
    protected static Map<String, String> DATABASE_MAPPING;
    protected static Set<String> COLLECTIONS_TO_SKIP;
    protected static Set<String> COLLECTIONS_TO_ADD;
    protected static BSONTimestamp AFTER_TIMESTAMP;
    protected static BSONTimestamp BEFORE_TIMESTAMP;
    protected static boolean ONLY_COLLECTION_EXCLUSIONS;
    protected static Map<String, String> NAMESPACE_COLLECTION_MAP;
    protected static String DEST_DATABASE_NAME;
    protected static String DEST_DATABASE_USER_NAME;
    protected static String DEST_DATABASE_PASSWORD;
    protected static String DEST_DATABASE_HOST;
    protected static long REPORT_INTERVAL;

    public static void main(String ... args) {
        if (!ReplayUtil.parseArgs(args)) {
            ReplayUtil.usage();
            return;
        }
        if (INPUT_DIR == null) {
            ReplayUtil.usage();
            return;
        }
        new ReplayUtil().run();
    }

    protected static void selectCollections() {
        if (COLLECTION_STRING != null) {
            String[] collectionNames;
            for (String collectionName : collectionNames = COLLECTION_STRING.split(",")) {
                if (collectionName.startsWith("!")) {
                    COLLECTIONS_TO_SKIP.add(collectionName.substring(1));
                    continue;
                }
                ONLY_COLLECTION_EXCLUSIONS = false;
                COLLECTIONS_TO_ADD.add(collectionName);
            }
        }
    }

    protected static void createMappings(String databaseMappingString, String collectionMappingString, Map<String, String> databaseMappings, Map<String, String> collectionMappings) {
        String[] split;
        StringTokenizer tk;
        if (databaseMappingString != null) {
            tk = new StringTokenizer(databaseMappingString, ",");
            while (tk.hasMoreElements()) {
                split = tk.nextToken().split("\\=");
                databaseMappings.put(split[0], split[1]);
            }
        }
        if (collectionMappingString != null) {
            tk = new StringTokenizer(collectionMappingString, ",");
            while (tk.hasMoreElements()) {
                split = tk.nextToken().split("\\=");
                collectionMappings.put(split[0], split[1]);
            }
        }
    }

    protected void run() {
        ReplayUtil.selectCollections();
        OplogReplayWriter util = new OplogReplayWriter();
        HashMap<String, String> collectionMappings = new HashMap<String, String>();
        HashMap<String, String> databaseMappings = new HashMap<String, String>();
        ReplayUtil.createMappings(DATABASE_MAPPING_STRING, COLLECTION_MAPPING_STRING, databaseMappings, collectionMappings);
        util.setCollectionMappings(collectionMappings);
        util.setDatabaseMappings(databaseMappings);
        util.setDestinationDatabaseUsername(DEST_DATABASE_USER_NAME);
        util.setDestinationDatabasePassword(DEST_DATABASE_PASSWORD);
        util.setDestinationDatabaseHost(DEST_DATABASE_HOST);
        try {
            File[] files = new File(INPUT_DIR).listFiles();
            if (files != null) {
                ArrayList<File> filesToProcess = new ArrayList<File>();
                for (File file : files) {
                    if (file.getName().indexOf(".bson") <= 0) continue;
                    filesToProcess.add(file);
                }
                long operationsRead = 0L;
                long operationsSkipped = 0L;
                long lastOutput = System.currentTimeMillis();
                for (File file : filesToProcess) {
                    System.out.println("replaying file " + file.getName());
                    BufferedInputStream inputStream = null;
                    try {
                        BSONObject obj;
                        if (file.getName().endsWith(".gz")) {
                            GZIPInputStream is = new GZIPInputStream(new FileInputStream(file));
                            inputStream = new BufferedInputStream(is);
                        } else {
                            inputStream = new BufferedInputStream(new FileInputStream(file));
                        }
                        BSONDecoder decoder = new BSONDecoder();
                        while (inputStream.available() != 0 && (obj = decoder.readObject((InputStream)inputStream)) != null) {
                            long durationSinceLastOutput;
                            BasicDBObject dbo = new BasicDBObject((Map)((BasicBSONObject)obj));
                            BSONTimestamp operationTimestamp = (BSONTimestamp)dbo.get("ts");
                            String namespace = dbo.getString("ns");
                            String collection = util.getUnmappedCollectionFromNamespace(namespace);
                            boolean shouldProcess = this.shouldProcessRecord(collection, operationTimestamp);
                            if (collection != null && shouldProcess) {
                                util.processRecord(dbo);
                                ++operationsRead;
                            } else {
                                ++operationsSkipped;
                            }
                            if ((durationSinceLastOutput = System.currentTimeMillis() - lastOutput) <= REPORT_INTERVAL) continue;
                            this.report(util.getInsertCount(), util.getUpdateCount(), util.getDeleteCount(), operationsRead, operationsSkipped, durationSinceLastOutput);
                            lastOutput = System.currentTimeMillis();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean shouldProcessRecord(String collection, BSONTimestamp timestamp) {
        boolean shouldProcess = false;
        if (COLLECTIONS_TO_ADD.contains(collection)) {
            shouldProcess = true;
        }
        if (COLLECTIONS_TO_SKIP.contains(collection)) {
            shouldProcess = false;
        } else if (ONLY_COLLECTION_EXCLUSIONS) {
            shouldProcess = true;
        }
        if (AFTER_TIMESTAMP != null && timestamp.getTime() < AFTER_TIMESTAMP.getTime()) {
            shouldProcess = false;
        }
        if (BEFORE_TIMESTAMP != null && timestamp.getTime() >= BEFORE_TIMESTAMP.getTime()) {
            shouldProcess = false;
        }
        return shouldProcess;
    }

    public static boolean parseArgs(String ... args) {
        block15: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(1)) {
                case 'i': {
                    INPUT_DIR = args[++i];
                    continue block15;
                }
                case 'c': {
                    COLLECTION_STRING = args[++i];
                    continue block15;
                }
                case 'R': {
                    DATABASE_MAPPING_STRING = args[++i];
                    continue block15;
                }
                case 'r': {
                    COLLECTION_MAPPING_STRING = args[++i];
                    continue block15;
                }
                case 'a': {
                    Date date;
                    SimpleDateFormat sdf;
                    try {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        date = sdf.parse(args[++i]);
                        AFTER_TIMESTAMP = new BSONTimestamp((int)(date.getTime() / 1000L), 0);
                        continue block15;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("invalid date supplied");
                    }
                }
                case 'b': {
                    Date date;
                    SimpleDateFormat sdf;
                    try {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        date = sdf.parse(args[++i]);
                        BEFORE_TIMESTAMP = new BSONTimestamp((int)(date.getTime() / 1000L), 0);
                        continue block15;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("invalid date supplied");
                    }
                }
                case 'u': {
                    DEST_DATABASE_USER_NAME = args[++i];
                    continue block15;
                }
                case 'p': {
                    DEST_DATABASE_PASSWORD = args[++i];
                    continue block15;
                }
                case 'h': {
                    DEST_DATABASE_HOST = args[++i];
                    continue block15;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    void report(long inserts, long updates, long deletes, long totalCount, long skips, long duration) {
        double brate = (double)totalCount / ((double)duration / 1000.0);
        System.out.println("inserts: " + PrintFormat.LONG_FORMAT.format(inserts) + ", updates: " + PrintFormat.LONG_FORMAT.format(updates) + ", deletes: " + PrintFormat.LONG_FORMAT.format(deletes) + ", skips: " + PrintFormat.LONG_FORMAT.format(skips) + " (" + PrintFormat.LONG_FORMAT.format(brate) + " req/sec)");
    }

    public static void usage() {
        System.out.println("usage: ReplayUtil");
        System.out.println(" -i : input directory");
        System.out.println(" -c : CSV collection string (prefix with ! to exclude)");
        System.out.println(" -r : collection re-targeting (format: {SOURCE}={TARGET}");
        System.out.println(" -R : database re-targeting (format: {SOURCE}={TARGET}");
        System.out.println(" -a : only process entries after this timestamp");
        System.out.println(" -b : only process entries before this timestamp");
        System.out.println(" -h : destination hostname");
        System.out.println(" [-u : username]");
        System.out.println(" [-p : password]");
    }

    static {
        COLLECTION_MAPPING = new HashMap<String, String>();
        DATABASE_MAPPING = new HashMap<String, String>();
        COLLECTIONS_TO_SKIP = new HashSet<String>();
        COLLECTIONS_TO_ADD = new HashSet<String>();
        AFTER_TIMESTAMP = null;
        BEFORE_TIMESTAMP = null;
        ONLY_COLLECTION_EXCLUSIONS = true;
        NAMESPACE_COLLECTION_MAP = new HashMap<String, String>();
        DEST_DATABASE_NAME = "test";
        DEST_DATABASE_USER_NAME = null;
        DEST_DATABASE_PASSWORD = null;
        DEST_DATABASE_HOST = "localhost";
        REPORT_INTERVAL = 10000L;
    }
}

