/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.DB;
import com.wordnik.mongo.connection.MongoDBConnectionManager;
import com.wordnik.mongo.connection.SchemaType;
import com.wordnik.system.mongodb.MongoUtil;
import com.wordnik.system.mongodb.OplogReplayWriter;
import com.wordnik.system.mongodb.OplogTailThread;
import com.wordnik.system.mongodb.StopFileMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ReplicationUtil
extends MongoUtil {
    protected static String DATABASE_HOST = null;
    protected static String DATABASE_USER_NAME = null;
    protected static String DATABASE_PASSWORD = null;
    protected static String DEST_DATABASE_USER_NAME = null;
    protected static String DEST_DATABASE_PASSWORD = null;
    protected static String DEST_DATABASE_HOST = null;
    protected static String DEST_DATABASE_NAME = null;
    protected static String DATABASE_MAPPING = null;
    protected static String OPLOG_LAST_FILENAME = "last_timestamp.txt";
    protected static String COLLECTIONS_STRING;

    public static void main(String ... args) {
        if (!ReplicationUtil.parseArgs(args)) {
            ReplicationUtil.usage();
            return;
        }
        if (DATABASE_HOST == null) {
            ReplicationUtil.usage();
            return;
        }
        if (DEST_DATABASE_HOST == null) {
            ReplicationUtil.usage();
            return;
        }
        new ReplicationUtil().run();
    }

    protected void run() {
        OplogReplayWriter util = new OplogReplayWriter();
        if (DATABASE_MAPPING != null) {
            Map<String, String> mappings = this.getMappings(DATABASE_MAPPING);
            for (String key : mappings.keySet()) {
                String value = mappings.get(key);
                util.addDatabaseMapping(key, value);
            }
        }
        util.setDestinationDatabaseUsername(DEST_DATABASE_USER_NAME);
        util.setDestinationDatabasePassword(DEST_DATABASE_PASSWORD);
        util.setDestinationDatabaseHost(DEST_DATABASE_HOST);
        try {
            DB db = MongoDBConnectionManager.getConnection((String)"DB", (String)DATABASE_HOST, (String)"local", (String)DATABASE_USER_NAME, (String)DATABASE_PASSWORD, (int)SchemaType.READ_WRITE());
            OplogTailThread thd = new OplogTailThread(util, db);
            ArrayList<String> inclusions = new ArrayList<String>();
            ArrayList<String> exclusions = new ArrayList<String>();
            this.selectCollections(COLLECTIONS_STRING, inclusions, exclusions);
            thd.setInclusions(inclusions);
            thd.setExclusions(exclusions);
            thd.start();
            StopFileMonitor mon = new StopFileMonitor(thd);
            mon.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getMappings(String mappingString) {
        HashMap<String, String> output = new HashMap<String, String>();
        StringTokenizer tk = new StringTokenizer(mappingString, ",");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            StringTokenizer tk2 = new StringTokenizer(token, ":");
            if (tk2.countTokens() != 2) continue;
            String src = tk2.nextToken();
            String dest = tk2.nextToken();
            System.out.println(src + ", " + dest);
            output.put(src, dest);
        }
        return output;
    }

    public static boolean parseArgs(String ... args) {
        block11: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(1)) {
                case 'U': {
                    DEST_DATABASE_USER_NAME = args[++i];
                    continue block11;
                }
                case 'P': {
                    DEST_DATABASE_PASSWORD = args[++i];
                    continue block11;
                }
                case 'H': {
                    DEST_DATABASE_HOST = args[++i];
                    continue block11;
                }
                case 'c': {
                    COLLECTIONS_STRING = args[++i];
                    continue block11;
                }
                case 'u': {
                    DATABASE_USER_NAME = args[++i];
                    continue block11;
                }
                case 'p': {
                    DATABASE_PASSWORD = args[++i];
                    continue block11;
                }
                case 'h': {
                    DATABASE_HOST = args[++i];
                    continue block11;
                }
                case 'd': {
                    DEST_DATABASE_NAME = args[++i];
                    continue block11;
                }
                case 'm': {
                    DATABASE_MAPPING = args[++i];
                    continue block11;
                }
                default: {
                    System.out.println("unknown argument " + args[i]);
                    return false;
                }
            }
        }
        return true;
    }

    public static void usage() {
        System.out.println("usage: ReplicationUtil");
        System.out.println(" -c : CSV collection string (prefix with ! to exclude)");
        System.out.println(" -h : source database host[:port]");
        System.out.println(" [-u : source database username]");
        System.out.println(" [-p : source database password]");
        System.out.println(" -H : target database host[:port]");
        System.out.println(" [-U : target database username]");
        System.out.println(" [-P : target database password]");
        System.out.println(" -m : mapping between source + dest databases (a:a',b:b')");
    }
}

