/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.wordnik.mongo.connection.MongoDBConnectionManager;
import com.wordnik.mongo.connection.SchemaType;
import com.wordnik.system.mongodb.CollectionInfo;
import com.wordnik.system.mongodb.MongoUtil;
import com.wordnik.util.PrintFormat;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class RestoreUtil
extends MongoUtil {
    protected static String INPUT_DIR;
    protected static String COLLECTION_STRING;
    protected static boolean DROP_EXISTING;
    protected static String DATABASE_HOST;
    protected static String DATABASE_NAME;
    protected static String DATABASE_USER_NAME;
    protected static String DATABASE_PASSWORD;
    static long REPORT_DURATION;

    public static void main(String ... args) {
        if (!RestoreUtil.parseArgs(args)) {
            RestoreUtil.usage();
            return;
        }
        if (DATABASE_NAME == null) {
            RestoreUtil.usage();
            return;
        }
        new RestoreUtil().run();
    }

    protected void run() {
        if (INPUT_DIR == null) {
            RestoreUtil.usage();
            return;
        }
        List<CollectionInfo> collections = this.getCollections();
        for (CollectionInfo info : collections) {
            this.restore(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restore(CollectionInfo info) {
        block13: {
            try {
                System.out.println("restoring collection " + info.getName());
                File[] files = new File(INPUT_DIR).listFiles();
                if (files == null) break block13;
                ArrayList<File> filesToProcess = new ArrayList<File>();
                for (File file : files) {
                    if (!file.getName().startsWith(info.getName()) || file.getName().indexOf(".bson") <= 0) continue;
                    filesToProcess.add(file);
                }
                Collections.sort(filesToProcess, new FilenameComparator());
                if (DROP_EXISTING) {
                    try {
                        System.out.println("Dropping collection " + info.getName());
                        DB db = MongoDBConnectionManager.getConnection((String)"DB", (String)DATABASE_HOST, (String)"local", (String)DATABASE_USER_NAME, (String)DATABASE_PASSWORD, (int)SchemaType.READ_WRITE());
                        DBCollection coll = db.getCollection(info.getName());
                        coll.drop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                long count = 0L;
                long startTime = System.currentTimeMillis();
                long lastOutput = System.currentTimeMillis();
                for (File file : filesToProcess) {
                    System.out.println("restoring file " + file.getName() + " to collection " + info.getName());
                    InputStream inputStream = null;
                    try {
                        BSONObject obj;
                        inputStream = file.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new BufferedInputStream(new FileInputStream(file));
                        BSONDecoder decoder = new BSONDecoder();
                        while (inputStream.available() != 0 && (obj = decoder.readObject(inputStream)) != null) {
                            this.write(info, (DBObject)new BasicDBObject((Map)((BasicBSONObject)obj)));
                            ++count;
                            long duration = System.currentTimeMillis() - lastOutput;
                            if (duration <= REPORT_DURATION) continue;
                            this.report(info.getName(), count, System.currentTimeMillis() - startTime);
                            lastOutput = System.currentTimeMillis();
                        }
                    }
                    catch (EOFException e) {
                        break;
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void report(String collectionName, long count, long duration) {
        double brate = (double)count / ((double)duration / 1000.0);
        System.out.println(collectionName + ": " + PrintFormat.LONG_FORMAT.format(count) + " records, " + PrintFormat.LONG_FORMAT.format(brate) + " req/sec");
    }

    protected void write(CollectionInfo info, DBObject dbo) throws Exception {
        DB db = MongoDBConnectionManager.getConnection((String)"TARGET", (String)DATABASE_HOST, (String)DATABASE_NAME, (String)DATABASE_USER_NAME, (String)DATABASE_PASSWORD, (int)SchemaType.READ_WRITE());
        DBCollection coll = db.getCollection(info.getName());
        coll.save(dbo);
    }

    private List<CollectionInfo> getCollections() {
        ArrayList<CollectionInfo> collections = new ArrayList<CollectionInfo>();
        try {
            Collection<String> collectionsFromFiles = this.getCollectionNamesFromFiles(INPUT_DIR);
            ArrayList<String> collectionsToAdd = new ArrayList<String>();
            ArrayList<String> collectionsToSkip = new ArrayList<String>();
            this.selectCollections(COLLECTION_STRING, collectionsToAdd, collectionsToSkip);
            boolean exclusionsOnly = collectionsToAdd.contains("*");
            if (exclusionsOnly) {
                for (String collectionName : collectionsFromFiles) {
                    if (collectionsToSkip.contains(collectionName)) continue;
                    collectionsToAdd.add(collectionName);
                }
            } else if (collectionsToAdd.size() == 0) {
                collectionsToAdd.addAll(collectionsFromFiles);
            }
            if (exclusionsOnly) {
                for (String collectionName : collectionsFromFiles) {
                    if (collectionsToSkip.contains(collectionName)) continue;
                    collectionsToAdd.add(collectionName);
                }
            } else if (collectionsToAdd.size() == 0) {
                collectionsToAdd.addAll(collectionsFromFiles);
            }
            for (String collection : collectionsToAdd) {
                if ("*".equals(collection)) continue;
                collections.add(new CollectionInfo(collection, 0L));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return collections;
    }

    private Collection<String> getCollectionNamesFromFiles(String inputDir) {
        File[] files = new File(inputDir).listFiles();
        HashSet<String> collectionNames = new HashSet<String>();
        for (File file : files) {
            StringTokenizer tk;
            if (!file.getName().contains(".bson")) continue;
            int pos = file.getName().indexOf(".bson");
            String collectionName = file.getName().substring(0, pos);
            if (collectionName.indexOf(46) > 0 && (tk = new StringTokenizer(collectionName, ".")).countTokens() > 1) {
                String base = null;
                try {
                    base = tk.nextToken();
                    Integer.parseInt(tk.nextToken());
                    collectionName = base;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            collectionNames.add(collectionName);
        }
        return collectionNames;
    }

    public static boolean parseArgs(String ... args) {
        block9: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(1)) {
                case 'i': {
                    INPUT_DIR = args[++i];
                    continue block9;
                }
                case 'c': {
                    COLLECTION_STRING = args[++i];
                    continue block9;
                }
                case 'D': {
                    DROP_EXISTING = true;
                    continue block9;
                }
                case 'd': {
                    DATABASE_NAME = args[++i];
                    continue block9;
                }
                case 'u': {
                    DATABASE_USER_NAME = args[++i];
                    continue block9;
                }
                case 'p': {
                    DATABASE_PASSWORD = args[++i];
                    continue block9;
                }
                case 'h': {
                    DATABASE_HOST = args[++i];
                    continue block9;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static void usage() {
        System.out.println("usage: RestoreUtil");
        System.out.println(" -i : input directory");
        System.out.println(" -c : CSV collection string (prefix with ! to exclude)");
        System.out.println(" -D : drop existing collections");
        System.out.println(" -h : target database host[:port]");
        System.out.println(" -d : target database name");
        System.out.println(" [-u : target database username]");
        System.out.println(" [-p : target database password]");
    }

    static {
        DROP_EXISTING = false;
        DATABASE_HOST = "localhost";
        DATABASE_NAME = null;
        DATABASE_USER_NAME = null;
        DATABASE_PASSWORD = null;
        REPORT_DURATION = 10000L;
    }

    class FilenameComparator
    implements Comparator<File> {
        FilenameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

