/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.system.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.wordnik.mongo.connection.MongoDBConnectionManager;
import com.wordnik.mongo.connection.SchemaType;
import com.wordnik.system.mongodb.CollectionInfo;
import com.wordnik.system.mongodb.MongoUtil;
import com.wordnik.util.AbstractFileWriter;
import com.wordnik.util.BinaryRotatingFileWriter;
import com.wordnik.util.PrintFormat;
import com.wordnik.util.RotatingFileWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSON;
import org.bson.BSONObject;

public class SnapshotUtil
extends MongoUtil {
    protected static int THREAD_COUNT = 3;
    protected static String COLLECTION_STRING;
    protected static boolean WRITE_JSON;
    protected static String OUTPUT_DIRECTORY;
    protected static String DATABASE_HOST;
    protected static String DATABASE_NAME;
    protected static String DATABASE_USER_NAME;
    protected static String DATABASE_PASSWORD;
    protected static boolean COMPRESS_OUTPUT_FILES;
    protected static int UNCOMPRESSED_FILE_SIZE_MB;
    protected static long WRITES;
    protected static long REPORT_INTERVAL;
    protected static Map<String, AbstractFileWriter> WRITERS;

    public static void main(String ... args) {
        if (!SnapshotUtil.parseArgs(args)) {
            SnapshotUtil.usage();
            return;
        }
        if (DATABASE_NAME == null) {
            SnapshotUtil.usage();
            return;
        }
        new SnapshotUtil().run();
    }

    protected void run() {
        List<CollectionInfo> collections = this.getCollections();
        ArrayList<SnapshotThread> threads = new ArrayList<SnapshotThread>();
        int threadCounter = 0;
        for (CollectionInfo collection : collections) {
            if (threads.size() < threadCounter + 1) {
                SnapshotThread thread = new SnapshotThread(threadCounter);
                thread.setName("backup_thread_" + collection.getName());
                threads.add(thread);
            }
            ((SnapshotThread)threads.get(threadCounter)).add(collection);
            if (++threadCounter < THREAD_COUNT) continue;
            threadCounter = 0;
        }
        for (SnapshotThread thread : threads) {
            thread.start();
        }
        while (true) {
            try {
                boolean isDone;
                do {
                    Thread.sleep(5000L);
                    isDone = true;
                    StringBuilder b = new StringBuilder();
                    for (SnapshotThread thread : threads) {
                        if (thread.isDone) continue;
                        isDone = false;
                        double mbRate = thread.getRate();
                        double complete = thread.getPercentComplete();
                        b.append(thread.currentCollection.getName()).append(": ").append(PrintFormat.PERCENT_FORMAT.format(complete)).append(" (").append(PrintFormat.NUMBER_FORMAT.format(mbRate)).append("mb/s)   ");
                    }
                    System.out.println(b.toString());
                } while (!isDone);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private List<CollectionInfo> getCollections() {
        ArrayList<CollectionInfo> collections = new ArrayList<CollectionInfo>();
        try {
            DB db = MongoDBConnectionManager.getConnection((String)"DB", (String)DATABASE_HOST, (String)DATABASE_NAME, (String)DATABASE_USER_NAME, (String)DATABASE_PASSWORD, (int)SchemaType.READ_WRITE());
            Set collectionsInDb = db.getCollectionNames();
            ArrayList<String> collectionsToAdd = new ArrayList<String>();
            ArrayList<String> collectionsToSkip = new ArrayList<String>();
            this.selectCollections(COLLECTION_STRING, collectionsToAdd, collectionsToSkip);
            boolean exclusionsOnly = collectionsToAdd.contains("*");
            if (exclusionsOnly) {
                for (String collectionName : collectionsInDb) {
                    if (collectionsToSkip.contains(collectionName)) continue;
                    collectionsToAdd.add(collectionName);
                }
            } else if (collectionsToAdd.size() == 0) {
                collectionsToAdd.addAll(collectionsInDb);
            }
            for (String collectionName : collectionsToAdd) {
                long count;
                if ("system.indexes".equals(collectionName) || (count = db.getCollection(collectionName).count()) <= 0L) continue;
                CollectionInfo info = new CollectionInfo(collectionName, count);
                info.setCollectionExists(true);
                collections.add(info);
                String indexName = DATABASE_NAME + "." + collectionName;
                DBCursor cur = db.getCollection("system.indexes").find((DBObject)new BasicDBObject("ns", (Object)indexName));
                if (cur == null) continue;
                while (cur.hasNext()) {
                    info.addIndex((BasicDBObject)cur.next());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return collections;
    }

    public static boolean parseArgs(String ... args) {
        block12: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(1)) {
                case 't': {
                    THREAD_COUNT = Integer.parseInt(args[++i]);
                    continue block12;
                }
                case 'c': {
                    COLLECTION_STRING = args[++i];
                    continue block12;
                }
                case 'o': {
                    OUTPUT_DIRECTORY = args[++i];
                    SnapshotUtil.validateDirectory(OUTPUT_DIRECTORY);
                    continue block12;
                }
                case 's': {
                    UNCOMPRESSED_FILE_SIZE_MB = Integer.parseInt(args[++i]);
                    continue block12;
                }
                case 'Z': {
                    COMPRESS_OUTPUT_FILES = true;
                    continue block12;
                }
                case 'J': {
                    WRITE_JSON = true;
                    continue block12;
                }
                case 'd': {
                    DATABASE_NAME = args[++i];
                    continue block12;
                }
                case 'u': {
                    DATABASE_USER_NAME = args[++i];
                    continue block12;
                }
                case 'p': {
                    DATABASE_PASSWORD = args[++i];
                    continue block12;
                }
                case 'h': {
                    DATABASE_HOST = args[++i];
                    continue block12;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static void usage() {
        System.out.println("usage: SnapshotUtil");
        System.out.println(" -d : database name");
        System.out.println(" -o : output directory");
        System.out.println(" [-c : CSV collection string (prefix with ! to exclude)]");
        System.out.println(" [-h : database host[:port]]");
        System.out.println(" [-t : threads to run (default 3)]");
        System.out.println(" [-u : database username]");
        System.out.println(" [-p : database password]");
        System.out.println(" [-s : max file size in MB]");
        System.out.println(" [-J : output in JSON (default is BSON)]");
        System.out.println(" [-Z : compress files]");
    }

    static {
        WRITE_JSON = false;
        OUTPUT_DIRECTORY = null;
        DATABASE_HOST = "localhost";
        DATABASE_NAME = null;
        DATABASE_USER_NAME = null;
        DATABASE_PASSWORD = null;
        COMPRESS_OUTPUT_FILES = false;
        UNCOMPRESSED_FILE_SIZE_MB = 100;
        WRITES = 0L;
        REPORT_INTERVAL = 10000L;
        WRITERS = new HashMap<String, AbstractFileWriter>();
    }

    class SnapshotThread
    extends Thread {
        long startTime = 0L;
        long lastOutput = 0L;
        int threadId;
        long writes = 0L;
        boolean isDone = false;
        CollectionInfo currentCollection = null;
        List<CollectionInfo> collections = new ArrayList<CollectionInfo>();

        public SnapshotThread(int threadId) {
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (CollectionInfo info : this.collections) {
                this.isDone = false;
                this.writes = 0L;
                this.currentCollection = info;
                try {
                    this.removeSummaryFile(this.currentCollection.getName());
                    this.writeConnectivityDetailString(this.currentCollection.getName());
                    if (this.currentCollection.getIndexes().size() > 0) {
                        this.writeToSummaryFile(this.currentCollection.getName(), "indexes");
                    }
                    for (BasicDBObject index : this.currentCollection.getIndexes()) {
                        this.writeIndexInfoToSummaryFile(this.currentCollection.getName(), index);
                    }
                    this.lastOutput = System.currentTimeMillis();
                    this.startTime = System.currentTimeMillis();
                    DB db = MongoDBConnectionManager.getConnection((String)"DB", (String)DATABASE_HOST, (String)DATABASE_NAME, (String)DATABASE_USER_NAME, (String)DATABASE_PASSWORD, (int)SchemaType.READ_WRITE());
                    DBCollection collection = db.getCollection(this.currentCollection.getName());
                    DBCursor cursor = null;
                    cursor = collection.find();
                    cursor.sort((DBObject)new BasicDBObject("_id", (Object)1));
                    while (cursor.hasNext()) {
                        BasicDBObject x = (BasicDBObject)cursor.next();
                        ++this.writes;
                        this.processRecord(this.currentCollection.getName(), x);
                    }
                    this.close(this.currentCollection.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.isDone = true;
                }
            }
        }

        public void processRecord(String collectionName, BasicDBObject dbo) throws Exception {
            if (WRITE_JSON) {
                RotatingFileWriter writer = (RotatingFileWriter)WRITERS.get(collectionName);
                if (writer == null) {
                    writer = new RotatingFileWriter(collectionName, OUTPUT_DIRECTORY, "json", (long)UNCOMPRESSED_FILE_SIZE_MB * 0x100000L, COMPRESS_OUTPUT_FILES);
                    WRITERS.put(collectionName, writer);
                }
                writer.write(dbo.toString());
            } else {
                BinaryRotatingFileWriter writer = (BinaryRotatingFileWriter)WRITERS.get(collectionName);
                if (writer == null) {
                    writer = new BinaryRotatingFileWriter(collectionName, OUTPUT_DIRECTORY, "bson", (long)UNCOMPRESSED_FILE_SIZE_MB * 0x100000L, COMPRESS_OUTPUT_FILES);
                    WRITERS.put(collectionName, writer);
                }
                writer.write(BSON.encode((BSONObject)dbo));
            }
        }

        public void close(String collectionName) throws IOException {
            AbstractFileWriter writer = WRITE_JSON ? (RotatingFileWriter)WRITERS.get(collectionName) : WRITERS.get(collectionName);
            if (writer != null) {
                writer.close();
            }
        }

        public double getPercentComplete() {
            return (double)this.writes / (double)this.currentCollection.getCount();
        }

        public double getRate() {
            AbstractFileWriter writer = WRITERS.get(this.currentCollection.getName());
            if (writer != null) {
                long bytesWritten = writer.getTotalBytesWritten();
                double brate = (double)bytesWritten / ((double)(System.currentTimeMillis() - this.startTime) / 1000.0) / 1048576.0;
                this.lastOutput = System.currentTimeMillis();
                return brate;
            }
            return 0.0;
        }

        public void add(CollectionInfo info) {
            this.collections.add(info);
        }

        protected void removeSummaryFile(String name) {
            File file;
            if (OUTPUT_DIRECTORY != null) {
                name = OUTPUT_DIRECTORY + File.separator + name;
            }
            if ((file = new File(name + ".txt")).exists() && !file.delete()) {
                throw new RuntimeException("unable to remove summary file");
            }
        }

        protected void writeConnectivityDetailString(String collectionName) throws IOException {
            this.writeToSummaryFile(collectionName, "##########################################");
            this.writeToSummaryFile(collectionName, "##\texport created on " + new Date());
            this.writeToSummaryFile(collectionName, "##\thost: " + DATABASE_HOST);
            this.writeToSummaryFile(collectionName, "##\tdatabase: " + DATABASE_NAME);
            this.writeToSummaryFile(collectionName, "##\tcollection: " + collectionName);
            this.writeToSummaryFile(collectionName, "##########################################");
        }

        protected void writeObjectToSummaryFile(String collectionName, BasicDBObject comment) throws IOException {
            this.writeToSummaryFile(collectionName, comment.toString());
        }

        protected void writeToSummaryFile(String collectionName, String comment) throws IOException {
            if (OUTPUT_DIRECTORY != null) {
                collectionName = OUTPUT_DIRECTORY + File.separator + collectionName;
            }
            String filename = collectionName + ".txt";
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(new File(filename), true));
            writer.write(comment.toString());
            writer.write("\n");
            ((Writer)writer).close();
        }

        protected void writeIndexInfoToSummaryFile(String collectionName, BasicDBObject index) throws IOException {
            BasicDBObject i = (BasicDBObject)index.get("key");
            if (!i.containsField("_id")) {
                this.writeToSummaryFile(collectionName, i.toString());
            }
        }
    }
}

