/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.util;

import com.wordnik.util.FileCompressionThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public abstract class AbstractFileWriter {
    protected String filePrefix;
    protected String destinationDirectory;
    protected String extension;
    protected boolean compressOnRotate = false;
    protected long totalBytesWritten;
    protected long maxFileSizeInBytes;
    protected long currentFileSize;

    public AbstractFileWriter(String filePrefix, String destinationDirectory, String extension, long maxFileSizeInBytes, boolean compressOnRotate) {
        File file;
        this.filePrefix = filePrefix;
        this.destinationDirectory = destinationDirectory;
        this.extension = extension;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.compressOnRotate = compressOnRotate;
        if (destinationDirectory != null && !(file = new File(destinationDirectory)).exists() && !file.mkdir()) {
            throw new RuntimeException("output directory doesn't exist and cannot be created");
        }
    }

    abstract boolean hasWriter();

    public abstract void closeWriter() throws IOException;

    String getFilename() {
        return this.filePrefix + "." + this.extension;
    }

    String getFilename(String increment) {
        return this.filePrefix + "." + increment + "." + this.extension;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    String getPath(String filename) {
        if (this.destinationDirectory != null) {
            return this.destinationDirectory + File.separator + filename;
        }
        return filename;
    }

    String getNextIncrement() throws IOException {
        File[] files = null;
        files = this.destinationDirectory == null ? new File(this.getPath(new File(".").getCanonicalPath())).listFiles() : new File(this.getPath("")).listFiles();
        if (files == null) {
            return "0000";
        }
        int lastInc = 0;
        block2: for (File file : files) {
            StringTokenizer tk;
            if (!file.getName().startsWith(this.filePrefix) || (tk = new StringTokenizer(file.getName(), ".")).countTokens() <= 2) continue;
            tk.nextToken();
            while (tk.hasMoreTokens()) {
                try {
                    String sub = tk.nextToken();
                    int inc = Integer.parseInt(sub);
                    if (inc <= lastInc) continue block2;
                    lastInc = inc;
                    continue block2;
                }
                catch (NumberFormatException ex) {
                }
            }
        }
        DecimalFormat nf = new DecimalFormat("0000");
        return nf.format(lastInc + 1);
    }

    public void close() throws IOException {
        this.rotateFile();
        this.closeWriter();
    }

    void rotateFile() throws IOException {
        if (!this.hasWriter()) {
            return;
        }
        this.closeWriter();
        this.currentFileSize = 0L;
        File file = new File(this.getPath(this.getFilename()));
        String outputFilename = this.getFilename(this.getNextIncrement());
        file.renameTo(new File(this.getPath(outputFilename)));
        if (this.compressOnRotate) {
            new FileCompressionThread(this.getPath(outputFilename)).start();
        }
        this.resetWriter();
    }

    OutputStream getOutputStream(String filePrefix) throws IOException {
        File file = new File(this.getPath(this.getFilename()));
        if (this.hasWriter()) {
            try {
                this.closeWriter();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file.exists()) {
            file.renameTo(new File(this.getPath(this.getFilename(this.getNextIncrement()))));
        }
        return new FileOutputStream(new File(this.getPath(this.getFilename())));
    }

    abstract void resetWriter();
}

