/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.util;

import com.wordnik.util.AbstractFileWriter;
import java.io.IOException;
import java.io.OutputStream;

public class BinaryRotatingFileWriter
extends AbstractFileWriter {
    OutputStream os = null;

    public BinaryRotatingFileWriter(String filePrefix, String destinationDirectory, String extension, long maxFileSizeInBytes, boolean compressOnRotate) {
        super(filePrefix, destinationDirectory, extension, maxFileSizeInBytes, compressOnRotate);
    }

    public void write(byte[] bytesToWrite) throws IOException {
        this.getOutputStream().write(bytesToWrite);
        int sz = bytesToWrite.length;
        this.currentFileSize += (long)sz;
        this.totalBytesWritten += (long)sz;
        if (this.currentFileSize > this.maxFileSizeInBytes) {
            this.rotateFile();
        }
    }

    OutputStream getOutputStream() throws IOException {
        if (!this.hasWriter()) {
            this.os = this.getOutputStream(this.filePrefix);
        }
        return this.os;
    }

    @Override
    public void closeWriter() throws IOException {
        if (this.hasWriter()) {
            this.os.close();
        }
    }

    @Override
    boolean hasWriter() {
        return this.os != null;
    }

    @Override
    void resetWriter() {
        if (this.hasWriter()) {
            this.os = null;
        }
    }
}

