/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.util;

import com.wordnik.util.AbstractFileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class RotatingFileWriter
extends AbstractFileWriter {
    Writer writer;

    public RotatingFileWriter(String filePrefix, String destinationDirectory, String extension, long maxFileSizeInBytes, boolean compressOnRotate) {
        super(filePrefix, destinationDirectory, extension, maxFileSizeInBytes, compressOnRotate);
    }

    public void write(String stringToWrite) throws IOException {
        this.getWriter().write(stringToWrite + "\n");
        int sz = stringToWrite.length();
        this.currentFileSize += (long)sz;
        this.totalBytesWritten += (long)sz;
        if (this.currentFileSize > this.maxFileSizeInBytes) {
            this.rotateFile();
        }
    }

    @Override
    public void close() throws IOException {
        this.rotateFile();
    }

    Writer getWriter() throws IOException {
        if (!this.hasWriter()) {
            this.openFile(this.filePrefix);
        }
        return this.writer;
    }

    @Override
    boolean hasWriter() {
        return this.writer != null;
    }

    @Override
    public void closeWriter() throws IOException {
        if (this.hasWriter()) {
            this.writer.close();
        }
    }

    Writer openFile(String prefix) throws IOException {
        this.writer = new OutputStreamWriter(this.getOutputStream(prefix), "UTF-8");
        this.currentFileSize = 0L;
        return this.writer;
    }

    @Override
    void resetWriter() {
        if (this.hasWriter()) {
            this.writer = null;
        }
    }
}

