/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.hibernate;

import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.io.IOException;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;

public abstract class AbstractHibernateTestService {
    public static DataStore dataStore = null;
    protected final JsonApiMapper jsonApiMapper = new JsonApiMapper(new EntityDictionary());

    public static DataStore getDatabaseManager() {
        if (dataStore == null) {
            try {
                String dataStoreSupplierName = System.getProperty("dataStoreSupplier");
                Supplier dataStoreSupplier = (Supplier)Class.forName(dataStoreSupplierName).newInstance();
                dataStore = (DataStore)dataStoreSupplier.get();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        return dataStore;
    }

    @BeforeTest
    public static void initHibernate() {
        AbstractHibernateTestService.getDatabaseManager();
    }

    protected void assertEqualDocuments(String actual, String expected) {
        try {
            JsonApiDocument expectedDoc = this.jsonApiMapper.readJsonApiDocument(expected);
            JsonApiDocument actualDoc = this.jsonApiMapper.readJsonApiDocument(actual);
            Assert.assertEquals((Object)actualDoc, (Object)expectedDoc, (String)("\n" + actual + "\n" + expected + "\n"));
        }
        catch (IOException e) {
            Assert.fail((String)("\n" + actual + "\n" + expected + "\n"), (Throwable)e);
        }
    }
}

