/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.yahoo.elide.core.exceptions.InvalidPredicateException;
import com.yahoo.elide.core.filter.FilterOperation;
import com.yahoo.elide.core.filter.Predicate;
import java.util.Set;

public class HQLFilterOperation
implements FilterOperation<String> {
    public String apply(Predicate predicate) {
        switch (predicate.getOperator()) {
            case IN: {
                return String.format("%s IN (:%s)", predicate.getField(), predicate.getField());
            }
            case NOT: {
                return String.format("%s NOT IN (:%s)", predicate.getField(), predicate.getField());
            }
            case PREFIX: {
                return String.format("%s LIKE CONCAT(:%s, '%%')", predicate.getField(), predicate.getField());
            }
            case POSTFIX: {
                return String.format("%s LIKE CONCAT('%%', :%s)", predicate.getField(), predicate.getField());
            }
            case INFIX: {
                return String.format("%s LIKE CONCAT('%%', :%s, '%%')", predicate.getField(), predicate.getField());
            }
            case ISNULL: {
                return String.format("%s IS NULL", predicate.getField());
            }
            case NOTNULL: {
                return String.format("%s IS NOT NULL", predicate.getField());
            }
        }
        throw new InvalidPredicateException("Operator not implemented: " + predicate.getOperator());
    }

    public String applyAll(Set<Predicate> predicates) {
        StringBuilder filterString = new StringBuilder();
        for (Predicate predicate : predicates) {
            if (filterString.length() == 0) {
                filterString.append("WHERE ");
            } else {
                filterString.append(" AND ");
            }
            filterString.append(this.apply(predicate));
        }
        return filterString.toString();
    }
}

