/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.filter.CaseAwareJPQLGenerator;
import com.yahoo.elide.core.filter.FilterOperation;
import com.yahoo.elide.core.filter.JPQLPredicateGenerator;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.utils.TypeHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class FilterTranslator
implements FilterOperation<String> {
    private static final String COMMA = ", ";
    private static Map<Operator, JPQLPredicateGenerator> operatorGenerators;
    private static Map<Triple<Operator, Class<?>, String>, JPQLPredicateGenerator> predicateOverrides;
    public static final Function<FilterPredicate, String> GENERATE_HQL_COLUMN_NO_ALIAS;
    public static final Function<FilterPredicate, String> GENERATE_HQL_COLUMN_WITH_ALIAS;

    public static void registerJPQLGenerator(Operator op, JPQLPredicateGenerator generator) {
        operatorGenerators.put(op, generator);
    }

    public static void registerJPQLGenerator(Operator op, Class<?> entityClass, String fieldName, JPQLPredicateGenerator generator) {
        predicateOverrides.put(Triple.of((Object)op, entityClass, (Object)fieldName), generator);
    }

    public static JPQLPredicateGenerator lookupJPQLGenerator(Operator op, Class<?> entityClass, String fieldName) {
        return predicateOverrides.get(Triple.of((Object)op, entityClass, (Object)fieldName));
    }

    public static JPQLPredicateGenerator lookupJPQLGenerator(Operator op) {
        return operatorGenerators.get(op);
    }

    public String apply(FilterPredicate filterPredicate) {
        return this.apply(filterPredicate, GENERATE_HQL_COLUMN_NO_ALIAS);
    }

    protected String apply(FilterPredicate filterPredicate, Function<FilterPredicate, String> columnGenerator) {
        String fieldPath = columnGenerator.apply(filterPredicate);
        Path.PathElement last = (Path.PathElement)filterPredicate.getPath().lastElement().get();
        fieldPath = fieldPath.replaceAll("\\.this", "");
        List params = filterPredicate.getParameters();
        Operator op = filterPredicate.getOperator();
        JPQLPredicateGenerator generator = FilterTranslator.lookupJPQLGenerator(op, last.getType(), last.getFieldName());
        if (generator == null) {
            generator = FilterTranslator.lookupJPQLGenerator(op);
        }
        if (generator == null) {
            throw new BadRequestException("Operator not implemented: " + filterPredicate.getOperator());
        }
        return generator.generate(fieldPath, params);
    }

    private static String greatestClause(List<FilterPredicate.FilterParameter> params) {
        return String.format("greatest(%s)", params.stream().map(FilterPredicate.FilterParameter::getPlaceholder).collect(Collectors.joining(COMMA)));
    }

    private static String leastClause(List<FilterPredicate.FilterParameter> params) {
        return String.format("least(%s)", params.stream().map(FilterPredicate.FilterParameter::getPlaceholder).collect(Collectors.joining(COMMA)));
    }

    public String apply(FilterExpression filterExpression, boolean prefixWithAlias) {
        Function<FilterPredicate, String> columnGenerator = GENERATE_HQL_COLUMN_NO_ALIAS;
        if (prefixWithAlias) {
            columnGenerator = GENERATE_HQL_COLUMN_WITH_ALIAS;
        }
        return this.apply(filterExpression, columnGenerator);
    }

    public String apply(FilterExpression filterExpression, Function<FilterPredicate, String> columnGenerator) {
        JPQLQueryVisitor visitor = new JPQLQueryVisitor(columnGenerator);
        return (String)filterExpression.accept((FilterExpressionVisitor)visitor);
    }

    static {
        GENERATE_HQL_COLUMN_NO_ALIAS = FilterPredicate::getFieldPath;
        GENERATE_HQL_COLUMN_WITH_ALIAS = predicate -> TypeHelper.getFieldAlias((String)TypeHelper.getPathAlias((Path)predicate.getPath()), (String)predicate.getField());
        predicateOverrides = new HashMap();
        operatorGenerators = new HashMap<Operator, JPQLPredicateGenerator>();
        operatorGenerators.put(Operator.IN, new CaseAwareJPQLGenerator("%s IN (%s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.IN_INSENSITIVE, new CaseAwareJPQLGenerator("%s IN (%s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.NOT, new CaseAwareJPQLGenerator("%s NOT IN (%s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.NOT_INSENSITIVE, new CaseAwareJPQLGenerator("%s NOT IN (%s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        operatorGenerators.put(Operator.PREFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.PREFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.POSTFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.POSTFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.INFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s, '%%')", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.INFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s, '%%')", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        operatorGenerators.put(Operator.LT, (columnAlias, params) -> {
            Preconditions.checkState((!params.isEmpty() ? 1 : 0) != 0);
            return String.format("%s < %s", columnAlias, params.size() == 1 ? ((FilterPredicate.FilterParameter)params.get(0)).getPlaceholder() : FilterTranslator.leastClause(params));
        });
        operatorGenerators.put(Operator.LE, (columnAlias, params) -> {
            Preconditions.checkState((!params.isEmpty() ? 1 : 0) != 0);
            return String.format("%s <= %s", columnAlias, params.size() == 1 ? ((FilterPredicate.FilterParameter)params.get(0)).getPlaceholder() : FilterTranslator.leastClause(params));
        });
        operatorGenerators.put(Operator.GT, (columnAlias, params) -> {
            Preconditions.checkState((!params.isEmpty() ? 1 : 0) != 0);
            return String.format("%s > %s", columnAlias, params.size() == 1 ? ((FilterPredicate.FilterParameter)params.get(0)).getPlaceholder() : FilterTranslator.greatestClause(params));
        });
        operatorGenerators.put(Operator.GE, (columnAlias, params) -> {
            Preconditions.checkState((!params.isEmpty() ? 1 : 0) != 0);
            return String.format("%s >= %s", columnAlias, params.size() == 1 ? ((FilterPredicate.FilterParameter)params.get(0)).getPlaceholder() : FilterTranslator.greatestClause(params));
        });
        operatorGenerators.put(Operator.ISNULL, (columnAlias, params) -> String.format("%s IS NULL", columnAlias));
        operatorGenerators.put(Operator.NOTNULL, (columnAlias, params) -> String.format("%s IS NOT NULL", columnAlias));
        operatorGenerators.put(Operator.TRUE, (columnAlias, params) -> "(1 = 1)");
        operatorGenerators.put(Operator.FALSE, (columnAlias, params) -> "(1 = 0)");
        operatorGenerators.put(Operator.ISEMPTY, (columnAlias, params) -> String.format("%s IS EMPTY", columnAlias));
        operatorGenerators.put(Operator.NOTEMPTY, (columnAlias, params) -> String.format("%s IS NOT EMPTY", columnAlias));
        operatorGenerators.put(Operator.HASMEMBER, (columnAlias, params) -> {
            Preconditions.checkArgument((params.size() == 1 ? 1 : 0) != 0);
            return String.format("%s MEMBER OF %s", ((FilterPredicate.FilterParameter)params.get(0)).getPlaceholder(), columnAlias);
        });
        operatorGenerators.put(Operator.HASNOMEMBER, (columnAlias, params) -> {
            Preconditions.checkArgument((params.size() == 1 ? 1 : 0) != 0);
            return String.format("%s NOT MEMBER OF %s", ((FilterPredicate.FilterParameter)params.get(0)).getPlaceholder(), columnAlias);
        });
    }

    public class JPQLQueryVisitor
    implements FilterExpressionVisitor<String> {
        private Function<FilterPredicate, String> columnGenerator;

        public JPQLQueryVisitor(Function<FilterPredicate, String> columnGenerator) {
            this.columnGenerator = columnGenerator;
        }

        public String visitPredicate(FilterPredicate filterPredicate) {
            return FilterTranslator.this.apply(filterPredicate, this.columnGenerator);
        }

        public String visitAndExpression(AndFilterExpression expression) {
            FilterExpression left = expression.getLeft();
            FilterExpression right = expression.getRight();
            return "(" + (String)left.accept((FilterExpressionVisitor)this) + " AND " + (String)right.accept((FilterExpressionVisitor)this) + ")";
        }

        public String visitOrExpression(OrFilterExpression expression) {
            FilterExpression left = expression.getLeft();
            FilterExpression right = expression.getRight();
            return "(" + (String)left.accept((FilterExpressionVisitor)this) + " OR " + (String)right.accept((FilterExpressionVisitor)this) + ")";
        }

        public String visitNotExpression(NotFilterExpression expression) {
            String negated = (String)expression.getNegated().accept((FilterExpressionVisitor)this);
            return "NOT (" + negated + ")";
        }
    }
}

