/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.utils.TypeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHQLQueryBuilder {
    protected final Session session;
    protected final EntityDictionary dictionary;
    protected EntityProjection entityProjection;
    protected static final String SPACE = " ";
    protected static final String PERIOD = ".";
    protected static final String COMMA = ",";
    protected static final String FROM = " FROM ";
    protected static final String JOIN = " JOIN ";
    protected static final String LEFT = " LEFT";
    protected static final String FETCH = " FETCH ";
    protected static final String SELECT = "SELECT ";
    protected static final String AS = " AS ";
    protected static final String DISTINCT = "DISTINCT ";
    protected static final String WHERE = " WHERE ";
    protected static final boolean USE_ALIAS = true;
    protected static final boolean NO_ALIAS = false;
    protected Set<String> alreadyJoined = new HashSet<String>();

    public AbstractHQLQueryBuilder(EntityProjection entityProjection, EntityDictionary dictionary, Session session) {
        this.session = session;
        this.dictionary = dictionary;
        this.entityProjection = entityProjection;
    }

    public abstract Query build();

    protected void supplyFilterQueryParameters(Query query, Collection<FilterPredicate> predicates) {
        for (FilterPredicate filterPredicate : predicates) {
            if (!filterPredicate.getOperator().isParameterized()) continue;
            boolean shouldEscape = filterPredicate.isMatchingOperator();
            filterPredicate.getParameters().forEach(param -> query.setParameter(param.getName(), shouldEscape ? param.escapeMatching() : param.getValue()));
        }
    }

    protected String getJoinClauseFromFilters(FilterExpression filterExpression) {
        return this.getJoinClauseFromFilters(filterExpression, false);
    }

    protected String getJoinClauseFromFilters(FilterExpression filterExpression, boolean skipFetches) {
        PredicateExtractionVisitor visitor = new PredicateExtractionVisitor(new ArrayList());
        Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)visitor);
        return predicates.stream().map(predicate -> this.extractJoinClause(predicate.getPath(), skipFetches)).collect(Collectors.joining(SPACE));
    }

    protected String getJoinClauseFromSort(Sorting sorting) {
        return this.getJoinClauseFromSort(sorting, false);
    }

    protected String getJoinClauseFromSort(Sorting sorting, boolean skipFetches) {
        if (sorting != null && !sorting.isDefaultInstance()) {
            Map validSortingRules = sorting.getSortingPaths();
            return validSortingRules.keySet().stream().map(path -> this.extractJoinClause((Path)path, skipFetches)).collect(Collectors.joining(SPACE));
        }
        return "";
    }

    protected void addPaginationToQuery(Query query) {
        Pagination pagination = this.entityProjection.getPagination();
        if (pagination != null) {
            query.setFirstResult(pagination.getOffset());
            query.setMaxResults(pagination.getLimit());
        }
    }

    private String extractJoinClause(Path path, boolean skipFetches) {
        StringBuilder joinClause = new StringBuilder();
        String previousAlias = null;
        for (Path.PathElement pathElement : path.getPathElements()) {
            String fieldName = pathElement.getFieldName();
            Class typeClass = this.dictionary.lookupEntityClass(pathElement.getType());
            String typeAlias = TypeHelper.getTypeAlias((Class)typeClass);
            if (!this.dictionary.isRelation(pathElement.getType(), fieldName)) {
                return joinClause.toString();
            }
            String alias = previousAlias == null ? TypeHelper.appendAlias((String)typeAlias, (String)fieldName) : TypeHelper.appendAlias(previousAlias, (String)fieldName);
            String joinKey = previousAlias == null ? typeAlias + PERIOD + fieldName : previousAlias + PERIOD + fieldName;
            String fetch = "";
            RelationshipType type = this.dictionary.getRelationshipType(pathElement.getType(), fieldName);
            if (!skipFetches && this.entityProjection.getIncludedRelationsName().contains(fieldName) && type.isToOne() && !type.isComputed() && previousAlias == null) {
                fetch = "FETCH ";
            }
            String joinFragment = " LEFT JOIN " + fetch + joinKey + SPACE + alias + SPACE;
            if (!this.alreadyJoined.contains(joinKey)) {
                joinClause.append(joinFragment);
                this.alreadyJoined.add(joinKey);
            }
            previousAlias = alias;
        }
        return joinClause.toString();
    }

    protected String extractToOneMergeJoins(Class<?> entityClass, String alias) {
        return this.extractToOneMergeJoins(entityClass, alias, unused -> false);
    }

    protected String extractToOneMergeJoins(Class<?> entityClass, String alias, Function<String, Boolean> skipRelation) {
        List relationshipNames = this.dictionary.getRelationships(entityClass);
        StringBuilder joinString = new StringBuilder("");
        for (String relationshipName : relationshipNames) {
            String joinKey;
            RelationshipType type;
            if (!this.entityProjection.getIncludedRelationsName().contains(relationshipName) || !(type = this.dictionary.getRelationshipType(entityClass, relationshipName)).isToOne() || type.isComputed() || skipRelation.apply(relationshipName).booleanValue() || this.alreadyJoined.contains(joinKey = alias + PERIOD + relationshipName)) continue;
            joinString.append(" LEFT JOIN FETCH ");
            joinString.append(joinKey);
            joinString.append(SPACE);
            this.alreadyJoined.add(joinKey);
        }
        return joinString.toString();
    }

    protected String getSortClause(Sorting sorting) {
        Map validSortingRules;
        String sortingRules = "";
        if (sorting != null && !sorting.isDefaultInstance() && !(validSortingRules = sorting.getSortingPaths()).isEmpty()) {
            ArrayList ordering = new ArrayList();
            validSortingRules.forEach((path, order) -> {
                String previousAlias = null;
                String aliasedFieldName = null;
                for (Path.PathElement pathElement : path.getPathElements()) {
                    String fieldName = pathElement.getFieldName();
                    Class typeClass = this.dictionary.lookupEntityClass(pathElement.getType());
                    previousAlias = previousAlias == null ? TypeHelper.getTypeAlias((Class)typeClass) : previousAlias;
                    aliasedFieldName = previousAlias + PERIOD + fieldName;
                    if (!this.dictionary.isRelation(pathElement.getType(), fieldName)) break;
                    previousAlias = TypeHelper.appendAlias((String)previousAlias, (String)fieldName);
                }
                ordering.add(aliasedFieldName + SPACE + (order.equals((Object)Sorting.SortOrder.desc) ? "desc" : "asc"));
            });
            sortingRules = " order by " + StringUtils.join(ordering, (String)COMMA);
        }
        return sortingRules;
    }

    protected boolean containsOneToMany(FilterExpression filterExpression) {
        PredicateExtractionVisitor visitor = new PredicateExtractionVisitor(new ArrayList());
        Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)visitor);
        return predicates.stream().anyMatch(predicate -> FilterPredicate.toManyInPath((EntityDictionary)this.dictionary, (Path)predicate.getPath()));
    }

    public static interface Relationship {
        public com.yahoo.elide.core.request.Relationship getRelationship();

        public Class<?> getParentType();

        default public Class<?> getChildType() {
            return this.getRelationship().getProjection().getType();
        }

        default public String getRelationshipName() {
            return this.getRelationship().getName();
        }

        public Object getParent();
    }
}

